/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.TrustManagerFactory;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.DefaultClient;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature.DefaultActorTracker;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature.DefaultAuthManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature.DefaultCapabilityManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature.DefaultEventManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature.DefaultISupportManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature.DefaultMessageTagManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature.DefaultServerInfo;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.ActorTracker;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.AuthManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.CapabilityManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.EventManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.ISupportManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.MessageTagManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.ServerInfo;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.defaultmessage.DefaultMessageMap;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sending.MessageSendingQueue;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sending.SingleDelaySender;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsStorageManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.AcceptingTrustManagerFactory;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Version;

public class DefaultBuilder
implements Client.Builder {
    private static final int DEFAULT_SERVER_PORT = 6697;
    private static final String DEFAULT_SERVER_HOST = "localhost";
    @Nullable
    private String bindHost;
    private int bindPort;
    private String serverHost = "localhost";
    private int serverPort = 6697;
    private String name = "Unnamed";
    @Nullable
    private DefaultMessageMap defaultMessageMap = null;
    @Nullable
    private Consumer<Exception> exceptionListener = Throwable::printStackTrace;
    @Nullable
    private Consumer<String> inputListener = null;
    @Nullable
    private Consumer<String> outputListener = null;
    private Function<Client.WithManagement, ? extends ActorTracker> actorTracker = DefaultActorTracker::new;
    private Function<Client.WithManagement, ? extends AuthManager> authManager = DefaultAuthManager::new;
    private Function<Client.WithManagement, ? extends CapabilityManager.WithManagement> capabilityManager = DefaultCapabilityManager::new;
    private Function<Client.WithManagement, ? extends EventManager> eventManager = DefaultEventManager::new;
    private Function<Client.WithManagement, ? extends ISupportManager> iSupportManager = DefaultISupportManager::new;
    private Function<Client.WithManagement, ? extends MessageSendingQueue> messageSendingQueue = SingleDelaySender.getSupplier(1200);
    private Function<Client.WithManagement, ? extends MessageTagManager> messageTagManager = DefaultMessageTagManager::new;
    private String nick = "Kitteh";
    private String realName = "KICL " + Version.getVersion() + " - kitteh.org";
    private Function<Client.WithManagement, ? extends ServerInfo.WithManagement> serverInfo = DefaultServerInfo::new;
    @Nullable
    private String serverPassword = null;
    private boolean secure = true;
    @Nullable
    private Path secureKeyCertChain = null;
    @Nullable
    private Path secureKey = null;
    @Nullable
    private String secureKeyPassword = null;
    @Nullable
    private TrustManagerFactory secureTrustManagerFactory = null;
    @Nullable
    private StsStorageManager stsStorageManager = null;
    private String userString = "Kitteh";
    @Nullable
    private String webircHost = null;
    @Nullable
    private InetAddress webircIP = null;
    @Nullable
    private String webircPassword = null;
    @Nullable
    private String webircUser = null;

    @Override
    @Nonnull
    public Client.Builder actorTracker(@Nonnull Function<Client.WithManagement, ? extends ActorTracker> supplier) {
        this.actorTracker = Sanity.nullCheck(supplier, "Actor provider supplier cannot be null");
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder bindHost(@Nullable String host) {
        this.bindHost = host;
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder bindPort(int port) {
        this.bindPort = this.isValidPort(port);
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder defaultMessageMap(@Nonnull DefaultMessageMap defaultMessageMap) {
        this.defaultMessageMap = defaultMessageMap;
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder exceptionListener(@Nullable Consumer<Exception> listener) {
        this.exceptionListener = listener;
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder inputListener(@Nullable Consumer<String> listener) {
        this.inputListener = listener;
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder outputListener(@Nullable Consumer<String> listener) {
        this.outputListener = listener;
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder messageSendingQueueSupplier(@Nonnull Function<Client.WithManagement, ? extends MessageSendingQueue> supplier) {
        this.messageSendingQueue = Sanity.nullCheck(supplier, "Supplier cannot be null");
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder messageTagManager(@Nonnull Function<Client.WithManagement, ? extends MessageTagManager> supplier) {
        this.messageTagManager = supplier;
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder name(@Nonnull String name) {
        this.name = Sanity.safeMessageCheck(name, "Name");
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder nick(@Nonnull String nick) {
        Sanity.safeMessageCheck(nick, "Nick");
        Sanity.truthiness(!nick.contains(" "), "Nick cannot contain spaces");
        this.nick = nick;
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder serverPassword(@Nullable String password) {
        this.serverPassword = password;
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder realName(@Nonnull String name) {
        this.realName = Sanity.safeMessageCheck(name, "Real name");
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder secure(boolean secure) {
        this.secure = secure;
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder secureKeyCertChain(@Nullable Path keyCertChainFile) {
        this.secureKeyCertChain = keyCertChainFile;
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder secureKey(@Nullable Path keyFile) {
        this.secureKey = keyFile;
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder secureKeyPassword(@Nullable String password) {
        this.secureKeyPassword = password;
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder secureTrustManagerFactory(@Nullable TrustManagerFactory factory) {
        this.secureTrustManagerFactory = factory;
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder serverHost(@Nonnull String host) {
        this.serverHost = Sanity.nullCheck(host, "Host cannot be null");
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder serverPort(int port) {
        this.serverPort = this.isValidPort(port);
        return this;
    }

    @Override
    @Nonnull
    public Client.Builder authManager(@Nonnull Function<Client.WithManagement, ? extends AuthManager> supplier) {
        this.authManager = Sanity.nullCheck(supplier, "Supplier cannot be null");
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder capabilityManager(@Nonnull Function<Client.WithManagement, ? extends CapabilityManager.WithManagement> supplier) {
        this.capabilityManager = Sanity.nullCheck(supplier, "Supplier cannot be null");
        return this;
    }

    @Override
    @Nonnull
    public Client.Builder eventManager(@Nonnull Function<Client.WithManagement, ? extends EventManager> supplier) {
        this.eventManager = Sanity.nullCheck(supplier, "Supplier cannot be null");
        return this;
    }

    @Override
    @Nonnull
    public Client.Builder iSupportManager(@Nonnull Function<Client.WithManagement, ? extends ISupportManager> supplier) {
        this.iSupportManager = Sanity.nullCheck(supplier, "Supplier cannot be null");
        return this;
    }

    @Override
    @Nonnull
    public Client.Builder serverInfo(@Nonnull Function<Client.WithManagement, ? extends ServerInfo.WithManagement> supplier) {
        this.serverInfo = Sanity.nullCheck(supplier, "Supplier cannot be null");
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder user(@Nonnull String user) {
        Sanity.safeMessageCheck(user, "User");
        Sanity.truthiness(!user.contains(" "), "User cannot contain spaces");
        this.userString = user;
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder webirc(@Nonnull String password, @Nonnull String user, @Nonnull String host, @Nonnull InetAddress ip) {
        Sanity.safeMessageCheck(password, "Password");
        Sanity.safeMessageCheck(user, "User");
        Sanity.safeMessageCheck(host, "Host");
        Sanity.nullCheck(ip, "IP cannot be null");
        Sanity.truthiness(!password.contains(" "), "Password cannot contain spaces");
        Sanity.truthiness(!user.contains(" "), "User cannot contain spaces");
        Sanity.truthiness(!host.contains(" "), "Host cannot contain spaces");
        this.webircPassword = password;
        this.webircUser = user;
        this.webircHost = host;
        this.webircIP = ip;
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder webircRemove() {
        this.webircPassword = null;
        this.webircUser = null;
        this.webircHost = null;
        this.webircIP = null;
        return this;
    }

    @Override
    @Nonnull
    public DefaultBuilder stsStorageManager(@Nullable StsStorageManager storageManager) {
        this.stsStorageManager = storageManager;
        return this;
    }

    @Override
    @Nonnull
    public Client build() {
        if (this.stsStorageManager != null) {
            Sanity.truthiness(!AcceptingTrustManagerFactory.isInsecure(this.secureTrustManagerFactory), "Cannot use STS with an insecure trust manager.");
        }
        DefaultClient client = new DefaultClient();
        client.initialize(this.name, this.getInetSocketAddress(this.serverHost, this.serverPort), this.serverPassword, this.getInetSocketAddress(this.bindHost, this.bindPort), this.nick, this.userString, this.realName, this.actorTracker.apply(client), this.authManager.apply(client), this.capabilityManager.apply(client), this.eventManager.apply(client), this.messageTagManager.apply(client), this.iSupportManager.apply(client), this.defaultMessageMap, this.messageSendingQueue, this.serverInfo, this.exceptionListener, this.inputListener, this.outputListener, this.secure, this.secureKeyCertChain, this.secureKey, this.secureKeyPassword, this.secureTrustManagerFactory, this.stsStorageManager, this.webircHost, this.webircIP, this.webircPassword, this.webircUser);
        return client;
    }

    @Override
    @Nonnull
    public Client buildAndConnect() {
        Client client = this.build();
        client.connect();
        return client;
    }

    @Nonnull
    public String toString() {
        return new ToStringer(this).toString();
    }

    private InetSocketAddress getInetSocketAddress(@Nullable String host, int port) {
        if (host != null) {
            return new InetSocketAddress(host, port);
        }
        return new InetSocketAddress(port);
    }

    private int isValidPort(int port) {
        return port > 65535 || port < 0 ? 0 : port;
    }
}

