/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.command;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.Command;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class WhoisCommand
extends Command {
    @Nullable
    private String server;
    @Nullable
    private String target;

    public WhoisCommand(@Nonnull Client client) {
        super(client);
    }

    @Nonnull
    public WhoisCommand server(@Nullable String server) {
        this.server = server == null ? null : Sanity.safeMessageCheck(server, "server");
        return this;
    }

    @Nonnull
    public WhoisCommand target(@Nonnull String target) {
        this.target = Sanity.safeMessageCheck(target, "target");
        return this;
    }

    @Override
    public void execute() {
        if (this.target == null) {
            throw new IllegalStateException("Target not defined");
        }
        StringBuilder builder = new StringBuilder(5 + this.target.length() + (this.server == null ? 1 : 2 + this.server.length()));
        builder.append("WHOIS ");
        if (this.server != null) {
            builder.append(this.server).append(' ');
        }
        builder.append(this.target);
        this.getClient().sendRawLine(builder.toString());
    }

    @Override
    public String toString() {
        return new ToStringer(this).add("client", this.getClient()).add("server", this.server).add("target", this.target).toString();
    }
}

