/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.command;

import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.Command;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public abstract class ChannelCommand
extends Command {
    private final String channel;

    protected ChannelCommand(@Nonnull Client client, @Nonnull String channel) {
        super(client);
        Sanity.safeMessageCheck(channel, "Channel");
        Sanity.truthiness(client.getServerInfo().isValidChannel(channel), "Invalid channel name '" + channel + '\'');
        this.channel = channel;
    }

    @Nonnull
    public String getChannel() {
        return this.channel;
    }

    @Override
    @Nonnull
    protected ToStringer toStringer() {
        return super.toStringer().add("channel", this.getChannel());
    }
}

