/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui.chat;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.creeperhost.minetogether.CreeperHost;
import net.creeperhost.minetogether.chat.ChatHandler;
import net.creeperhost.minetogether.common.LimitedSizeQueue;
import net.creeperhost.minetogether.common.Pair;
import net.creeperhost.minetogether.gui.GuiGDPR;
import net.creeperhost.minetogether.gui.chat.GuiChatFriend;
import net.creeperhost.minetogether.gui.chat.GuiTextFieldLockable;
import net.creeperhost.minetogether.gui.chat.Target;
import net.creeperhost.minetogether.gui.element.DropdownButton;
import net.creeperhost.minetogether.paul.Callbacks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.client.GuiScrollingList;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Mouse;

public class GuiMTChat
extends GuiScreen {
    private final GuiScreen parent;
    private GuiScrollingChat chat;
    private GuiTextFieldLockable send;
    private DropdownButton<Target> targetDropdownButton;
    private GuiButton friendsButton;
    private static String playerName = Minecraft.func_71410_x().func_110432_I().func_111285_a();
    private String currentTarget = ChatHandler.CHANNEL;
    private DropdownButton<Menu> menuDropdownButton;
    private String activeDropdown;
    private GuiButton reconnectionButton;
    private GuiButton cancelButton;
    boolean disabledDueToConnection = false;
    boolean disabledDueToBadwords = false;
    final Pattern pattern = Pattern.compile("((?:user)?(\\d+))", 10);
    private static Field field;

    public GuiMTChat(GuiScreen parent) {
        this.parent = parent;
    }

    public void func_73866_w_() {
        if (!CreeperHost.instance.gdpr.hasAcceptedGDPR()) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiGDPR(this.parent, () -> new GuiMTChat(this.parent)));
            return;
        }
        this.chat = new GuiScrollingChat(10);
        this.send = new GuiTextFieldLockable(8008, this.field_146297_k.field_71466_p, 10, this.field_146295_m - 50, this.field_146294_l - 20, 20);
        this.targetDropdownButton = new DropdownButton<Target>(-1337, this.field_146294_l - 5 - 100, 5, 100, 20, "Chat: %s", Target.getMainTarget(), true);
        this.field_146292_n.add(this.targetDropdownButton);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Mute");
        strings.add("Add friend");
        this.menuDropdownButton = new DropdownButton<Menu>(-1337, -1000, -1000, 100, 20, "Menu", new Menu(strings), true);
        this.field_146292_n.add(this.menuDropdownButton);
        this.friendsButton = new GuiButton(-80088, 5, 5, 100, 20, "Friends list");
        this.field_146292_n.add(this.friendsButton);
        this.cancelButton = new GuiButton(-800885, this.field_146294_l - 100 - 5, this.field_146295_m - 5 - 20, 100, 20, "Cancel");
        this.field_146292_n.add(this.cancelButton);
        this.reconnectionButton = new GuiButton(-80084, 85, this.field_146295_m - 5 - 20, 100, 20, "Reconnect");
        this.field_146292_n.add(this.reconnectionButton);
        this.reconnectionButton.field_146124_l = ChatHandler.tries >= 5;
        this.reconnectionButton.field_146125_m = this.reconnectionButton.field_146124_l;
        this.send.func_146203_f(120);
        this.send.func_146195_b(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_73876_c() {
        super.func_73876_c();
        String buttonTarget = this.targetDropdownButton.getSelected().getInternalTarget();
        if (!buttonTarget.equals(this.currentTarget)) {
            Object object = ChatHandler.ircLock;
            synchronized (object) {
                this.currentTarget = buttonTarget;
                this.chat.updateLines(this.currentTarget);
                ChatHandler.setMessagesRead(this.currentTarget);
            }
            return;
        }
        Object object = ChatHandler.ircLock;
        synchronized (object) {
            this.reconnectionButton.field_146124_l = ChatHandler.tries >= 5;
            this.reconnectionButton.field_146125_m = this.reconnectionButton.field_146124_l;
            if (ChatHandler.hasNewMessages(this.currentTarget)) {
                this.chat.updateLines(this.currentTarget);
                ChatHandler.setMessagesRead(this.currentTarget);
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ChatHandler.ConnectionStatus status = ChatHandler.connectionStatus;
        this.func_146276_q_();
        this.targetDropdownButton.updateDisplayString();
        this.chat.drawScreen(mouseX, mouseY, partialTicks);
        this.send.func_146195_b(true);
        this.send.func_146194_f();
        if (status != ChatHandler.ConnectionStatus.CONNECTED) {
            this.send.setDisabled("Cannot send messages as not connected");
            this.disabledDueToConnection = true;
        } else if (!this.targetDropdownButton.getSelected().isChannel() && !ChatHandler.friends.containsKey(this.currentTarget)) {
            this.send.setDisabled("Cannot send messages as friend is not online");
            this.disabledDueToConnection = true;
        } else if (this.disabledDueToConnection) {
            this.disabledDueToConnection = false;
            this.send.func_146184_c(true);
            Target.updateCache();
            if (!this.targetDropdownButton.getSelected().getPossibleVals().contains(this.targetDropdownButton.getSelected())) {
                this.targetDropdownButton.setSelected(Target.getMainTarget());
            }
            this.processBadwords();
        }
        this.func_73732_a(this.field_146289_q, "MineTogether Chat", this.field_146294_l / 2, 5, 0xFFFFFF);
        ITextComponent comp = new TextComponentString("\u2022").func_150255_a(new Style().func_150238_a(TextFormatting.func_96300_b((String)status.colour)));
        comp.func_150257_a(new TextComponentString(" " + status.display).func_150255_a(new Style().func_150238_a(TextFormatting.WHITE)));
        this.func_73731_b(this.field_146289_q, comp.func_150254_d(), 10, this.field_146295_m - 20, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (!this.send.getOurEnabled() && this.send.isHovered(mouseX, mouseY)) {
            this.func_146283_a(Arrays.asList(this.send.getDisabledMessage()), mouseX, mouseY);
        }
    }

    public void func_146284_a(GuiButton button) throws IOException {
        if (button == this.menuDropdownButton) {
            if (this.menuDropdownButton.getSelected().option.equals("Mute")) {
                CreeperHost.instance.muteUser(this.activeDropdown);
                this.chat.updateLines(this.currentTarget);
            } else if (this.menuDropdownButton.getSelected().option.equals("Add friend")) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiChatFriend(this, playerName, this.activeDropdown, Callbacks.getFriendCode(), "", false));
            }
        } else if (button == this.friendsButton) {
            CreeperHost.proxy.openFriendsGui();
        } else if (button == this.reconnectionButton) {
            ChatHandler.reInit();
        } else if (button == this.cancelButton) {
            this.field_146297_k.func_147108_a(this.parent);
        }
        this.chat.actionPerformed(button);
        super.func_146284_a(button);
    }

    public void processBadwords() {
        String text = this.send.func_146179_b().replaceAll(ChatHandler.badwordsFormat, "");
        boolean veryNaughty = false;
        for (String bad : ChatHandler.badwords) {
            if (bad.startsWith("(") && bad.endsWith(")") && text.matches(bad)) {
                veryNaughty = true;
                break;
            }
            if (!text.toLowerCase().contains(bad.toLowerCase())) continue;
            veryNaughty = true;
            break;
        }
        if (veryNaughty) {
            this.send.setDisabled("Cannot send message as contains content which may not be suitable for all audiences");
            this.disabledDueToBadwords = true;
            return;
        }
        if (this.disabledDueToBadwords) {
            this.disabledDueToBadwords = false;
            this.send.func_146184_c(true);
        }
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        super.func_146274_d();
        this.chat.handleElementClicks();
        this.chat.handleMouseInput(mouseX, mouseY);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.menuDropdownButton.wasJustClosed && !this.menuDropdownButton.dropdownOpen) {
            this.menuDropdownButton.field_146129_i = -10000;
            this.menuDropdownButton.field_146128_h = -10000;
            this.menuDropdownButton.wasJustClosed = false;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if ((keyCode == 28 || keyCode == 156) && this.send.getOurEnabled() && !this.send.func_146179_b().trim().isEmpty()) {
            String text = this.send.func_146179_b();
            CharSequence[] split = text.split(" ");
            for (int i = 0; i < split.length; ++i) {
                String word = split[i].toLowerCase();
                String subst = "User$2";
                Matcher matcher = this.pattern.matcher(word);
                String result = matcher.replaceAll("User$2");
                String justNick = result.replaceAll("[^A-Za-z0-9]", "");
                String tempWord = ChatHandler.anonUsersReverse.get(justNick);
                if (tempWord == null) continue;
                split[i] = result.replaceAll(justNick, tempWord);
            }
            text = String.join((CharSequence)" ", split);
            ChatHandler.sendMessage(this.currentTarget, text);
            this.send.func_146180_a("");
            return;
        }
        boolean ourEnabled = this.send.getOurEnabled();
        if (!ourEnabled) {
            this.send.func_146184_c(true);
        }
        this.send.func_146201_a(typedChar, keyCode);
        if (!ourEnabled) {
            this.send.func_146184_c(false);
        }
        this.processBadwords();
    }

    public boolean func_175276_a(ITextComponent component) {
        ClickEvent event = component.func_150256_b().func_150235_h();
        if (event == null) {
            return false;
        }
        if (event.func_150669_a() == ClickEvent.Action.SUGGEST_COMMAND) {
            int mouseX;
            String eventValue = event.func_150668_b();
            if (eventValue.contains(":")) {
                String[] split = eventValue.split(":");
                if (split.length < 3) {
                    return false;
                }
                String chatInternalName = split[1];
                String friendCode = split[2];
                StringBuilder builder = new StringBuilder();
                for (int i = 3; i < split.length; ++i) {
                    builder.append(split[i]).append(" ");
                }
                String friendName = builder.toString().trim();
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiChatFriend(this, playerName, chatInternalName, friendCode, friendName, true));
                return true;
            }
            this.menuDropdownButton.field_146128_h = mouseX = Mouse.getX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            this.menuDropdownButton.field_146129_i = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.menuDropdownButton.dropdownOpen = true;
            this.activeDropdown = event.func_150668_b();
            return true;
        }
        return super.func_175276_a(component);
    }

    public static ITextComponent formatLine(Pair<String, String> message) {
        String inputNick;
        String outputNick = inputNick = message.getLeft();
        if (inputNick.contains(":")) {
            String[] split = inputNick.split(":");
            switch (split[0]) {
                case "FR": {
                    if (split.length < 2) {
                        return null;
                    }
                    String nick = split[1];
                    String nickDisplay = ChatHandler.getNameForUser(nick);
                    if (!nickDisplay.startsWith("User")) {
                        return null;
                    }
                    String cmdStr = message.getRight();
                    String[] cmdSplit = cmdStr.split(" ");
                    if (cmdSplit.length < 2) {
                        return null;
                    }
                    String friendCode = cmdSplit[0];
                    StringBuilder nameBuilder = new StringBuilder();
                    for (int i = 1; i < cmdSplit.length; ++i) {
                        nameBuilder.append(cmdSplit[i]);
                    }
                    String friendName = nameBuilder.toString();
                    TextComponentString userComp = new TextComponentString(friendName + " (" + nickDisplay + ") would like to add you as a friend. Click to ");
                    ITextComponent accept = new TextComponentString("<Accept>").func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "AC:" + nick + ":" + friendCode + ":" + friendName)).func_150238_a(TextFormatting.GREEN));
                    userComp.func_150257_a(accept);
                    return userComp;
                }
                case "FA": {
                    if (split.length < 2) {
                        return null;
                    }
                    String nick = split[1];
                    String nickDisplay = ChatHandler.getNameForUser(nick);
                    String friendName = message.getRight();
                    TextComponentString userComp = new TextComponentString(friendName + " (" + nickDisplay + ") accepted your friend request.");
                    return userComp;
                }
            }
        }
        boolean friend = false;
        if (inputNick.startsWith("MT")) {
            if (inputNick.equals(CreeperHost.instance.ourNick)) {
                outputNick = playerName;
            } else {
                if (CreeperHost.instance.mutedUsers.contains(inputNick)) {
                    return null;
                }
                String newNick = ChatHandler.getNameForUser(inputNick);
                if (!inputNick.equals(newNick) && !newNick.startsWith("User")) {
                    friend = true;
                }
                outputNick = newNick;
            }
        } else if (!inputNick.equals("System")) {
            return null;
        }
        TextComponentString base = new TextComponentString("");
        TextComponentString userComp = new TextComponentString("<" + outputNick + ">");
        if (!inputNick.equals(CreeperHost.instance.ourNick) && inputNick.startsWith("MT")) {
            userComp.func_150255_a(new Style().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, inputNick)));
        }
        String messageStr = message.getRight();
        for (String swear : ChatHandler.badwords) {
            messageStr = messageStr.replace(swear, StringUtils.repeat((String)"*", (int)swear.length()));
        }
        CharSequence[] split = messageStr.split(" ");
        boolean highlight = false;
        for (int i = 0; i < split.length; ++i) {
            String splitStr = split[i];
            String justNick = splitStr.replaceAll("[^A-Za-z0-9]", "");
            if (!justNick.startsWith("MT")) continue;
            if (justNick.equals(ChatHandler.initedString)) {
                splitStr = splitStr.replaceAll(justNick, playerName);
                split[i] = splitStr;
                highlight = true;
                continue;
            }
            String userName = ChatHandler.getNameForUser(justNick);
            if (userName == null) continue;
            splitStr = splitStr.replaceAll(justNick, userName);
            split[i] = splitStr;
        }
        messageStr = String.join((CharSequence)" ", split);
        ITextComponent messageComp = new TextComponentString(messageStr).func_150255_a(new Style().func_150238_a(TextFormatting.WHITE));
        if (friend) {
            userComp.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        } else if (outputNick.equals("System")) {
            userComp.func_150256_b().func_150238_a(TextFormatting.AQUA);
        }
        if (highlight) {
            userComp.func_150256_b().func_150238_a(TextFormatting.RED);
            messageComp.func_150256_b().func_150238_a(TextFormatting.RED);
            base.func_150256_b().func_150238_a(TextFormatting.RED);
        }
        base.func_150257_a((ITextComponent)userComp);
        base.func_150257_a(new TextComponentString(" ").func_150255_a(new Style().func_150238_a(TextFormatting.WHITE)));
        return base.func_150257_a(messageComp);
    }

    static {
        try {
            field = GuiScrollingList.class.getDeclaredField("scrollDistance");
            field.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public static class Menu
    implements DropdownButton.IDropdownOption {
        List<DropdownButton.IDropdownOption> possibleValsCache;
        public String option;

        public Menu(List<String> options) {
            this.possibleValsCache = new ArrayList<DropdownButton.IDropdownOption>();
            this.possibleValsCache.add(this);
            this.option = options.get(0);
            options.remove(0);
            for (String option : options) {
                this.possibleValsCache.add(new Menu(this.possibleValsCache, option));
            }
        }

        public Menu(List<DropdownButton.IDropdownOption> vals, String option) {
            this.possibleValsCache = vals;
            this.option = option;
        }

        @Override
        public String getTranslate(DropdownButton.IDropdownOption current, boolean dropdownOpen) {
            return this.option;
        }

        @Override
        public List<DropdownButton.IDropdownOption> getPossibleVals() {
            return this.possibleValsCache;
        }
    }

    private class GuiScrollingChat
    extends GuiScrollingList {
        private ArrayList<ITextComponent> lines;
        int elementClicked;

        GuiScrollingChat(int entryHeight) {
            super(Minecraft.func_71410_x(), GuiMTChat.this.field_146294_l - 20, GuiMTChat.this.field_146295_m - 30, 30, GuiMTChat.this.field_146295_m - 50, 10, entryHeight, GuiMTChat.this.field_146294_l, GuiMTChat.this.field_146295_m);
            this.elementClicked = -1;
            this.lines = new ArrayList();
            this.updateLines(ChatHandler.CHANNEL);
        }

        protected int getContentHeight() {
            int viewHeight = this.bottom - this.top - 4;
            return super.getContentHeight() < viewHeight ? viewHeight : super.getContentHeight();
        }

        protected void updateLines(String key) {
            if (ChatHandler.messages == null || ChatHandler.messages.size() == 0) {
                return;
            }
            ArrayList<ITextComponent> oldLines = this.lines;
            int listHeight = this.getContentHeight() - (this.bottom - this.top - 4);
            this.lines = new ArrayList();
            LimitedSizeQueue<Pair<String, String>> tempMessages = ChatHandler.messages.get(key);
            if (tempMessages == null) {
                return;
            }
            for (Pair pair : tempMessages) {
                ITextComponent display = GuiMTChat.formatLine(pair);
                if (display == null) continue;
                List strings = GuiUtilRenderComponents.func_178908_a((ITextComponent)display, (int)(this.listWidth - 6), (FontRenderer)GuiMTChat.this.field_146289_q, (boolean)false, (boolean)true);
                for (ITextComponent string : strings) {
                    this.lines.add(string);
                }
            }
            try {
                if (this.lines.size() > oldLines.size() && ((Float)field.get((Object)this)).floatValue() == (float)listHeight || listHeight < 0) {
                    listHeight = this.getContentHeight() - (this.bottom - this.top - 4);
                    field.set((Object)this, listHeight);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        protected int getSize() {
            return this.lines.size();
        }

        protected void handleElementClicks() {
            if (this.elementClicked == -1) {
                return;
            }
            ITextComponent component = this.lines.get(this.elementClicked);
            this.elementClicked = -1;
            int mouseX = Mouse.getX() * GuiMTChat.this.field_146294_l / GuiMTChat.this.field_146297_k.field_71443_c;
            mouseX -= this.left;
            int totalWidth = 0;
            for (ITextComponent sibling : component.func_150253_a()) {
                int oldTotal = totalWidth;
                if (sibling.func_150256_b().func_150235_h() == null || mouseX <= oldTotal || mouseX >= (totalWidth += GuiMTChat.this.field_146289_q.func_78256_a(sibling.func_150254_d()))) continue;
                GuiMTChat.this.func_175276_a(sibling);
                return;
            }
        }

        protected void elementClicked(int index, boolean doubleClick) {
            this.elementClicked = index;
        }

        protected boolean isSelected(int index) {
            return false;
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
            ITextComponent component = this.lines.get(slotIdx);
            int mouseX = Mouse.getX() * GuiMTChat.this.field_146294_l / GuiMTChat.this.field_146297_k.field_71443_c;
            mouseX -= this.left;
            int totalWidth = 5;
            for (ITextComponent sibling : component.func_150253_a()) {
                boolean hovering;
                int oldTotal = totalWidth;
                boolean bl = hovering = mouseX > oldTotal && mouseX < (totalWidth += GuiMTChat.this.field_146289_q.func_78256_a(sibling.func_150254_d())) && this.mouseY > slotTop && this.mouseY < slotTop + this.slotHeight;
                if (sibling.func_150256_b().func_150235_h() != null) {
                    if (hovering) {
                        GuiMTChat.this.field_146297_k.field_71466_p.func_78276_b(TextFormatting.func_110646_a((String)sibling.func_150261_e()), this.left + oldTotal, slotTop, -16777216);
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
                        GuiMTChat.this.field_146297_k.field_71466_p.func_78276_b(sibling.func_150254_d(), this.left + oldTotal, slotTop, -1140850689);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        continue;
                    }
                    GuiMTChat.this.field_146297_k.field_71466_p.func_78276_b(sibling.func_150254_d(), this.left + oldTotal, slotTop, -1);
                    continue;
                }
                GuiMTChat.this.field_146297_k.field_71466_p.func_78276_b(sibling.func_150254_d(), this.left + oldTotal, slotTop, 0xFFFFFF);
            }
        }
    }
}

