/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.GuiConnecting;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class GuiProgressDisconnected
extends GuiScreen {
    private final GuiScreen parentScreen;
    double percent = 0.0;
    Pattern pattern = Pattern.compile("(\\d+/\\d+).*");
    Field cancelField = null;
    private String ourReason;
    private ITextComponent ourMessage;
    private List<String> multilineMessage;
    private int textHeight;
    private long lastConnectAttempt;
    private NetworkManager lastNetworkManager;
    private GuiConnecting captiveConnecting;
    private String ip = "";

    public GuiProgressDisconnected(GuiScreen screen, String reasonLocalizationKey, ITextComponent chatComp, NetworkManager lastNetworkManager) {
        this.parentScreen = screen;
        this.ourReason = I18n.func_135052_a((String)reasonLocalizationKey, (Object[])new Object[0]);
        this.ourMessage = chatComp;
        this.lastNetworkManager = lastNetworkManager;
        this.lastConnectAttempt = System.currentTimeMillis();
        if (lastNetworkManager != null) {
            InetSocketAddress address = (InetSocketAddress)lastNetworkManager.func_74430_c();
            this.ip = address.getHostName() + ":" + address.getPort();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.ourReason, this.field_146294_l / 2, this.field_146295_m / 2 - this.textHeight / 2 - this.field_146289_q.field_78288_b * 2, 0xAAAAAA);
        int x = this.field_146295_m / 2 - this.textHeight / 2;
        if (this.multilineMessage != null) {
            for (String s : this.multilineMessage) {
                this.func_73732_a(this.field_146289_q, s, this.field_146294_l / 2, x, 0xFFFFFF);
                x += this.field_146289_q.field_78288_b;
            }
        }
        int loadingBackColour = -16777216;
        int loadingFrontColour = -16711936;
        int loadingOutsideColour = -14540254;
        int loadingHeight = 20;
        int loadingWidth = this.field_146294_l - 60;
        int left = this.field_146294_l / 2 - loadingWidth / 2;
        int top = this.field_146295_m / 2 - loadingHeight / 2 + 45;
        int loadingPercentWidth = (int)((double)loadingWidth / 100.0 * this.percent);
        GuiProgressDisconnected.func_73734_a((int)(left - 1), (int)(top - 1), (int)(left + loadingWidth + 1), (int)(top + loadingHeight + 1), (int)loadingOutsideColour);
        GuiProgressDisconnected.func_73734_a((int)left, (int)top, (int)(left + loadingWidth), (int)(top + loadingHeight), (int)loadingBackColour);
        GuiProgressDisconnected.func_73734_a((int)left, (int)top, (int)(left + loadingPercentWidth), (int)(top + loadingHeight), (int)loadingFrontColour);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_73876_c() {
        if (this.captiveConnecting != null) {
            this.captiveConnecting.func_73876_c();
        }
    }

    public void func_73866_w_() {
        this.update(this.ourReason, this.ourMessage);
        this.field_146292_n.clear();
        this.textHeight = this.multilineMessage.size() * this.field_146289_q.field_78288_b;
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 100, Math.min(this.field_146295_m / 2 + 80, this.field_146295_m - 30), I18n.func_135052_a((String)"gui.toMenu", (Object[])new Object[0])));
    }

    public void update(String reason, ITextComponent message) {
        this.lastConnectAttempt = System.currentTimeMillis();
        this.ourMessage = message;
        this.ourReason = reason;
        this.captiveConnecting = null;
        this.multilineMessage = this.field_146289_q.func_78271_c(this.ourMessage.func_150254_d(), this.field_146294_l - 50);
        for (String aMultilineMessage : this.multilineMessage) {
            Matcher matcher = this.pattern.matcher(aMultilineMessage);
            if (!matcher.matches()) continue;
            String match = matcher.group(1);
            String[] split = match.split("/");
            int done = Integer.parseInt(split[0]);
            int total = Integer.parseInt(split[1]);
            this.percent = (double)done / (double)total * 100.0;
            break;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0) {
            if (this.captiveConnecting != null) {
                if (this.lastNetworkManager != null) {
                    this.lastNetworkManager.func_150718_a((ITextComponent)new TextComponentString("Aborted"));
                }
                try {
                    if (this.cancelField == null) {
                        this.cancelField = ReflectionHelper.findField(GuiConnecting.class, (String[])new String[]{"field_146373_h", "cancel"});
                    }
                    this.cancelField.set(this.captiveConnecting, true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.field_146297_k.func_147108_a(this.parentScreen);
        }
        super.func_146284_a(button);
    }
}

