/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.creeperhost.minetogether.EventHandler;
import net.creeperhost.minetogether.PacketHandler;
import net.creeperhost.minetogether.api.CreeperHostAPI;
import net.creeperhost.minetogether.api.ICreeperHostMod;
import net.creeperhost.minetogether.api.IServerHost;
import net.creeperhost.minetogether.chat.ChatHandler;
import net.creeperhost.minetogether.common.Config;
import net.creeperhost.minetogether.common.GDPR;
import net.creeperhost.minetogether.common.HostHolder;
import net.creeperhost.minetogether.common.IHost;
import net.creeperhost.minetogether.common.IngameChat;
import net.creeperhost.minetogether.common.Pair;
import net.creeperhost.minetogether.gui.chat.GuiMTChat;
import net.creeperhost.minetogether.gui.chat.ingame.GuiNewChatOurs;
import net.creeperhost.minetogether.gui.serverlist.data.Invite;
import net.creeperhost.minetogether.paul.Callbacks;
import net.creeperhost.minetogether.paul.CreeperHostServerHost;
import net.creeperhost.minetogether.proxy.IProxy;
import net.creeperhost.minetogether.serverlist.data.Friend;
import net.creeperhost.minetogether.serverstuffs.command.CommandKill;
import net.creeperhost.minetogether.siv.QueryGetter;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="minetogether", name="MineTogether", version="unspecified", acceptableRemoteVersions="*", acceptedMinecraftVersions="1.9.4,1.10.2,1.11.2", guiFactory="net.creeperhost.minetogether.gui.config.GuiCreeperConfigFactory")
public class CreeperHost
implements ICreeperHostMod,
IHost {
    public static final String MOD_ID = "minetogether";
    public static final String NAME = "MineTogether";
    public static final String VERSION = "unspecified";
    public static final Logger logger = LogManager.getLogger((String)"minetogether");
    public ArrayList<String> mutedUsers = new ArrayList();
    @Mod.Instance(value="minetogether", owner="minetogether")
    public static CreeperHost instance;
    @SidedProxy(clientSide="net.creeperhost.minetogether.proxy.Client", serverSide="net.creeperhost.minetogether.proxy.Server")
    public static IProxy proxy;
    public final Object inviteLock = new Object();
    public ArrayList<IServerHost> implementations = new ArrayList();
    public IServerHost currentImplementation;
    public File configFile;
    public int curServerId = -1;
    public Invite handledInvite;
    public boolean active = true;
    public Invite invite;
    public GDPR gdpr;
    public IngameChat ingameChat;
    public String activeMinigame;
    public int minigameID;
    public boolean trialMinigame;
    public long joinTime;
    String toastText;
    long endTime;
    long fadeTime;
    private QueryGetter queryGetter;
    private String lastCurse = "";
    private Random randomGenerator;
    private CreeperHostServerHost implement;
    public String ourNick;
    public File mutedUsersFile;
    final Object friendLock = new Object();
    String friend = null;
    boolean friendMessage = false;
    private static boolean anonLoaded;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.configFile = event.getSuggestedConfigurationFile();
        InputStream configStream = null;
        try {
            String configString;
            if (this.configFile.exists()) {
                configStream = new FileInputStream(this.configFile);
                configString = IOUtils.toString((InputStream)configStream);
            } else {
                File parent = this.configFile.getParentFile();
                File tempConfigFile = new File(parent, "creeperhost.cfg");
                if (tempConfigFile.exists()) {
                    configStream = new FileInputStream(tempConfigFile);
                    configString = IOUtils.toString((InputStream)configStream);
                } else {
                    configString = "{}";
                }
            }
            Config.loadConfig(configString);
        }
        catch (Throwable t) {
            logger.error("Fatal error, unable to read config. Not starting mod.", t);
            this.active = false;
        }
        finally {
            try {
                if (configStream != null) {
                    configStream.close();
                }
            }
            catch (Throwable configString) {}
            if (!this.active) {
                return;
            }
        }
        this.saveConfig();
        PacketHandler.packetRegister();
        if (event.getSide() != Side.SERVER) {
            HostHolder.host = this;
            File gdprFile = new File("local/minetogether/gdpr.txt");
            this.gdpr = new GDPR(gdprFile);
            File ingameChatFile = new File("local/minetogether/ingameChatFile.txt");
            this.ingameChat = new IngameChat(ingameChatFile);
            this.ourNick = "MT" + Callbacks.getPlayerHash(proxy.getUUID()).substring(0, 15);
            MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
            proxy.registerKeys();
        }
    }

    public void saveConfig() {
        FileOutputStream configOut = null;
        try {
            configOut = new FileOutputStream(this.configFile);
            IOUtils.write((String)Config.saveConfig(), (OutputStream)configOut);
            configOut.close();
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                if (configOut != null) {
                    configOut.close();
                }
            }
            catch (Throwable throwable) {}
        }
        if (Config.getInstance().isCreeperhostEnabled()) {
            CreeperHost.instance.implementations.remove(this.implement);
            this.implement = new CreeperHostServerHost();
            CreeperHostAPI.registerImplementation(this.implement);
        }
        if (!Config.getInstance().isCreeperhostEnabled()) {
            CreeperHost.instance.implementations.remove(this.implement);
            this.implement = null;
        }
    }

    public void updateCurse() {
        if (!Config.getInstance().curseProjectID.equals(this.lastCurse) && Config.getInstance().isCreeperhostEnabled()) {
            Config.getInstance().setVersion(Callbacks.getVersionFromCurse(Config.getInstance().curseProjectID));
        }
        this.lastCurse = Config.getInstance().curseProjectID;
    }

    public void setRandomImplementation() {
        if (this.randomGenerator == null) {
            this.randomGenerator = new Random();
        }
        if (this.implementations.size() == 0) {
            this.currentImplementation = null;
            return;
        }
        int random = this.randomGenerator.nextInt(this.implementations.size());
        this.currentImplementation = this.implementations.get(random);
    }

    public IServerHost getImplementation() {
        return this.currentImplementation;
    }

    @Override
    public void registerImplementation(IServerHost serverHost) {
        this.implementations.add(serverHost);
    }

    public void makeQueryGetter() {
        try {
            if (FMLClientHandler.instance().getClientToServerNetworkManager() != null) {
                SocketAddress socketAddress = FMLClientHandler.instance().getClientToServerNetworkManager().func_74430_c();
                String host = "127.0.0.1";
                int port = 25565;
                if (socketAddress instanceof InetSocketAddress) {
                    InetSocketAddress add = (InetSocketAddress)socketAddress;
                    host = add.getHostName();
                    port = add.getPort();
                }
                this.queryGetter = new QueryGetter(host, port);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public QueryGetter getQueryGetter() {
        if (this.queryGetter == null) {
            this.makeQueryGetter();
        }
        return this.queryGetter;
    }

    public void displayToast(String text, int duration) {
        this.toastText = text;
        this.endTime = System.currentTimeMillis() + (long)duration;
        this.fadeTime = this.endTime + 500L;
    }

    public void clearToast(boolean fade) {
        this.endTime = System.currentTimeMillis();
        this.fadeTime = this.endTime + (long)(fade ? 500 : 0);
    }

    public ArrayList<Friend> getFriends() {
        return Callbacks.getFriendsList(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void friendEvent(String name, boolean isMessage) {
        Object object = this.friendLock;
        synchronized (object) {
            this.friend = ChatHandler.getNameForUser(name);
            this.friendMessage = isMessage;
        }
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public void messageReceived(String target, Pair messagePair) {
        if (!Config.getInstance().isChatEnabled() || !target.equals(ChatHandler.CHANNEL)) {
            return;
        }
        GuiNewChatOurs ourChat = (GuiNewChatOurs)Minecraft.func_71410_x().field_71456_v.func_146158_b();
        ourChat.func_146237_a(GuiMTChat.formatLine(messagePair), 0, Minecraft.func_71410_x().field_71456_v.func_73834_c(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNameForUser(String nick) {
        if (!anonLoaded) {
            File anonUsersFile = new File("local/minetogether/anonusers.json");
            InputStream anonUsersStream = null;
            try {
                String configString;
                if (anonUsersFile.exists()) {
                    anonUsersStream = new FileInputStream(anonUsersFile);
                    configString = IOUtils.toString((InputStream)anonUsersStream);
                } else {
                    anonUsersFile.getParentFile().mkdirs();
                    configString = "{}";
                }
                Gson gson = new Gson();
                ChatHandler.anonUsers = (HashMap)gson.fromJson(configString, new TypeToken<HashMap<String, String>>(){}.getType());
                ChatHandler.anonUsersReverse = new HashMap();
                for (Map.Entry<String, String> entry : ChatHandler.anonUsers.entrySet()) {
                    ChatHandler.anonUsersReverse.put(entry.getValue(), entry.getKey());
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    if (anonUsersStream != null) {
                        anonUsersStream.close();
                    }
                }
                catch (Throwable throwable) {}
            }
            anonLoaded = true;
        }
        if (nick.length() < 16) {
            return null;
        }
        if (ChatHandler.friends.containsKey(nick = nick.substring(0, 17))) {
            return ChatHandler.friends.get(nick);
        }
        if (nick.startsWith("MT")) {
            if (ChatHandler.anonUsers.containsKey(nick)) {
                return ChatHandler.anonUsers.get(nick);
            }
            String anonymousNick = "User" + ChatHandler.random.nextInt(10000);
            while (ChatHandler.anonUsers.containsValue(anonymousNick)) {
                anonymousNick = "User" + ChatHandler.random.nextInt(10000);
            }
            ChatHandler.anonUsers.put(nick, anonymousNick);
            ChatHandler.anonUsersReverse.put(anonymousNick, nick);
            this.saveAnonFile();
            return anonymousNick;
        }
        return null;
    }

    public void saveAnonFile() {
        Gson gson = new Gson();
        File anonUsersFile = new File("local/minetogether/anonusers.json");
        try {
            FileUtils.writeStringToFile((File)anonUsersFile, (String)gson.toJson(ChatHandler.anonUsers));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void muteUser(String user) {
        this.mutedUsers.add(user);
        Gson gson = new Gson();
        try {
            FileUtils.writeStringToFile((File)this.mutedUsersFile, (String)gson.toJson(this.mutedUsers));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String getFriendCode() {
        return Callbacks.getFriendCode();
    }

    @Override
    public void acceptFriend(String friendCode, String name) {
        new Thread(() -> Callbacks.addFriend(friendCode, name)).start();
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandKill());
    }

    static {
        anonLoaded = false;
    }
}

