/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier1;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import techreborn.init.ModBlocks;
import techreborn.items.ingredients.ItemParts;

@RebornRegistry(modID="techreborn")
public class TileRecycler
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    @ConfigRegistry(config="machines", category="recycler", key="RecyclerInput", comment="Recycler Max Input (Value in EU)")
    public static int maxInput = 32;
    @ConfigRegistry(config="machines", category="recycler", key="RecyclerMaxEnergy", comment="Recycler Max Energy (Value in EU)")
    public static int maxEnergy = 1000;
    private final Inventory inventory = new Inventory(3, "TileRecycler", 64, (TileEntity)this);
    private final int cost = 2;
    private final int time = 15;
    private final int chance = 6;
    private boolean isBurning;
    private int progress;

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / 15;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void recycleItems() {
        ItemStack itemstack = ItemParts.getPartByName("scrap");
        int randomchance = this.field_145850_b.field_73012_v.nextInt(6);
        if (randomchance == 1) {
            if (this.func_70301_a(1).func_190926_b()) {
                this.func_70299_a(1, itemstack.func_77946_l());
            } else {
                this.func_70301_a(1).func_190917_f(itemstack.func_190916_E());
            }
        }
        this.func_70298_a(0, 1);
    }

    public boolean canRecycle() {
        return !this.func_70301_a(0).func_190926_b() && this.hasSlotGotSpace(1);
    }

    public boolean hasSlotGotSpace(int slot) {
        if (this.func_70301_a(slot).func_190926_b()) {
            return true;
        }
        return this.func_70301_a(slot).func_190916_E() < this.func_70301_a(slot).func_77976_d();
    }

    public boolean isBurning() {
        return this.isBurning;
    }

    public void setBurning(boolean burning) {
        this.isBurning = burning;
    }

    public void updateState() {
        IBlockState BlockStateContainer2 = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (BlockStateContainer2.func_177230_c() instanceof BlockMachineBase) {
            boolean shouldBurn;
            BlockMachineBase blockMachineBase = (BlockMachineBase)BlockStateContainer2.func_177230_c();
            boolean bl = shouldBurn = this.isBurning || this.canRecycle() && this.canUseEnergy(this.getEuPerTick(2.0));
            if ((Boolean)BlockStateContainer2.func_177229_b((IProperty)BlockMachineBase.ACTIVE) != shouldBurn) {
                blockMachineBase.setActive(Boolean.valueOf(this.isBurning), this.field_145850_b, this.field_174879_c);
            }
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.charge(2);
        boolean updateInventory = false;
        if (this.canRecycle() && !this.isBurning() && this.getEnergy() != 0.0) {
            this.setBurning(true);
        } else if (this.isBurning()) {
            if (this.useEnergy(this.getEuPerTick(2.0)) != this.getEuPerTick(2.0)) {
                this.setBurning(false);
            }
            ++this.progress;
            if (this.progress >= Math.max((int)(15.0 * (1.0 - this.getSpeedMultiplier())), 1)) {
                this.progress = 0;
                this.recycleItems();
                updateInventory = true;
                this.setBurning(false);
            }
        }
        this.updateState();
        if (updateInventory) {
            this.func_70296_d();
        }
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return maxInput;
    }

    public boolean canBeUpgraded() {
        return true;
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.RECYCLER, 1);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("recycler").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 55, 45).outputSlot(1, 101, 45).energySlot(2, 8, 72).syncEnergyValue().syncIntegerValue(this::getProgress, this::setProgress).addInventory().create((TileLegacyMachineBase)this);
    }
}

