/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier1;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import techreborn.init.ModBlocks;

@RebornRegistry(modID="techreborn")
public class TileElectricFurnace
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    @ConfigRegistry(config="machines", category="electric_furnace", key="ElectricFurnaceInput", comment="Electric Furnace Max Input (Value in EU)")
    public static int maxInput = 32;
    @ConfigRegistry(config="machines", category="electric_furnace", key="ElectricFurnaceMaxEnergy", comment="Electric Furnace Max Energy (Value in EU)")
    public static int maxEnergy = 1000;
    public Inventory inventory = new Inventory(3, "TileElectricFurnace", 64, (TileEntity)this);
    public int progress;
    public int fuelScale = 100;
    public int cost = 6;
    int input1 = 0;
    int output = 1;
    boolean wasBurning = false;

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / (int)((double)this.fuelScale * (1.0 - this.getSpeedMultiplier()));
    }

    public void cookItems() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(this.input1));
            if (this.func_70301_a(this.output).func_190926_b()) {
                this.func_70299_a(this.output, itemstack.func_77946_l());
            } else if (this.func_70301_a(this.output).func_77969_a(itemstack)) {
                this.func_70301_a(this.output).func_190917_f(itemstack.func_190916_E());
            }
            if (this.func_70301_a(this.input1).func_190916_E() > 1) {
                this.func_70298_a(this.input1, 1);
            } else {
                this.func_70299_a(this.input1, ItemStack.field_190927_a);
            }
        }
    }

    public boolean canSmelt() {
        if (this.func_70301_a(this.input1).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(this.input1));
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (this.func_70301_a(this.output).func_190926_b()) {
            return true;
        }
        if (!this.func_70301_a(this.output).func_77969_a(itemstack)) {
            return false;
        }
        int result = this.func_70301_a(this.output).func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public boolean isBurning() {
        return this.getEnergy() > this.getEuPerTick(this.cost);
    }

    public ItemStack getResultFor(ItemStack stack) {
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
        if (!result.func_190926_b()) {
            return result.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public void updateState() {
        if (this.wasBurning != this.progress > 0) {
            if (this.wasBurning && this.progress == 0 && this.canSmelt()) {
                this.wasBurning = true;
                return;
            }
            IBlockState BlockStateContainer2 = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (BlockStateContainer2.func_177230_c() instanceof BlockMachineBase) {
                BlockMachineBase blockMachineBase = (BlockMachineBase)BlockStateContainer2.func_177230_c();
                if ((Boolean)BlockStateContainer2.func_177229_b((IProperty)BlockMachineBase.ACTIVE) != this.progress > 0) {
                    blockMachineBase.setActive(Boolean.valueOf(this.progress > 0), this.field_145850_b, this.field_174879_c);
                }
            }
            this.wasBurning = this.progress > 0;
        }
    }

    public int getBurnTime() {
        return this.progress;
    }

    public void setBurnTime(int burnTime) {
        this.progress = burnTime;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        super.func_73660_a();
        this.charge(2);
        boolean burning = this.isBurning();
        boolean updateInventory = false;
        if (this.isBurning() && this.canSmelt()) {
            this.updateState();
            if (this.canUseEnergy(this.getEuPerTick(this.cost))) {
                this.useEnergy(this.getEuPerTick(this.cost));
                ++this.progress;
                if (this.progress >= Math.max((int)((double)this.fuelScale * (1.0 - this.getSpeedMultiplier())), 5)) {
                    this.progress = 0;
                    this.cookItems();
                    updateInventory = true;
                }
            }
        } else {
            this.progress = 0;
            this.updateState();
        }
        if (burning != this.isBurning()) {
            updateInventory = true;
        }
        if (updateInventory) {
            this.func_70296_d();
        }
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return maxInput;
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.ELECTRIC_FURNACE, 1);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("electricfurnace").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 55, 45).outputSlot(1, 101, 45).energySlot(2, 8, 72).syncEnergyValue().syncIntegerValue(this::getBurnTime, this::setBurnTime).addInventory().create((TileLegacyMachineBase)this);
    }
}

