/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.tier0;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBoat;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.event.ForgeEventFactory;
import reborncore.api.IToolDrop;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.recipes.RecipeTranslator;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.Reference;
import techreborn.api.recipe.machines.AlloySmelterRecipe;
import techreborn.init.ModBlocks;

@RebornRegistry(modID="techreborn")
public class TileIronAlloyFurnace
extends TileLegacyMachineBase
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    public int tickTime;
    public Inventory inventory = new Inventory(4, "TileIronAlloyFurnace", 64, (TileEntity)this);
    public int burnTime;
    public int currentItemBurnTime;
    public int cookTime;
    int input1 = 0;
    int input2 = 1;
    int output = 2;
    int fuel = 3;

    public static int getItemBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        int burnTime = ForgeEventFactory.getItemBurnTime((ItemStack)stack);
        if (burnTime >= 0) {
            return burnTime;
        }
        Item item = stack.func_77973_b();
        if (item == Item.func_150898_a((Block)Blocks.field_150376_bx)) {
            return 150;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150325_L)) {
            return 100;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150404_cg)) {
            return 67;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150468_ap)) {
            return 300;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150471_bO)) {
            return 100;
        }
        if (Block.func_149634_a((Item)item).func_176223_P().func_185904_a() == Material.field_151575_d) {
            return 300;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150402_ci)) {
            return 16000;
        }
        if (item instanceof ItemTool && "WOOD".equals(((ItemTool)item).func_77861_e())) {
            return 200;
        }
        if (item instanceof ItemSword && "WOOD".equals(((ItemSword)item).func_150932_j())) {
            return 200;
        }
        if (item instanceof ItemHoe && "WOOD".equals(((ItemHoe)item).func_77842_f())) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item != Items.field_151031_f && item != Items.field_151112_aM) {
            if (item == Items.field_151155_ap) {
                return 200;
            }
            if (item == Items.field_151044_h) {
                return 1600;
            }
            if (item == Items.field_151129_at) {
                return 20000;
            }
            if (item != Item.func_150898_a((Block)Blocks.field_150345_g) && item != Items.field_151054_z) {
                if (item == Items.field_151072_bj) {
                    return 2400;
                }
                if (item instanceof ItemDoor && item != Items.field_151139_aw) {
                    return 200;
                }
                return item instanceof ItemBoat ? 400 : 0;
            }
            return 100;
        }
        return 300;
    }

    public void func_73660_a() {
        super.func_73660_a();
        boolean flag = this.burnTime > 0;
        boolean flag1 = false;
        if (this.burnTime > 0) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.burnTime != 0 || !this.func_70301_a(this.input1).func_190926_b() && !this.func_70301_a(this.fuel).func_190926_b()) {
                if (this.burnTime == 0 && this.canSmelt()) {
                    this.currentItemBurnTime = this.burnTime = TileIronAlloyFurnace.getItemBurnTime(this.func_70301_a(this.fuel));
                    if (this.burnTime > 0) {
                        flag1 = true;
                        if (!this.func_70301_a(this.fuel).func_190926_b()) {
                            this.func_70298_a(this.fuel, 1);
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == 200) {
                        this.cookTime = 0;
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            }
            if (flag != this.burnTime > 0) {
                flag1 = true;
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public boolean hasAllInputs(IBaseRecipeType recipeType) {
        if (recipeType == null) {
            return false;
        }
        for (Object input : recipeType.getInputs()) {
            boolean hasItem = false;
            boolean useOreDict = input instanceof String || recipeType.useOreDic();
            boolean checkSize = input instanceof ItemStack;
            for (int inputslot = 0; inputslot < 2; ++inputslot) {
                if (!ItemUtils.isInputEqual(input, (ItemStack)this.inventory.func_70301_a(inputslot), (boolean)true, (boolean)true, (boolean)useOreDict)) continue;
                ItemStack stack = RecipeTranslator.getStackFromObject(input);
                if (checkSize && this.inventory.func_70301_a(inputslot).func_190916_E() < stack.func_190916_E()) continue;
                hasItem = true;
            }
            if (hasItem) continue;
            return false;
        }
        return true;
    }

    private boolean canSmelt() {
        if (this.func_70301_a(this.input1).func_190926_b() || this.func_70301_a(this.input2).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = null;
        for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName((String)Reference.ALLOY_SMELTER_RECIPE)) {
            if (!this.hasAllInputs(recipeType)) continue;
            itemstack = recipeType.getOutput(0);
            break;
        }
        if (itemstack == null) {
            return false;
        }
        if (this.func_70301_a(this.output).func_190926_b()) {
            return true;
        }
        if (!this.func_70301_a(this.output).func_77969_a(itemstack)) {
            return false;
        }
        int result = this.func_70301_a(this.output).func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= this.func_70301_a(this.output).func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = ItemStack.field_190927_a;
            for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName((String)Reference.ALLOY_SMELTER_RECIPE)) {
                if (this.hasAllInputs(recipeType)) {
                    itemstack = recipeType.getOutput(0);
                    break;
                }
                if (itemstack.func_190926_b()) continue;
                break;
            }
            if (this.func_70301_a(this.output).func_190926_b()) {
                this.func_70299_a(this.output, itemstack.func_77946_l());
            } else if (this.func_70301_a(this.output).func_77973_b() == itemstack.func_77973_b()) {
                this.func_70298_a(this.output, -itemstack.func_190916_E());
            }
            for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName((String)Reference.ALLOY_SMELTER_RECIPE)) {
                boolean hasAllRecipes = true;
                if (!this.hasAllInputs(recipeType)) {
                    hasAllRecipes = false;
                }
                if (!hasAllRecipes) continue;
                block2: for (Object input : recipeType.getInputs()) {
                    boolean useOreDict = input instanceof String || recipeType.useOreDic();
                    for (int inputSlot = 0; inputSlot < 2; ++inputSlot) {
                        if (!ItemUtils.isInputEqual(input, (ItemStack)this.inventory.func_70301_a(inputSlot), (boolean)true, (boolean)true, (boolean)useOreDict)) continue;
                        int count = 1;
                        if (input instanceof ItemStack) {
                            count = RecipeTranslator.getStackFromObject(input).func_190916_E();
                        }
                        this.inventory.func_70298_a(inputSlot, count);
                        continue block2;
                    }
                }
            }
        }
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public int getBurnTimeRemainingScaled(int scale) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.burnTime * scale / this.currentItemBurnTime;
    }

    public int getCookProgressScaled(int scale) {
        return this.cookTime * scale / 200;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.IRON_ALLOY_FURNACE, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getCurrentItemBurnTime() {
        return this.currentItemBurnTime;
    }

    public void setCurrentItemBurnTime(int currentItemBurnTime) {
        this.currentItemBurnTime = currentItemBurnTime;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public void setCookTime(int cookTime) {
        this.cookTime = cookTime;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("alloyfurnace").player(player.field_71071_by).inventory(8, 84).hotbar(8, 142).addInventory().tile((IInventory)this).filterSlot(0, 47, 17, stack -> RecipeHandler.recipeList.stream().anyMatch(recipe -> recipe instanceof AlloySmelterRecipe && ItemUtils.isInputEqual(recipe.getInputs().get(0), (ItemStack)stack, (boolean)true, (boolean)true, (boolean)true))).filterSlot(1, 65, 17, stack -> RecipeHandler.recipeList.stream().anyMatch(recipe -> recipe instanceof AlloySmelterRecipe && ItemUtils.isInputEqual(recipe.getInputs().get(1), (ItemStack)stack, (boolean)true, (boolean)true, (boolean)true))).outputSlot(2, 116, 35).fuelSlot(3, 56, 53).syncIntegerValue(this::getBurnTime, this::setBurnTime).syncIntegerValue(this::getCookTime, this::setCookTime).syncIntegerValue(this::getCurrentItemBurnTime, this::setCurrentItemBurnTime).addInventory().create((TileLegacyMachineBase)this);
    }

    public boolean canBeUpgraded() {
        return false;
    }
}

