/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import techreborn.api.generator.EFluidGenerator;
import techreborn.init.ModBlocks;
import techreborn.tiles.generator.TileBaseFluidGenerator;

@RebornRegistry(modID="techreborn")
public class TileSemiFluidGenerator
extends TileBaseFluidGenerator
implements IContainerProvider {
    @ConfigRegistry(config="generators", category="semifluid_generator", key="SemifluidGeneratorMaxOutput", comment="Semifluid Generator Max Output (Value in EU)")
    public static int maxOutput = 128;
    @ConfigRegistry(config="generators", category="semifluid_generator", key="SemifluidGeneratorMaxEnergy", comment="Semifluid Generator Max Energy (Value in EU)")
    public static int maxEnergy = 1000000;
    @ConfigRegistry(config="generators", category="semifluid_generator", key="SemifluidGeneratorTankCapacity", comment="Semifluid Generator Tank Capacity")
    public static int tankCapacity = 10000;
    @ConfigRegistry(config="generators", category="semifluid_generator", key="SemifluidGeneratorEnergyPerTick", comment="Semifluid Generator Energy Per Tick (Value in EU)")
    public static int energyPerTick = 8;

    public TileSemiFluidGenerator() {
        super(EFluidGenerator.SEMIFLUID, "TileSemiFluidGenerator", tankCapacity, energyPerTick);
    }

    public ItemStack getToolDrop(EntityPlayer playerIn) {
        return new ItemStack(ModBlocks.SEMI_FLUID_GENERATOR, 1);
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    @Override
    public double getBaseMaxOutput() {
        return maxOutput;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("semifluidgenerator").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 25, 35).outputSlot(1, 25, 55).syncEnergyValue().syncIntegerValue(this::getTicksSinceLastChange, this::setTicksSinceLastChange).syncIntegerValue(this::getTankAmount, this::setTankAmount).addInventory().create((TileLegacyMachineBase)this);
    }
}

