/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.api.IToolDrop;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import techreborn.init.ModBlocks;

@RebornRegistry(modID="techreborn")
public class TileLightningRod
extends TilePowerAcceptor
implements IToolDrop {
    @ConfigRegistry(config="generators", category="lightning_rod", key="LightningRodMaxOutput", comment="Lightning Rod Max Output (Value in EU)")
    public static int maxOutput = 2048;
    @ConfigRegistry(config="generators", category="lightning_rod", key="LightningRodMaxEnergy", comment="Lightning Rod Max Energy (Value in EU)")
    public static int maxEnergy = 100000000;
    @ConfigRegistry(config="generators", category="lightning_rod", key="LightningRodChanceOfStrike", comment="Chance of lightning striking a rod (Range: 0-70)")
    public static int chanceOfStrike = 24;
    @ConfigRegistry(config="generators", category="lightning_rod", key="LightningRodBaseStrikeEnergy", comment="Base amount of energy per strike (Value in EU)")
    public static int baseEnergyStrike = 262144;
    private int onStatusHoldTicks = -1;

    public void func_73660_a() {
        float lightStrikeChance;
        float totalChance;
        float weatherStrength;
        super.func_73660_a();
        if (this.onStatusHoldTicks > 0) {
            --this.onStatusHoldTicks;
        }
        if (this.onStatusHoldTicks == 0 || this.getEnergy() <= 0.0) {
            if (this.func_145838_q() instanceof BlockMachineBase) {
                ((BlockMachineBase)this.func_145838_q()).setActive(Boolean.valueOf(false), this.field_145850_b, this.field_174879_c);
            }
            this.onStatusHoldTicks = -1;
        }
        if ((weatherStrength = this.field_145850_b.func_72819_i(1.0f)) > 0.2f && this.field_145850_b.field_73012_v.nextInt((int)Math.floor(totalChance = (lightStrikeChance = (100.0f - (float)chanceOfStrike) * 20.0f) * this.getLightningStrikeMultiplier() * (1.1f - weatherStrength))) == 0) {
            if (!this.isValidIronFence(this.field_174879_c.func_177984_a().func_177956_o())) {
                this.onStatusHoldTicks = 400;
                return;
            }
            EntityLightningBolt lightningBolt = new EntityLightningBolt(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)this.field_145850_b.field_73011_w.func_76557_i(), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), false);
            this.field_145850_b.func_72942_c((Entity)lightningBolt);
            this.field_145850_b.func_72838_d((Entity)lightningBolt);
            this.addEnergy((float)baseEnergyStrike * (0.3f + weatherStrength));
            ((BlockMachineBase)this.func_145838_q()).setActive(Boolean.valueOf(true), this.field_145850_b, this.field_174879_c);
            this.onStatusHoldTicks = 400;
        }
    }

    public float getLightningStrikeMultiplier() {
        float actualHeight = this.field_145850_b.field_73011_w.getActualHeight();
        float groundLevel = this.field_145850_b.field_73011_w.func_76557_i();
        int i = this.field_174879_c.func_177956_o() + 1;
        while ((float)i < actualHeight) {
            if (!this.isValidIronFence(i)) {
                if (groundLevel >= (float)i) {
                    return 4.3f;
                }
                float max = actualHeight - groundLevel;
                float got = (float)i - groundLevel;
                return 1.2f - got / max;
            }
            ++i;
        }
        return 4.0f;
    }

    public boolean isValidIronFence(int y) {
        Item itemBlock = Item.func_150898_a((Block)this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n(), y, this.field_174879_c.func_177952_p())).func_177230_c());
        for (ItemStack fence : OreDictionary.getOres((String)"fenceIron")) {
            if (fence.func_77973_b() != itemBlock) continue;
            return true;
        }
        return false;
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public double getBaseMaxOutput() {
        return maxOutput;
    }

    public double getBaseMaxInput() {
        return 0.0;
    }

    public ItemStack getToolDrop(EntityPlayer playerIn) {
        return new ItemStack(ModBlocks.LIGHTNING_ROD);
    }
}

