/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import techreborn.api.generator.EFluidGenerator;
import techreborn.init.ModBlocks;
import techreborn.tiles.generator.TileBaseFluidGenerator;

@RebornRegistry(modID="techreborn")
public class TileDieselGenerator
extends TileBaseFluidGenerator
implements IContainerProvider {
    @ConfigRegistry(config="generators", category="diesel_generator", key="DieselGeneratorMaxOutput", comment="Diesel Generator Max Output (Value in EU)")
    public static int maxOutput = 128;
    @ConfigRegistry(config="generators", category="diesel_generator", key="DieselGeneratorMaxEnergy", comment="Diesel Generator Max Energy (Value in EU)")
    public static int maxEnergy = 1000000;
    @ConfigRegistry(config="generators", category="diesel_generator", key="DieselGeneratorTankCapacity", comment="Diesel Generator Tank Capacity")
    public static int tankCapacity = 10000;
    @ConfigRegistry(config="generators", category="diesel_generator", key="DieselGeneratorEnergyPerTick", comment="Diesel Generator Energy Per Tick (Value in EU)")
    public static int energyPerTick = 20;

    public TileDieselGenerator() {
        super(EFluidGenerator.DIESEL, "TileDieselGenerator", tankCapacity, energyPerTick);
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.DIESEL_GENERATOR, 1);
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    @Override
    public double getBaseMaxOutput() {
        return maxOutput;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("dieselgenerator").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 25, 35).outputSlot(1, 25, 55).syncEnergyValue().syncIntegerValue(this::getTicksSinceLastChange, this::setTicksSinceLastChange).syncIntegerValue(this::getTankAmount, this::setTankAmount).addInventory().create((TileLegacyMachineBase)this);
    }
}

