/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import techreborn.init.ModBlocks;

@RebornRegistry(modID="techreborn")
public class TileChunkLoader
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    @ConfigRegistry(config="machines", category="chunk_loader", key="ChunkLoaderMaxInput", comment="Chunk Loader Max Input (Value in EU)")
    public static int maxInput = 32;
    @ConfigRegistry(config="machines", category="chunk_loader", key="ChunkLoaderMaxEnergy", comment="Chunk Loader Max Energy (Value in EU)")
    public static int maxEnergy = 10000;
    public static float wrenchDropRate = 1.0f;
    public Inventory inventory = new Inventory(1, "TileChunkLoader", 64, (TileEntity)this);
    public boolean isRunning;
    public int tickTime;

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.CHUNK_LOADER, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return maxInput;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("chunkloader").player(player.field_71071_by).inventory(8, 84).hotbar(8, 142).addInventory().create((TileLegacyMachineBase)this);
    }
}

