/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.items.tools.ItemChainsaw;

public class ItemAdvancedChainsaw
extends ItemChainsaw {
    public ItemAdvancedChainsaw() {
        super(Item.ToolMaterial.DIAMOND, "techreborn.advancedChainsaw", ConfigTechReborn.AdvancedChainsawCharge, 1.0f);
        this.cost = 250;
        this.transferLimit = 1000.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> itemList) {
        if (!this.func_194125_a(par2CreativeTabs)) {
            return;
        }
        ItemStack stack = new ItemStack(ModItems.ADVANCED_CHAINSAW);
        ItemStack charged = stack.func_77946_l();
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(charged);
        capEnergy.setEnergyStored(capEnergy.getMaxEnergyStored());
        itemList.add((Object)stack);
        itemList.add((Object)charged);
    }

    @Override
    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        for (int i = 1; i < 10; ++i) {
            BlockPos nextPos = pos.func_177981_b(i);
            IBlockState nextState = worldIn.func_180495_p(nextPos);
            if (!nextState.func_177230_c().isWood((IBlockAccess)worldIn, nextPos)) continue;
            this.breakBlock(nextPos, stack, worldIn, entityLiving, pos);
        }
        return super.func_179218_a(stack, worldIn, blockIn, pos, entityLiving);
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return Items.field_151056_x.func_150897_b(blockIn);
    }

    public void breakBlock(BlockPos pos, ItemStack stack, World world, EntityLivingBase entityLiving, BlockPos oldPos) {
        if (oldPos == pos) {
            return;
        }
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
        if (capEnergy.getEnergyStored() < this.cost) {
            return;
        }
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_185887_b(world, pos) == -1.0f) {
            return;
        }
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        capEnergy.extractEnergy(this.cost, false);
        ExternalPowerSystems.requestEnergyFromArmor((ForgePowerItemManager)capEnergy, (EntityLivingBase)entityLiving);
        blockState.func_177230_c().func_180657_a(world, (EntityPlayer)entityLiving, pos, blockState, world.func_175625_s(pos), stack);
        world.func_175698_g(pos);
        world.func_175713_t(pos);
    }
}

