/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei;

import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.StringUtils;

public class RecipeUtil {
    private static final int color = Color.darkGray.getRGB();

    private RecipeUtil() {
    }

    public static void drawInfo(@Nonnull Minecraft minecraft, int x, int y, double startCost, double euPerTick, int tickTime) {
        FontRenderer fontRenderer = minecraft.field_71466_p;
        int lineSpacing = fontRenderer.field_78288_b + 1;
        String startCostEU = PowerSystem.getLocaliszedPower((double)startCost);
        String startCostString = StringUtils.t((String)"techreborn.jei.recipe.start.cost", (Object[])new Object[]{startCostEU});
        fontRenderer.func_78276_b(startCostString, x, y, color);
        RecipeUtil.drawInfo(minecraft, x, y += lineSpacing, euPerTick, tickTime);
    }

    public static void drawInfo(@Nonnull Minecraft minecraft, int x, int y, double euPerTick, int tickTime) {
        FontRenderer fontRenderer = minecraft.field_71466_p;
        int lineSpacing = fontRenderer.field_78288_b + 1;
        String runningCostString = StringUtils.t((String)"techreborn.jei.recipe.running.cost", (Object[])new Object[]{PowerSystem.getDisplayPower().abbreviation.toUpperCase(), PowerSystem.getLocaliszedPowerFormattedNoSuffix((double)euPerTick)});
        fontRenderer.func_78276_b(runningCostString, x, y, color);
        String processingTimeString1 = StringUtils.t((String)"techreborn.jei.recipe.processing.time.1", (Object[])new Object[]{tickTime});
        String processingTimeString2 = StringUtils.t((String)"techreborn.jei.recipe.processing.time.2", (Object[])new Object[]{tickTime / 20});
        fontRenderer.func_78276_b(processingTimeString1, x, y += lineSpacing, color);
        fontRenderer.func_78276_b(processingTimeString2, x + 10, y += lineSpacing, color);
    }

    public static void setRecipeItems(@Nonnull IRecipeLayout recipeLayout, @Nonnull IIngredients ingredients, @Nullable int[] itemInputSlots, @Nullable int[] itemOutputSlots, @Nullable int[] fluidInputSlots, @Nullable int[] fluidOutputSlots) {
        int i;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        if (itemInputSlots != null) {
            List inputs = ingredients.getInputs(VanillaTypes.ITEM);
            for (i = 0; i < inputs.size() && i < itemInputSlots.length; ++i) {
                int inputSlot = itemInputSlots[i];
                guiItemStacks.set(inputSlot, (List)inputs.get(i));
            }
        }
        if (itemOutputSlots != null) {
            List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
            for (i = 0; i < outputs.size() && i < itemOutputSlots.length; ++i) {
                int outputSlot = itemOutputSlots[i];
                guiItemStacks.set(outputSlot, (List)outputs.get(i));
            }
        }
        if (fluidInputSlots != null) {
            List fluidInputs = ingredients.getInputs(VanillaTypes.FLUID);
            for (i = 0; i < fluidInputs.size() && i < fluidInputSlots.length; ++i) {
                int inputTank = fluidInputSlots[i];
                guiFluidStacks.set(inputTank, (List)fluidInputs.get(i));
            }
        }
        if (fluidOutputSlots != null) {
            List fluidOutputs = ingredients.getOutputs(VanillaTypes.FLUID);
            for (i = 0; i < fluidOutputs.size() && i < fluidOutputSlots.length; ++i) {
                int outputTank = fluidOutputSlots[i];
                guiFluidStacks.set(outputTank, (List)fluidOutputs.get(i));
            }
        }
    }
}

