/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import reborncore.RebornCore;
import reborncore.common.registration.IRegistryFactory;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.RegistryTarget;
import techreborn.compat.CompatManager;
import techreborn.compat.ICompatModule;

@IRegistryFactory.RegistryFactory
public class CompatRegistryFactory
implements IRegistryFactory {
    public Class<? extends Annotation> getAnnotation() {
        return RebornRegistry.class;
    }

    public void handleClass(Class clazz) {
        if (this.isCompatModule(clazz) && CompatManager.INSTANCE.checkConfig(clazz.getSimpleName())) {
            try {
                ICompatModule compatModule = (ICompatModule)clazz.newInstance();
                CompatManager.INSTANCE.compatModules.add(compatModule);
                RebornCore.logHelper.info((Object)("Loaded module: " + compatModule.getClass().getSimpleName()));
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Failed to register compat module", e);
            }
        }
    }

    private boolean isCompatModule(Class clazz) {
        for (Class<?> iface : clazz.getInterfaces()) {
            if (iface != ICompatModule.class) continue;
            return true;
        }
        return false;
    }

    public List<RegistryTarget> getTargets() {
        return Collections.singletonList(RegistryTarget.CLASS);
    }

    public Class<? extends FMLStateEvent> getProcessSate() {
        return FMLPreInitializationEvent.class;
    }
}

