/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import techreborn.blocks.cable.BlockCable;
import techreborn.blocks.cable.EnumCableType;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.items.ItemUpgrades;
import techreborn.items.ingredients.ItemDusts;
import techreborn.items.ingredients.ItemDustsSmall;
import techreborn.items.ingredients.ItemGems;
import techreborn.items.ingredients.ItemIngots;
import techreborn.items.ingredients.ItemNuggets;
import techreborn.items.ingredients.ItemParts;
import techreborn.items.ingredients.ItemPlates;

public class RegisterItemJsons {
    public static void registerModels() {
        RegisterItemJsons.registerItems();
        RegisterItemJsons.registerBlocks();
    }

    private static void registerItems() {
        int i;
        RegisterItemJsons.register(ModItems.CLOAKING_DEVICE, "armor/cloaking_device");
        RegisterItemJsons.register(ModItems.LAPOTRONIC_ORB_PACK, "armor/lapotronic_orbpack");
        RegisterItemJsons.register(ModItems.LITHIUM_BATTERY_PACK, "armor/lithium_batpack");
        RegisterItemJsons.register(ModItems.ENERGY_CRYSTAL, "battery/energy_crystal");
        RegisterItemJsons.register(ModItems.LAPOTRONIC_CRYSTAL, "battery/lapotron_crystal");
        RegisterItemJsons.register(ModItems.LAPOTRONIC_ORB, "battery/lapotronic_orb");
        RegisterItemJsons.register(ModItems.LITHIUM_BATTERY, "battery/lithium_battery");
        RegisterItemJsons.register(ModItems.RE_BATTERY, "battery/re_battery");
        RegisterItemJsons.register(ModItems.ADVANCED_CHAINSAW, "tool/advanced_chainsaw");
        RegisterItemJsons.register(ModItems.ADVANCED_DRILL, "tool/advanced_drill");
        RegisterItemJsons.register(ModItems.ADVANCED_JACKHAMMER, "tool/advanced_jackhammer");
        RegisterItemJsons.register(ModItems.DEBUG, "tool/debug");
        RegisterItemJsons.register(ModItems.DIAMOND_CHAINSAW, "tool/diamond_chainsaw");
        RegisterItemJsons.register(ModItems.DIAMOND_DRILL, "tool/diamond_drill");
        RegisterItemJsons.register(ModItems.DIAMOND_JACKHAMMER, "tool/diamond_jackhammer");
        RegisterItemJsons.register(ModItems.ELECTRIC_TREE_TAP, "tool/electric_treetap");
        RegisterItemJsons.register(ModItems.NANOSABER, "tool/nanosaber");
        RegisterItemJsons.register(ModItems.OMNI_TOOL, "tool/omni_tool");
        RegisterItemJsons.register(ModItems.ROCK_CUTTER, "tool/rock_cutter");
        RegisterItemJsons.register(ModItems.STEEL_CHAINSAW, "tool/steel_chainsaw");
        RegisterItemJsons.register(ModItems.STEEL_DRILL, "tool/steel_drill");
        RegisterItemJsons.register(ModItems.STEEL_JACKHAMMER, "tool/steel_jackhammer");
        RegisterItemJsons.register(ModItems.TREE_TAP, "tool/treetap");
        RegisterItemJsons.register(ModItems.WRENCH, "tool/wrench");
        RegisterItemJsons.register(ModItems.FREQUENCY_TRANSMITTER, "misc/frequency_transmitter");
        RegisterItemJsons.register(ModItems.MANUAL, "misc/manual");
        RegisterItemJsons.register(ModItems.MISSING_RECIPE_PLACEHOLDER, "misc/missing_recipe");
        RegisterItemJsons.register(ModItems.SCRAP_BOX, "misc/scrapbox");
        String[] name = (String[])ItemUpgrades.types.clone();
        for (i = 0; i < ItemUpgrades.types.length; ++i) {
            RegisterItemJsons.registerBlockstate(ModItems.UPGRADES, i, name[i], "items/misc/");
        }
        if (ConfigTechReborn.enableGemArmorAndTools) {
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.RUBY_HELMET, "ruby_helmet", "items/tool/armour");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.RUBY_CHESTPLATE, "ruby_chestplate", "items/tool/armour");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.RUBY_LEGGINGS, "ruby_leggings", "items/tool/armour");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.RUBY_BOOTS, "ruby_boots", "items/tool/armour");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.SAPPHIRE_HELMET, "sapphire_helmet", "items/tool/armour");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.SAPPHIRE_CHSTPLATE, "sapphire_chestplate", "items/tool/armour");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.SAPPHIRE_LEGGINGS, "sapphire_leggings", "items/tool/armour");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.SAPPHIRE_BOOTS, "sapphire_boots", "items/tool/armour");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.PERIDOT_HELMET, "peridot_helmet", "items/tool/armour");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.PERIDOT_CHESTPLATE, "peridot_chestplate", "items/tool/armour");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.PERIDOT_LEGGINGS, "peridot_leggings", "items/tool/armour");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.PERIDOT_BOOTS, "peridot_boots", "items/tool/armour");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.BRONZE_HELMET, "bronze_helmet", "items/tool/armour");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.BRONZE_CHESTPLATE, "bronze_chestplate", "items/tool/armour");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.BRONZE_LEGGINGS, "bronze_leggings", "items/tool/armour");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.BRONZE_BOOTS, "bronze_boots", "items/tool/armour");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.RUBY_PICKAXE, "ruby_pickaxe", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.RUBY_SWORD, "ruby_sword", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.RUBY_AXE, "ruby_axe", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.RUBY_SPADE, "ruby_spade", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.RUBY_HOE, "ruby_hoe", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.SAPPHIRE_PICKAXE, "sapphire_pickaxe", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.SAPPHIRE_SWORD, "sapphire_sword", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.SAPPHIRE_AXE, "sapphire_axe", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.SAPPHIRE_SPADE, "sapphire_spade", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.SAPPHIRE_HOE, "sapphire_hoe", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.PERIDOT_PICKAXE, "peridot_pickaxe", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.PERIDOT_SWORD, "peridot_sword", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.PERIDOT_AXE, "peridot_axe", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.PERIDOT_SAPPHIRE, "peridot_spade", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.PERIDOT_HOE, "peridot_hoe", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.BRONZE_PICKAXE, "bronze_pickaxe", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.BRONZE_SWORD, "bronze_sword", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.BRONZE_AXE, "bronze_axe", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.BRONZE_SPADE, "bronze_spade", "items/tool/tool");
            RegisterItemJsons.registerBlockstateMultiItem(ModItems.BRONZE_HOE, "bronze_hoe", "items/tool/tool");
        }
        name = (String[])ItemIngots.types.clone();
        for (i = 0; i < ItemIngots.types.length; ++i) {
            RegisterItemJsons.registerBlockstate(ModItems.INGOTS, i, name[i], "items/materials/");
        }
        name = (String[])ItemGems.types.clone();
        for (i = 0; i < ItemGems.types.length; ++i) {
            RegisterItemJsons.registerBlockstate(ModItems.GEMS, i, name[i], "items/materials/");
        }
        name = (String[])ItemPlates.types.clone();
        for (i = 0; i < ItemPlates.types.length; ++i) {
            if (name[i].equals("PLACEHOLDER_ITEM")) continue;
            RegisterItemJsons.registerBlockstate(ModItems.PLATES, i, name[i], "items/materials/");
        }
        name = (String[])ItemNuggets.types.clone();
        for (i = 0; i < ItemNuggets.types.length; ++i) {
            if (name[i].equals("PLACEHOLDER_ITEM")) continue;
            RegisterItemJsons.registerBlockstate(ModItems.NUGGETS, i, name[i], "items/materials/");
        }
        name = (String[])ItemDusts.types.clone();
        for (i = 0; i < ItemDusts.types.length; ++i) {
            if (name[i].equals("PLACEHOLDER_ITEM")) continue;
            RegisterItemJsons.registerBlockstate(ModItems.DUSTS, i, name[i], "items/materials/");
        }
        name = (String[])ItemDustsSmall.types.clone();
        for (i = 0; i < ItemDustsSmall.types.length; ++i) {
            if (name[i].equals("PLACEHOLDER_ITEM")) continue;
            RegisterItemJsons.registerBlockstate(ModItems.SMALL_DUSTS, i, name[i], "items/materials/");
        }
        name = (String[])ItemParts.types.clone();
        for (i = 0; i < ItemParts.types.length; ++i) {
            if (name[i].equals("PLACEHOLDER_ITEM")) continue;
            RegisterItemJsons.registerBlockstate(ModItems.PARTS, i, name[i], "items/materials/");
        }
        RegisterItemJsons.register(ModItems.UU_MATTER, "misc/uu_matter");
        for (EnumCableType cableType : EnumCableType.values()) {
            RegisterItemJsons.registerBlockstateMultiItem(Item.func_150898_a((Block)ModBlocks.CABLE), cableType.ordinal(), cableType.func_176610_l().toLowerCase(), "cable_inv");
        }
        ModelLoader.setCustomStateMapper((Block)ModBlocks.CABLE, (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                LinkedHashMap map = Maps.newLinkedHashMap((Map)state.func_177228_b());
                if (((EnumCableType)((Object)state.func_177229_b(BlockCable.TYPE))).ordinal() <= 4) {
                    return new ModelResourceLocation(new ResourceLocation(ModBlocks.CABLE.getRegistryName().func_110624_b(), ModBlocks.CABLE.getRegistryName().func_110623_a()) + "_thin", this.func_178131_a(map));
                }
                return new ModelResourceLocation(new ResourceLocation(ModBlocks.CABLE.getRegistryName().func_110624_b(), ModBlocks.CABLE.getRegistryName().func_110623_a()) + "_thick", this.func_178131_a(map));
            }
        });
    }

    private static void registerBlocks() {
        RegisterItemJsons.register(ModBlocks.REFINED_IRON_FENCE, "iron_fence");
        RegisterItemJsons.register(ModBlocks.RUBBER_SAPLING, "misc/rubber_sapling");
    }

    public static void setBlockStateMapper(final Block block, final String path, final IProperty<?> ... ignoredProperties) {
        final String slash = !path.isEmpty() ? "/" : "";
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                LinkedHashMap map = Maps.newLinkedHashMap((Map)state.func_177228_b());
                for (IProperty iproperty : ignoredProperties) {
                    map.remove(iproperty);
                }
                return new ModelResourceLocation(new ResourceLocation(block.getRegistryName().func_110624_b(), path + slash + block.getRegistryName().func_110623_a()), this.func_178131_a(map));
            }
        });
    }

    private static void register(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("techreborn:" + name, "inventory"));
    }

    private static void register(Item item, String name) {
        RegisterItemJsons.register(item, 0, name);
    }

    private static void register(Block block, int meta, String name) {
        RegisterItemJsons.register(Item.func_150898_a((Block)block), meta, name);
    }

    private static void register(Block block, String name) {
        RegisterItemJsons.register(Item.func_150898_a((Block)block), 0, name);
    }

    private static void registerBlockstate(Item i, int meta, String variant) {
        RegisterItemJsons.registerBlockstate(i, meta, variant, "");
    }

    private static void registerBlockstate(Item i, int meta, String variant, String dir) {
        ResourceLocation loc = new ResourceLocation("techreborn", dir + i.getRegistryName().func_110623_a());
        ModelLoader.setCustomModelResourceLocation((Item)i, (int)meta, (ModelResourceLocation)new ModelResourceLocation(loc, "type=" + variant));
    }

    private static void registerBlockstate(Block i, int meta, String variant) {
        RegisterItemJsons.registerBlockstate(i, meta, variant, "");
    }

    private static void registerBlockstate(Block i, int meta, String variant, String dir) {
        RegisterItemJsons.registerBlockstate(Item.func_150898_a((Block)i), meta, variant, dir);
    }

    private static void registerBlockstateMultiItem(Item item, String variantName, String path) {
        ResourceLocation loc = new ResourceLocation("techreborn", path);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(loc, "type=" + variantName));
    }

    private static void registerBlockstateMultiItem(Item item, int meta, String variantName, String path) {
        ResourceLocation loc = new ResourceLocation("techreborn", path);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(loc, "type=" + variantName));
    }
}

