/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mcjty.lib.McJtyLib;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSendServerCommand
implements IMessage {
    private String modid;
    private String command;
    private TypedMap arguments;

    public void fromBytes(ByteBuf buf) {
        this.modid = NetworkTools.readString(buf);
        this.command = NetworkTools.readString(buf);
        this.arguments = TypedMapTools.readArguments(buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writeString(buf, this.modid);
        NetworkTools.writeString(buf, this.command);
        TypedMapTools.writeArguments(buf, this.arguments);
    }

    public PacketSendServerCommand() {
    }

    public PacketSendServerCommand(String modid, String command, @Nonnull TypedMap arguments) {
        this.modid = modid;
        this.command = command;
        this.arguments = arguments;
    }

    public static class Handler
    implements IMessageHandler<PacketSendServerCommand, IMessage> {
        public IMessage onMessage(PacketSendServerCommand message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketSendServerCommand message, MessageContext ctx) {
            boolean result = McJtyLib.handleCommand(message.modid, message.command, (EntityPlayer)ctx.getServerHandler().field_147369_b, message.arguments);
            if (!result) {
                Logging.logError("Error handling command '" + message.command + "' for mod '" + message.modid + "'!");
            }
        }
    }
}

