/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.client;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.EnumBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.BlockPartRotation;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.block.model.WeightedBakedModel;
import net.minecraft.client.renderer.block.model.multipart.Multipart;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentKeybind;
import net.minecraft.util.text.TextComponentScore;
import net.minecraft.util.text.TextComponentSelector;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.animation.AnimationItemOverrideList;
import net.minecraftforge.client.model.animation.ModelBlockAnimation;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.logging.log4j.Logger;
import org.lwjgl.util.vector.Matrix4f;
import pl.asie.foamfix.client.FoamyItemLayerModel;
import pl.asie.foamfix.client.IDeduplicatingStorage;
import pl.asie.foamfix.shared.FoamFixShared;
import pl.asie.foamfix.util.DeduplicatingStorageTrove;
import pl.asie.foamfix.util.HashingStrategies;
import pl.asie.foamfix.util.MethodHandleHelper;

public class Deduplicator {
    private static final Set<Class> DEDUP0_CLASS = Sets.newIdentityHashSet();
    private static final Set<Class> BLACKLIST_CLASS = Sets.newIdentityHashSet();
    private static final Set<Class> IMMUTABLE_CLASS = Sets.newIdentityHashSet();
    private static final Set<Class> TRIM_ARRAYS_CLASSES = Sets.newIdentityHashSet();
    private static final Map<Class, Set<MethodHandle[]>> CLASS_FIELDS = new IdentityHashMap<Class, Set<MethodHandle[]>>();
    private static final Map<Class, MethodHandle> COLLECTION_CONSTRUCTORS = new IdentityHashMap<Class, MethodHandle>();
    private static final Style STYLE_EMPTY = new Style();
    private static final MethodHandle EM_KEY_UNIVERSE_GETTER = MethodHandleHelper.findFieldGetter(EnumMap.class, "keyUniverse");
    private static final MethodHandle EM_KEY_UNIVERSE_SETTER = MethodHandleHelper.findFieldSetter(EnumMap.class, "keyUniverse");
    private static final MethodHandle FIELD_UNPACKED_DATA_GETTER = MethodHandleHelper.findFieldGetter(UnpackedBakedQuad.class, "unpackedData");
    private static final MethodHandle FIELD_UNPACKED_DATA_SETTER = MethodHandleHelper.findFieldSetter(UnpackedBakedQuad.class, "unpackedData");
    private static final MethodHandle IPAM_MW_TRANSFORMS_GETTER = MethodHandleHelper.findFieldGetter(PerspectiveMapWrapper.class, "transforms");
    private static final MethodHandle IPAM_MW_TRANSFORMS_SETTER = MethodHandleHelper.findFieldSetter(PerspectiveMapWrapper.class, "transforms");
    private static final MethodHandle BIM_TRANSFORMS_GETTER = MethodHandleHelper.findFieldGetter("net.minecraftforge.client.model.BakedItemModel", "transforms");
    private static final MethodHandle BIM_TRANSFORMS_SETTER = MethodHandleHelper.findFieldSetter("net.minecraftforge.client.model.BakedItemModel", "transforms");
    private static final MethodHandle IOL_OVERRIDES_GETTER = MethodHandleHelper.findFieldGetter(ItemOverrideList.class, "overrides", "field_188023_b");
    private static final MethodHandle IOL_OVERRIDES_SETTER = MethodHandleHelper.findFieldSetter(ItemOverrideList.class, "overrides", "field_188023_b");
    public int successfulTrims = 0;
    public int successfuls = 0;
    public int maxRecursion = 0;
    private final Map<Object, Optional> JAVA_OPTIONALS = new IdentityHashMap<Object, Optional>();
    private final Map<Object, com.google.common.base.Optional> GUAVA_OPTIONALS = new IdentityHashMap<Object, com.google.common.base.Optional>();
    private final IDeduplicatingStorage<Object[]> KEY_UNIVERSE_STORAGE = new DeduplicatingStorageTrove<Object[]>(HashingStrategies.OBJECT_ARRAY);
    private final IDeduplicatingStorage<float[]> FLOATA_STORAGE = new DeduplicatingStorageTrove<float[]>(HashingStrategies.FLOAT_ARRAY);
    private final IDeduplicatingStorage<float[][]> FLOATAA_STORAGE = new DeduplicatingStorageTrove<float[][]>(HashingStrategies.FLOAT_ARRAY_ARRAY);
    private final IDeduplicatingStorage OBJECT_STORAGE = new DeduplicatingStorageTrove<Object>(HashingStrategies.GENERIC);
    private final IDeduplicatingStorage<ItemCameraTransforms> ICT_STORAGE = new DeduplicatingStorageTrove<ItemCameraTransforms>(HashingStrategies.ITEM_CAMERA_TRANSFORMS);
    private final Set<Object> deduplicatedObjects = Sets.newIdentityHashSet();
    private static final Set<Class> cSet;
    private static final boolean cSetProp;

    private static void addClassFromName(Set<Class> set, String className) {
        try {
            set.add(Class.forName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private boolean shouldCheckClass(Class c) {
        if (BLACKLIST_CLASS.contains(c)) {
            return false;
        }
        if (c.isPrimitive() || c.isEnum() || c.isArray() && !this.shouldCheckClass(c.getComponentType())) {
            BLACKLIST_CLASS.add(c);
            return false;
        }
        return true;
    }

    public void addObject(Object o) {
        this.OBJECT_STORAGE.deduplicate(o);
    }

    public void addObjects(Collection coll) {
        for (Object o : coll) {
            this.OBJECT_STORAGE.deduplicate(o);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object deduplicate0(Object o) {
        Object n = o;
        int size = 0;
        if (o instanceof float[]) {
            size = 24 + ((float[])o).length * 4;
            n = this.FLOATA_STORAGE.deduplicate((float[])o);
        } else if (o instanceof float[][]) {
            size = 16 + ((float[][])o).length * 4;
            float[][] arr = this.FLOATAA_STORAGE.deduplicate((float[][])o);
            if (arr != o) {
                n = arr;
                this.successfuls += arr.length;
            } else {
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = (float[])this.deduplicate0(arr[i]);
                }
            }
        } else if (o instanceof float[][][]) {
            float[][][] arr = (float[][][])o;
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (float[][])this.deduplicate0(arr[i]);
            }
        } else if (o instanceof ImmutableList || o instanceof ImmutableSet || o instanceof ImmutableMap) {
            n = this.OBJECT_STORAGE.deduplicate(o);
        } else {
            Class<?> c = o.getClass();
            if (o instanceof ResourceLocation) {
                if (ResourceLocation.class != c && ModelResourceLocation.class != c) return o;
                size = 16;
                n = this.OBJECT_STORAGE.deduplicate(o);
            } else if (Vec3d.class == c || Vec3i.class == c || BlockPos.class == c) {
                size = 16;
                n = this.OBJECT_STORAGE.deduplicate(o);
            } else if (Style.class == c) {
                if (!FoamFixShared.isCoremod) return o;
                n = this.deduplicateStyleIfCoremodPresent((Style)o);
            } else if (TRSRTransformation.class == c) {
                size = 257;
                n = this.OBJECT_STORAGE.deduplicate(o);
            } else {
                if (ItemCameraTransforms.class != c) throw new RuntimeException("Unsupported: " + c);
                size = 80;
                n = this.ICT_STORAGE.deduplicate((ItemCameraTransforms)o);
            }
        }
        if (n == o) return n;
        ++this.successfuls;
        FoamFixShared.ramSaved += size;
        return n;
    }

    private Style deduplicateStyleIfCoremodPresent(Style s) {
        while (s.field_150248_c == null && s.field_150245_d == null && s.field_150244_g == null && s.field_150243_f == null && s.field_150246_e == null && s.field_150251_h == null && s.field_150252_i == null && s.field_150247_b == null && s.field_179990_j == null) {
            s = s.field_150249_a;
            if (s != null) continue;
            return STYLE_EMPTY;
        }
        return s;
    }

    private boolean trimArray(Object o) {
        if (o instanceof ArrayList) {
            ((ArrayList)o).trimToSize();
            ++this.successfulTrims;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object deduplicateObject(Object o, int recursion) {
        if (o == null) return o;
        if (recursion > this.maxRecursion) {
            return o;
        }
        Class<?> clazz = o.getClass();
        if (!this.shouldCheckClass(clazz)) {
            return o;
        }
        if (!this.deduplicatedObjects.add(o)) {
            return o;
        }
        if (cSetProp && cSet.add(clazz)) {
            System.out.println("-" + Strings.repeat((String)"-", (int)recursion) + " " + clazz.getName());
        }
        if (o instanceof IBakedModel) {
            Object to;
            if (clazz == SimpleBakedModel.class) {
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    List l = ((IBakedModel)o).func_188616_a(null, facing, 0L);
                    this.trimArray(l);
                }
            }
            if (o instanceof PerspectiveMapWrapper) {
                try {
                    to = IPAM_MW_TRANSFORMS_GETTER.invoke(o);
                    Object object = this.deduplicate0(to);
                    if (object != null && to != object) {
                        IPAM_MW_TRANSFORMS_SETTER.invoke(o, object);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else if (clazz == BakedItemModel.class) {
                try {
                    to = BIM_TRANSFORMS_GETTER.invoke(o);
                    Object object = this.deduplicate0(to);
                    if (object != null && to != object) {
                        BIM_TRANSFORMS_SETTER.invoke(o, object);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        } else {
            Optional opt;
            if (clazz == BlockPartFace.class) {
                ((BlockPartFace)o).field_178243_e.field_178351_a = (float[])this.deduplicate0(((BlockPartFace)o).field_178243_e.field_178351_a);
                return o;
            }
            if (o instanceof BakedQuad) {
                void var3_5;
                if (clazz == BakedQuad.class && FoamFixShared.config.expUnpackBakedQuads) {
                    BakedQuad quad = (BakedQuad)o;
                    UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(quad.getFormat());
                    quad.pipe((IVertexConsumer)builder);
                    o = builder.build();
                    Class<UnpackedBakedQuad> clazz2 = UnpackedBakedQuad.class;
                }
                if (var3_5 != UnpackedBakedQuad.class) return o;
                try {
                    float[][][] array = FIELD_UNPACKED_DATA_GETTER.invokeExact((UnpackedBakedQuad)o);
                    this.deduplicate0(array);
                    return o;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return o;
            }
            if (o instanceof ResourceLocation) return this.deduplicate0(o);
            if (DEDUP0_CLASS.contains(clazz)) {
                return this.deduplicate0(o);
            }
            if (o instanceof Item || o instanceof Block || o instanceof World || o instanceof Entity || o instanceof Logger || o instanceof IRegistry || o instanceof SimpleReloadableResourceManager || o instanceof IResourcePack || o instanceof IRecipe || o instanceof Ingredient || o instanceof LanguageManager || o instanceof BlockPos.MutableBlockPos) {
                BLACKLIST_CLASS.add(clazz);
                return o;
            }
            if (o instanceof ItemOverrideList && o != ItemOverrideList.field_188022_a) {
                try {
                    List list = IOL_OVERRIDES_GETTER.invokeExact((ItemOverrideList)o);
                    if (!list.isEmpty()) return o;
                    if (clazz == ItemOverrideList.class) {
                        ++this.successfuls;
                        return ItemOverrideList.field_188022_a;
                    }
                    if (clazz != AnimationItemOverrideList.class) return o;
                    IOL_OVERRIDES_SETTER.invokeExact((ItemOverrideList)o, (List)ImmutableList.of());
                    ++this.successfuls;
                    return o;
                }
                catch (Throwable list) {
                    // empty catch block
                }
                return o;
            }
            if (o instanceof Optional) {
                opt = (Optional)o;
                if (!opt.isPresent()) return opt;
                Object object = this.deduplicateObject(opt.get(), recursion + 1);
                if (object != null) {
                    if (this.JAVA_OPTIONALS.containsKey(object)) {
                        ++this.successfuls;
                        return this.JAVA_OPTIONALS.get(object);
                    }
                    if (object != opt.get()) {
                        Optional<Object> opt2 = Optional.of(object);
                        this.JAVA_OPTIONALS.put(object, opt2);
                        return opt2;
                    }
                    this.JAVA_OPTIONALS.put(opt.get(), opt);
                    return opt;
                }
            } else if (o instanceof com.google.common.base.Optional) {
                opt = (com.google.common.base.Optional)o;
                if (!opt.isPresent()) return opt;
                Object object = this.deduplicateObject(opt.get(), recursion + 1);
                if (object != null) {
                    if (this.GUAVA_OPTIONALS.containsKey(object)) {
                        ++this.successfuls;
                        return this.GUAVA_OPTIONALS.get(object);
                    }
                    if (object != opt.get()) {
                        com.google.common.base.Optional opt2 = com.google.common.base.Optional.of((Object)object);
                        this.GUAVA_OPTIONALS.put(object, opt2);
                        return opt2;
                    }
                    this.GUAVA_OPTIONALS.put(opt.get(), (com.google.common.base.Optional)opt);
                    return opt;
                }
            } else {
                if (o instanceof Multimap) {
                    if (o instanceof ImmutableMultimap || o instanceof SortedSetMultimap) {
                        Iterator opt2 = ((Multimap)o).values().iterator();
                        while (opt2.hasNext()) {
                            Object e = opt2.next();
                            this.deduplicateObject(e, recursion + 1);
                        }
                        return o;
                    }
                    Iterator opt2 = ((Multimap)o).keySet().iterator();
                    while (opt2.hasNext()) {
                        Object e = opt2.next();
                        ArrayList l = Lists.newArrayList((Iterable)((Multimap)o).values());
                        for (int i = 0; i < l.size(); ++i) {
                            l.set(i, this.deduplicateObject(l.get(i), recursion + 1));
                        }
                        ((Multimap)o).replaceValues(e, (Iterable)l);
                    }
                    return o;
                }
                if (o instanceof Map) {
                    Object im;
                    for (Object k : ((Map)o).keySet()) {
                        this.deduplicateObject(k, recursion + 1);
                    }
                    if (o instanceof SortedMap || IMMUTABLE_CLASS.contains(clazz)) {
                        Iterator<Object> opt2 = ((Map)o).values().iterator();
                        while (opt2.hasNext()) {
                            Object object = opt2.next();
                            this.deduplicateObject(object, recursion + 1);
                        }
                        return o;
                    }
                    if (o instanceof ImmutableMap) {
                        im = (ImmutableMap)o;
                        ImmutableBiMap.Builder builder = o instanceof ImmutableBiMap ? ImmutableBiMap.builder() : ImmutableMap.builder();
                        boolean deduplicated = false;
                        UnmodifiableIterator i = im.keySet().iterator();
                        while (i.hasNext()) {
                            Object key;
                            Object a = im.get(key = i.next());
                            Object b = this.deduplicateObject(a, recursion + 1);
                            builder.put(key, b != null ? b : a);
                            if (b == null || b == a) continue;
                            deduplicated = true;
                        }
                        return deduplicated ? builder.build() : o;
                    }
                    try {
                        im = ((Map)o).keySet().iterator();
                        while (im.hasNext()) {
                            Object e = im.next();
                            Object value = ((Map)o).get(e);
                            Object valueD = this.deduplicateObject(value, recursion + 1);
                            if (valueD == null || value == valueD) continue;
                            ((Map)o).put(e, valueD);
                        }
                        return o;
                    }
                    catch (UnsupportedOperationException e) {
                        IMMUTABLE_CLASS.add(clazz);
                        Iterator iterator = ((Map)o).values().iterator();
                        while (iterator.hasNext()) {
                            Object v = iterator.next();
                            this.deduplicateObject(v, recursion + 1);
                        }
                        return o;
                    }
                }
                if (o instanceof Collection) {
                    Object constructor;
                    if (o instanceof List) {
                        if (IMMUTABLE_CLASS.contains(clazz)) {
                            void var5_42;
                            List l = (List)o;
                            boolean bl = false;
                            while (var5_42 < l.size()) {
                                this.deduplicateObject(l.get((int)var5_42), recursion + 1);
                                ++var5_42;
                            }
                            return o;
                        }
                        if (o instanceof ImmutableList) {
                            ImmutableList il = (ImmutableList)o;
                            ImmutableList.Builder builder = ImmutableList.builder();
                            boolean deduplicated = false;
                            for (int i = 0; i < il.size(); ++i) {
                                Object a = il.get(i);
                                Object b = this.deduplicateObject(a, recursion + 1);
                                builder.add(b != null ? b : a);
                                if (b == null || b == a) continue;
                                deduplicated = true;
                            }
                            if (!deduplicated) return o;
                            return builder.build();
                        }
                        List l = (List)o;
                        try {
                            void var5_45;
                            boolean bl = false;
                            while (var5_45 < l.size()) {
                                l.set((int)var5_45, this.deduplicateObject(l.get((int)var5_45), recursion + 1));
                                ++var5_45;
                            }
                            return o;
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            IMMUTABLE_CLASS.add(clazz);
                            int i = 0;
                            while (i < l.size()) {
                                this.deduplicateObject(l.get(i), recursion + 1);
                                ++i;
                            }
                            return o;
                        }
                    }
                    if (o instanceof ImmutableSet) {
                        if (!(o instanceof ImmutableSortedSet)) {
                            ImmutableSet.Builder builder = new ImmutableSet.Builder();
                            Iterator iterator = ((Set)o).iterator();
                            while (iterator.hasNext()) {
                                Object o1 = iterator.next();
                                builder.add(this.deduplicateObject(o1, recursion + 1));
                            }
                            return builder.build();
                        }
                        Iterator builder = ((Set)o).iterator();
                        while (builder.hasNext()) {
                            Object e = builder.next();
                            this.deduplicateObject(e, recursion + 1);
                        }
                        return o;
                    }
                    if (o instanceof Set && !(o instanceof SortedSet)) {
                        if (!COLLECTION_CONSTRUCTORS.containsKey(clazz)) {
                            try {
                                COLLECTION_CONSTRUCTORS.put(clazz, MethodHandles.publicLookup().findConstructor(clazz, MethodType.methodType(Void.TYPE)));
                            }
                            catch (Exception e) {
                                COLLECTION_CONSTRUCTORS.put(clazz, null);
                            }
                        }
                        if ((constructor = COLLECTION_CONSTRUCTORS.get(clazz)) != null) {
                            try {
                                Collection collection = constructor.invoke();
                                if (collection != null) {
                                    Iterator o1 = ((Collection)o).iterator();
                                    while (o1.hasNext()) {
                                        Object o12 = o1.next();
                                        collection.add(this.deduplicateObject(o12, recursion + 1));
                                    }
                                    return collection;
                                }
                            }
                            catch (Throwable throwable) {
                                COLLECTION_CONSTRUCTORS.put(clazz, null);
                            }
                        }
                    }
                    constructor = ((Collection)o).iterator();
                    while (constructor.hasNext()) {
                        Object e = constructor.next();
                        this.deduplicateObject(e, recursion + 1);
                    }
                    return o;
                }
                if (clazz.isArray()) {
                    int i = 0;
                    while (i < Array.getLength(o)) {
                        Object object = Array.get(o, i);
                        Object entryD = this.deduplicateObject(object, recursion + 1);
                        if (entryD != null && object != entryD) {
                            Array.set(o, i, entryD);
                        }
                        ++i;
                    }
                    return o;
                }
            }
        }
        boolean canTrim = o instanceof Predicate || TRIM_ARRAYS_CLASSES.contains(clazz);
        Iterator iterator = CLASS_FIELDS.computeIfAbsent(clazz, cl -> {
            ImmutableSet.Builder fsBuilder = ImmutableSet.builder();
            Class cc = cl;
            do {
                for (Field f : cc.getDeclaredFields()) {
                    if ((f.getModifiers() & 8) != 0 || !this.shouldCheckClass(f.getType())) continue;
                    try {
                        f.setAccessible(true);
                        fsBuilder.add((Object)new MethodHandle[]{MethodHandles.lookup().unreflectGetter(f), MethodHandles.lookup().unreflectSetter(f)});
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            } while ((cc = cc.getSuperclass()) != Object.class);
            return fsBuilder.build();
        }).iterator();
        while (iterator.hasNext()) {
            MethodHandle[] mh = (MethodHandle[])iterator.next();
            try {
                Object value = mh[0].invoke(o);
                Object valueD = this.deduplicateObject(value, recursion + 1);
                if (valueD == null) continue;
                if (canTrim) {
                    this.trimArray(valueD);
                }
                if (valueD == value) continue;
                mh[1].invoke(o, valueD);
            }
            catch (IllegalAccessException value) {
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return o;
    }

    static {
        DEDUP0_CLASS.add(TRSRTransformation.class);
        DEDUP0_CLASS.add(Style.class);
        DEDUP0_CLASS.add(Vec3d.class);
        DEDUP0_CLASS.add(Vec3i.class);
        DEDUP0_CLASS.add(BlockPos.class);
        DEDUP0_CLASS.add(ItemCameraTransforms.class);
        TRIM_ARRAYS_CLASSES.add(TextComponentKeybind.class);
        TRIM_ARRAYS_CLASSES.add(TextComponentScore.class);
        TRIM_ARRAYS_CLASSES.add(TextComponentSelector.class);
        TRIM_ARRAYS_CLASSES.add(TextComponentString.class);
        TRIM_ARRAYS_CLASSES.add(TextComponentTranslation.class);
        TRIM_ARRAYS_CLASSES.add(VertexFormat.class);
        TRIM_ARRAYS_CLASSES.add(ModelBlock.class);
        TRIM_ARRAYS_CLASSES.add(ItemOverrideList.class);
        TRIM_ARRAYS_CLASSES.add(FoamyItemLayerModel.DynamicItemModel.class);
        TRIM_ARRAYS_CLASSES.add(SimpleBakedModel.class);
        TRIM_ARRAYS_CLASSES.add(WeightedBakedModel.class);
        TRIM_ARRAYS_CLASSES.add(Multipart.class);
        BLACKLIST_CLASS.add(Object.class);
        BLACKLIST_CLASS.add(String.class);
        BLACKLIST_CLASS.add(Integer.class);
        BLACKLIST_CLASS.add(Long.class);
        BLACKLIST_CLASS.add(Byte.class);
        BLACKLIST_CLASS.add(Boolean.class);
        BLACKLIST_CLASS.add(Float.class);
        BLACKLIST_CLASS.add(Double.class);
        BLACKLIST_CLASS.add(Short.class);
        BLACKLIST_CLASS.add(Class.class);
        BLACKLIST_CLASS.add(Field.class);
        BLACKLIST_CLASS.add(Method.class);
        BLACKLIST_CLASS.add(MethodHandle.class);
        BLACKLIST_CLASS.add(Vector3f.class);
        BLACKLIST_CLASS.add(Vector4f.class);
        BLACKLIST_CLASS.add(javax.vecmath.Matrix4f.class);
        BLACKLIST_CLASS.add(org.lwjgl.util.vector.Vector3f.class);
        BLACKLIST_CLASS.add(org.lwjgl.util.vector.Vector4f.class);
        BLACKLIST_CLASS.add(Matrix4f.class);
        BLACKLIST_CLASS.add(Random.class);
        BLACKLIST_CLASS.add(TextureAtlasSprite.class);
        BLACKLIST_CLASS.add(ItemStack.class);
        BLACKLIST_CLASS.add(Gson.class);
        BLACKLIST_CLASS.add(GsonBuilder.class);
        BLACKLIST_CLASS.add(EnumBiMap.class);
        BLACKLIST_CLASS.add(ModelLoader.class);
        BLACKLIST_CLASS.add(Minecraft.class);
        BLACKLIST_CLASS.add(BlockModelShapes.class);
        BLACKLIST_CLASS.add(BlockFaceUV.class);
        BLACKLIST_CLASS.add(ModelManager.class);
        BLACKLIST_CLASS.add(BlockPartRotation.class);
        BLACKLIST_CLASS.add(ModelBlockAnimation.class);
        BLACKLIST_CLASS.add(BufferBuilder.class);
        BLACKLIST_CLASS.add(SoundHandler.class);
        BLACKLIST_CLASS.add(SoundManager.class);
        BLACKLIST_CLASS.add(GameSettings.class);
        BLACKLIST_CLASS.add(Logger.class);
        BLACKLIST_CLASS.add(Joiner.class);
        BLACKLIST_CLASS.add(Tessellator.class);
        BLACKLIST_CLASS.add(Cache.class);
        BLACKLIST_CLASS.add(LoadingCache.class);
        BLACKLIST_CLASS.add(VertexFormatElement.class);
        cSet = new HashSet<Class>();
        String s = System.getProperty("pl.asie.foamfix.debugDeduplicatedClasses", "");
        cSetProp = !s.isEmpty();
    }
}

