/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.client.render;

import codechicken.lib.colour.Colour;
import codechicken.lib.lighting.LightModel;
import codechicken.lib.lighting.PlanarLightModel;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.MultiIconTransformation;
import codechicken.wirelessredstone.part.TransceiverPart;
import codechicken.wirelessredstone.part.WirelessPart;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;

public class RenderWireless
implements TextureUtils.IIconRegister {
    private static MultiIconTransformation model_icont;
    private static MultiIconTransformation[] base_icont;
    private static CCModel[][] models;
    private static TextureAtlasSprite base;
    private static TextureAtlasSprite on;
    private static TextureAtlasSprite off;
    private static TextureAtlasSprite blaze;
    private static LightModel lm;
    private static PlanarLightModel rlm;

    private static CCModel setTex(CCModel model, int index) {
        for (Vertex5 v : model.verts) {
            v.uv.tex = index;
        }
        return model;
    }

    public void registerIcons(TextureMap textureMap) {
        base = textureMap.func_174942_a(new ResourceLocation("wrcbe:blocks/base"));
        on = textureMap.func_174942_a(new ResourceLocation("wrcbe:blocks/on"));
        off = textureMap.func_174942_a(new ResourceLocation("wrcbe:blocks/off"));
        blaze = textureMap.func_174942_a(new ResourceLocation("wrcbe:blocks/blaze"));
    }

    public static void postRegisterIcons() {
        TextureAtlasSprite obsidian = TextureUtils.getBlockTexture((String)"obsidian");
        model_icont = new MultiIconTransformation(new TextureAtlasSprite[]{base, blaze, obsidian});
        RenderWireless.base_icont[0] = new MultiIconTransformation(new TextureAtlasSprite[]{base, off, base, base, base, base});
        RenderWireless.base_icont[1] = new MultiIconTransformation(new TextureAtlasSprite[]{base, on, base, base, base, base});
    }

    public static void renderInv(CCRenderState ccrs, WirelessPart p) {
        ccrs.reset();
        ccrs.pullLightmap();
        ccrs.startDrawing(7, DefaultVertexFormats.field_176599_b);
        ccrs.setPipeline(new IVertexOperation[]{p.rotationT().at(Vector3.center), base_icont[0]});
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)WirelessPart.baseBounds(0), (int)0);
        models[p.modelId()][p.side() << 2 | p.rotation()].render(ccrs, new IVertexOperation[]{model_icont});
        ccrs.draw();
        RenderWireless.renderPearl(ccrs, Vector3.zero, p);
    }

    public static void renderWorld(CCRenderState ccrs, WirelessPart p) {
        ccrs.reset();
        ccrs.setBrightness((IBlockAccess)p.world(), p.pos());
        Translation t = new Translation((Vec3i)p.pos());
        ccrs.setPipeline(new IVertexOperation[]{p.rotationT().at(Vector3.center).with((Transformation)t), base_icont[p.textureSet()], rlm});
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)p.baseRenderBounds, (int)p.baseRenderMask);
        models[p.modelId()][p.side() << 2 | p.rotation()].render(ccrs, new IVertexOperation[]{t, model_icont});
    }

    public static void renderFreq(Vector3 pos, TransceiverPart p) {
        GlStateManager.func_179094_E();
        pos.copy().add(Vector3.center).translation().glApply();
        p.rotationT().glApply();
        RenderWireless.renderFreq(p.getFreq());
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderWireless.renderFreq(p.getFreq());
        GlStateManager.func_179121_F();
    }

    private static void renderFreq(int freq) {
        float scale = 0.015625f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)-0.3125, (double)0.374);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String s = Integer.toString(freq);
        GlStateManager.func_179132_a((boolean)false);
        font.func_78276_b(s, -font.func_78256_a(s) / 2, 0, 0);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    public static void renderPearl(CCRenderState ccrs, Vector3 pos, WirelessPart p) {
        GlStateManager.func_179094_E();
        pos.translation().glApply();
        p.rotationT().at(Vector3.center).glApply();
        p.getPearlPos().translation().glApply();
        p.getPearlRotation().glApply();
        new Scale(p.getPearlScale()).glApply();
        float light = 1.0f;
        if (p.tile() != null) {
            GlStateManager.func_179114_b((float)((float)(p.getPearlSpin() * 57.29577951308232)), (float)0.0f, (float)1.0f, (float)0.0f);
            light = p.getPearlLight();
        }
        GlStateManager.func_179140_f();
        ccrs.reset();
        TextureUtils.changeTexture((String)"wrcbe:textures/hedronmap.png");
        ccrs.pullLightmap();
        ccrs.colour = Colour.packRGBA((double)light, (double)light, (double)light, (double)1.0);
        ccrs.startDrawing(4, DefaultVertexFormats.field_181710_j);
        CCModelLibrary.icosahedron4.render(ccrs, new IVertexOperation[0]);
        ccrs.draw();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public static TextureAtlasSprite getBreakingIcon(int tex) {
        return RenderWireless.base_icont[tex].icons[1];
    }

    static {
        int j;
        base_icont = new MultiIconTransformation[2];
        models = new CCModel[3][24];
        lm = new LightModel().setAmbient(new Vector3(0.7, 0.7, 0.7)).addLight(new LightModel.Light(new Vector3(0.2, 1.0, -0.7)).setDiffuse(new Vector3(0.3, 0.3, 0.3))).addLight(new LightModel.Light(new Vector3(-0.2, 1.0, 0.7)).setDiffuse(new Vector3(0.3, 0.3, 0.3))).addLight(new LightModel.Light(new Vector3(0.7, -1.0, -0.2)).setDiffuse(new Vector3(0.2, 0.2, 0.2))).addLight(new LightModel.Light(new Vector3(-0.7, -1.0, 0.2)).setDiffuse(new Vector3(0.2, 0.2, 0.2)));
        rlm = lm.reducePlanar();
        Map modelMap = OBJParser.parseModels((ResourceLocation)new ResourceLocation("wrcbe", "models/logic.obj"), (int)7, null);
        CCModel tstand = RenderWireless.setTex((CCModel)modelMap.get("TStand"), 2);
        CCModel jstand = RenderWireless.setTex(tstand.copy(), 1);
        CCModel rstand = RenderWireless.setTex((CCModel)modelMap.get("RStand"), 2);
        CCModel rdish = ((CCModel)modelMap.get("RDish")).shrinkUVs(5.0E-4);
        RenderWireless.models[0][0] = tstand;
        RenderWireless.models[1][0] = CCModel.combine(Arrays.asList(rstand, rdish));
        RenderWireless.models[2][0] = jstand;
        for (int i = 0; i < 3; ++i) {
            models[i][0].computeNormals();
        }
        for (j = 1; j < 24; ++j) {
            Transformation t = Rotation.sideOrientation((int)(j >> 2), (int)(j & 3)).at(Vector3.center);
            for (int i = 0; i < models.length; ++i) {
                RenderWireless.models[i][j] = models[i][0].copy().apply(t);
            }
        }
        for (j = 0; j < 24; ++j) {
            for (int i = 0; i < 3; ++i) {
                models[i][j].computeLighting(lm);
            }
        }
    }
}

