/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.SyncPart;

public class SyncCoords
extends SyncPart {
    private BlockCoords c;

    public SyncCoords(int id) {
        super(id);
    }

    public SyncCoords(String name) {
        super(name);
    }

    public void setCoords(BlockCoords value) {
        if (this.c == null || !this.c.equals(value)) {
            this.c = value;
            this.markChanged();
        }
    }

    public BlockCoords getCoords() {
        return this.c;
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        if (this.c != null) {
            buf.writeBoolean(true);
            BlockCoords.writeToBuf(buf, this.c);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.c = BlockCoords.readFromBuf(buf);
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.c != null) {
            NBTTagCompound infoTag = new NBTTagCompound();
            BlockCoords.writeToNBT(infoTag, this.c);
            nbt.func_74782_a(this.getTagName(), (NBTBase)infoTag);
        }
        return nbt;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (nbt.func_74764_b(this.getTagName())) {
            this.c = BlockCoords.readFromNBT(nbt.func_74775_l(this.getTagName()));
        }
    }
}

