/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.integration.crafttweaker;

import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import java.util.ArrayList;
import java.util.List;
import sonar.core.integration.crafttweaker.CraftTweakerHelper;
import sonar.core.recipes.DefinedRecipeHelper;
import sonar.core.recipes.ISonarRecipeObject;
import sonar.core.recipes.RecipeHelperV2;
import sonar.core.recipes.ValueHelperV2;

public class SonarAddRecipe<HELPER extends RecipeHelperV2>
implements IAction {
    public HELPER recipes;
    public List<ISonarRecipeObject> sonar_inputs = new ArrayList<ISonarRecipeObject>();
    public List<ISonarRecipeObject> sonar_outputs = new ArrayList<ISonarRecipeObject>();
    public boolean valid = true;

    public SonarAddRecipe(HELPER recipes, List<IIngredient> inputs, List<IIngredient> outputs) {
        ISonarRecipeObject obj;
        this.recipes = recipes;
        for (IIngredient i : inputs) {
            obj = CraftTweakerHelper.convertItemIngredient(i);
            if (obj == null) {
                this.valid = false;
                CraftTweakerAPI.logError((String)String.format("%s: INVALID INPUT: %s", ((RecipeHelperV2)recipes).getRecipeID(), i));
                continue;
            }
            this.sonar_inputs.add(obj);
        }
        for (IIngredient i : outputs) {
            obj = CraftTweakerHelper.convertItemIngredient(i);
            if (obj == null) {
                this.valid = false;
                CraftTweakerAPI.logError((String)String.format("%s: INVALID OUTPUT : %s", ((RecipeHelperV2)recipes).getRecipeID(), i));
                continue;
            }
            this.sonar_outputs.add(obj);
        }
    }

    public void apply() {
        if (this.valid) {
            boolean isShapeless = !(this.recipes instanceof DefinedRecipeHelper) || ((DefinedRecipeHelper)this.recipes).shapeless;
            ((RecipeHelperV2)this.recipes).addRecipe(((RecipeHelperV2)this.recipes).buildRecipe(this.sonar_inputs, this.sonar_outputs, new ArrayList(), isShapeless));
        }
    }

    public String describe() {
        return String.format("Adding %s recipe (%s = %s)", ((RecipeHelperV2)this.recipes).getRecipeID(), RecipeHelperV2.getValuesFromList(this.sonar_inputs), RecipeHelperV2.getValuesFromList(this.sonar_outputs));
    }

    public static class Value
    extends SonarAddRecipe<ValueHelperV2> {
        public int recipeValue;

        public Value(ValueHelperV2 helper, List<IIngredient> inputs, List<IIngredient> outputs, int recipeValue) {
            super(helper, inputs, outputs);
            this.recipeValue = recipeValue;
        }

        @Override
        public void apply() {
            if (this.valid) {
                ((ValueHelperV2)this.recipes).addRecipe(((ValueHelperV2)this.recipes).buildRecipe(this.sonar_inputs, this.sonar_outputs, (List)Lists.newArrayList((Object[])new Integer[]{this.recipeValue}), ((ValueHelperV2)this.recipes).shapeless));
            }
        }
    }
}

