/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories.handling.methods;

import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraftforge.items.IItemHandler;
import sonar.core.handlers.inventories.handling.ITransferMethod;
import sonar.core.handlers.inventories.handling.ItemTransferHandler;

public class TransferMethodRoundRobin
implements ITransferMethod {
    public final ItemTransferHandler handler;
    private IItemHandler current_source;
    private int current_source_slot = 0;
    public Iterator<IItemHandler> source_iterator;
    public Iterator<Integer> source_slot_iterator;
    public boolean sources_changed = true;
    private IItemHandler current_destination;
    private int current_destination_slot = 0;
    public Iterator<IItemHandler> destination_iterator;
    public Iterator<Integer> destination_slot_iterator;
    public boolean destinations_changed = true;

    public TransferMethodRoundRobin(ItemTransferHandler handler) {
        this.handler = handler;
    }

    @Override
    public void transfer() {
        if (this.handler.sources.isEmpty() || this.handler.destinations.isEmpty()) {
            return;
        }
        if (this.sources_changed) {
            this.source_iterator = this.getSourceIterator();
            if (this.source_iterator == null || this.current_source == null || !this.handler.sources.contains(this.current_source)) {
                this.current_source_slot = 0;
            } else {
                this.source_iterator = null;
            }
        }
        if (this.destinations_changed && this.destination_iterator == null) {
            this.destination_iterator = this.getSourceIterator();
        }
    }

    @Nullable
    private IItemHandler getCurrentSource() {
        if (this.current_source == null) {
            this.current_source = this.getSourceIterator().next();
        }
        return this.current_source;
    }

    @Nullable
    private Iterator<IItemHandler> getSourceIterator() {
        if (this.source_iterator == null) {
            this.source_iterator = ItemTransferHandler.getItemHandlerIterator(this.handler.sources);
        }
        return this.source_iterator;
    }

    @Nullable
    private Iterator<IItemHandler> getDestinationIterator() {
        if (this.destination_iterator == null) {
            this.destination_iterator = ItemTransferHandler.getItemHandlerIterator(this.handler.destinations);
        }
        return this.destination_iterator;
    }

    private void incrementSourceSlot() {
    }

    @Override
    public void onSourcesChanged() {
        this.sources_changed = true;
    }

    @Override
    public void onDestinationsChanged() {
        this.destinations_changed = true;
    }
}

