/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.energy.items;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import net.minecraft.item.ItemStack;
import sonar.core.api.asm.ItemEnergyHandler;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.energy.IItemEnergyHandler;
import sonar.core.api.utils.ActionType;

@ItemEnergyHandler(modid="ic2", priority=4)
public class ItemHandlerEnergyUnits
implements IItemEnergyHandler {
    @Override
    public EnergyType getEnergyType() {
        return EnergyType.EU;
    }

    @Override
    public boolean canAddEnergy(ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() instanceof IElectricItem || stack.func_77973_b() instanceof ISpecialElectricItem);
    }

    @Override
    public boolean canRemoveEnergy(ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() instanceof IElectricItem || stack.func_77973_b() instanceof ISpecialElectricItem);
    }

    @Override
    public boolean canReadEnergy(ItemStack stack) {
        return this.canAddEnergy(stack);
    }

    @Override
    public long addEnergy(long add, ItemStack stack, ActionType actionType) {
        IElectricItemManager manager = ItemHandlerEnergyUnits.getManager(stack);
        return (long)manager.charge(stack, (double)add, 4, false, actionType.shouldSimulate());
    }

    @Override
    public long removeEnergy(long remove, ItemStack stack, ActionType actionType) {
        IElectricItemManager manager = ItemHandlerEnergyUnits.getManager(stack);
        return (long)manager.discharge(stack, (double)remove, 4, false, true, actionType.shouldSimulate());
    }

    @Override
    public long getStored(ItemStack stack) {
        return (long)ItemHandlerEnergyUnits.getManager(stack).getCharge(stack);
    }

    @Override
    public long getCapacity(ItemStack stack) {
        return (long)ItemHandlerEnergyUnits.getManager(stack).getMaxCharge(stack);
    }

    public static IElectricItemManager getManager(ItemStack stack) {
        if (stack.func_77973_b() instanceof ISpecialElectricItem) {
            IElectricItemManager manager = ((ISpecialElectricItem)stack.func_77973_b()).getManager(stack);
            if (manager == null) {
                manager = ElectricItem.getBackupManager((ItemStack)stack);
            }
            return manager;
        }
        return ElectricItem.manager;
    }
}

