/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.util.misc;

import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.util.CommonUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public final class NameMap<E>
implements Iterable<E>,
DataIn.Deserializer<E>,
DataOut.Serializer<E> {
    private final ObjectProperties<E> objectProperties;
    public final E defaultValue;
    public final Map<String, E> map;
    public final List<String> keys;
    public final List<E> values;

    @SafeVarargs
    public static <T> NameMap<T> create(T defaultValue, ObjectProperties<T> objectProperties, T ... values) {
        ArrayList<T> list = new ArrayList<T>(values.length);
        for (T e : values) {
            if (e == null) continue;
            list.add(e);
        }
        if (list.isEmpty()) {
            throw new IllegalStateException("Value list can't be empty!");
        }
        return new NameMap<T>(defaultValue, objectProperties, list);
    }

    @SafeVarargs
    public static <T> NameMap<T> create(T defaultValue, T ... values) {
        return NameMap.create(defaultValue, (ObjectProperties)CommonUtils.cast(ObjectProperties.DEFAULT), values);
    }

    private NameMap(E def, ObjectProperties<E> ng, List<E> v) {
        this.objectProperties = ng;
        this.values = v;
        LinkedHashMap<String, E> map0 = new LinkedHashMap<String, E>(this.size());
        for (E value : this.values) {
            map0.put(this.getName(value), value);
        }
        this.map = Collections.unmodifiableMap(map0);
        this.keys = Collections.unmodifiableList(new ArrayList<String>(this.map.keySet()));
        this.defaultValue = this.get(this.getName(def));
    }

    private NameMap(E def, NameMap<E> n) {
        this.objectProperties = n.objectProperties;
        this.map = n.map;
        this.keys = n.keys;
        this.values = n.values;
        this.defaultValue = this.get(this.getName(def));
    }

    public String getName(E value) {
        return this.objectProperties.getName(value);
    }

    public ITextComponent getDisplayName(@Nullable ICommandSender sender, E value) {
        return this.objectProperties.getDisplayName(sender, value);
    }

    public Color4I getColor(E value) {
        return this.objectProperties.getColor(value);
    }

    public NameMap<E> withDefault(E def) {
        if (def == this.defaultValue) {
            return this;
        }
        return new NameMap<E>(def, this);
    }

    public int size() {
        return this.values.size();
    }

    public E get(@Nullable String s) {
        if (s == null || s.isEmpty() || s.charAt(0) == '-') {
            return this.defaultValue;
        }
        E e = this.map.get(s);
        return e == null ? this.defaultValue : e;
    }

    @Nullable
    public E getNullable(@Nullable String s) {
        if (s == null || s.isEmpty() || s.charAt(0) == '-') {
            return null;
        }
        return this.map.get(s);
    }

    public E get(int index) {
        return index < 0 || index >= this.size() ? this.defaultValue : this.values.get(index);
    }

    public E offset(E value, int index) {
        return this.get(MathUtils.mod(this.getIndex(value) + index, this.size()));
    }

    public E getNext(E value) {
        return this.offset(value, 1);
    }

    public E getPrevious(E value) {
        return this.offset(value, -1);
    }

    public int getIndex(E e) {
        return this.values.indexOf(e);
    }

    public int getStringIndex(String s) {
        return this.getIndex(this.map.get(s));
    }

    public void writeToNBT(NBTTagCompound nbt, String name, EnumSaveType type, E value) {
        if (value == this.defaultValue) {
            return;
        }
        if (!type.save) {
            int index = this.getIndex(value);
            if (index == 0) {
                return;
            }
            if (this.size() >= 128) {
                nbt.func_74777_a(name, (short)index);
            } else {
                nbt.func_74774_a(name, (byte)index);
            }
        } else {
            nbt.func_74778_a(name, this.getName(value));
        }
    }

    public E readFromNBT(NBTTagCompound nbt, String name, EnumSaveType type) {
        if (!nbt.func_74764_b(name)) {
            return this.defaultValue;
        }
        return !type.save || nbt.func_150297_b(name, 99) ? this.get(nbt.func_74762_e(name)) : this.get(nbt.func_74779_i(name));
    }

    public E getRandom(Random rand) {
        return this.values.get(rand.nextInt(this.size()));
    }

    @Override
    public Iterator<E> iterator() {
        return this.values.iterator();
    }

    @Override
    public void write(DataOut data, E object) {
        data.writeVarInt(this.getIndex(object));
    }

    @Override
    public E read(DataIn data) {
        return this.get(data.readVarInt());
    }

    public static class ObjectProperties<T> {
        public static final ObjectProperties<Object> DEFAULT = new ObjectProperties();

        public String getName(T object) {
            return StringUtils.getID(object, 6);
        }

        public ITextComponent getDisplayName(@Nullable ICommandSender sender, T value) {
            return new TextComponentString(this.getName(value));
        }

        public Color4I getColor(T object) {
            return Icon.EMPTY;
        }

        public static <Y> ObjectProperties<Y> withName(final BiFunction<ICommandSender, Y, ITextComponent> nameGetter) {
            return new ObjectProperties<Y>(){

                @Override
                public ITextComponent getDisplayName(@Nullable ICommandSender sender, Y value) {
                    return (ITextComponent)nameGetter.apply(sender, value);
                }
            };
        }

        public static <Y> ObjectProperties<Y> withNameAndColor(final BiFunction<ICommandSender, Y, ITextComponent> nameGetter, final Function<Y, Color4I> colorGetter) {
            return new ObjectProperties<Y>(){

                @Override
                public ITextComponent getDisplayName(@Nullable ICommandSender sender, Y value) {
                    return (ITextComponent)nameGetter.apply(sender, value);
                }

                @Override
                public Color4I getColor(Y object) {
                    return (Color4I)colorGetter.apply(object);
                }
            };
        }
    }
}

