/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui;

import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;

public abstract class Button
extends Widget {
    protected String title = "";
    protected Icon icon = Icon.EMPTY;

    public Button(Panel panel) {
        super(panel);
        this.setSize(16, 16);
    }

    public Button(Panel panel, String t, Icon i) {
        this(panel);
        this.icon = i;
        this.title = t;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public Button setTitle(String s) {
        this.title = s;
        return this;
    }

    public Button setIcon(Icon i) {
        this.icon = i;
        return this;
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        theme.drawButton(x, y, w, h, this.getWidgetType());
    }

    public void drawIcon(Theme theme, int x, int y, int w, int h) {
        this.icon.draw(x, y, w, h);
    }

    @Override
    public void draw(Theme theme, int x, int y, int w, int h) {
        int s = h >= 16 ? 16 : 8;
        this.drawBackground(theme, x, y, w, h);
        this.drawIcon(theme, x + (w - s) / 2, y + (h - s) / 2, s, s);
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public abstract void onClicked(MouseButton var1);
}

