/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.events.FTBLibPreInitRegistryEvent;
import com.feed_the_beast.ftblib.events.IReloadHandler;
import com.feed_the_beast.ftblib.events.ServerReloadEvent;
import com.feed_the_beast.ftblib.lib.EnumReloadType;
import com.feed_the_beast.ftblib.lib.config.ConfigBlockState;
import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigColor;
import com.feed_the_beast.ftblib.lib.config.ConfigDouble;
import com.feed_the_beast.ftblib.lib.config.ConfigFluid;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigList;
import com.feed_the_beast.ftblib.lib.config.ConfigLong;
import com.feed_the_beast.ftblib.lib.config.ConfigNBT;
import com.feed_the_beast.ftblib.lib.config.ConfigNull;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigStringEnum;
import com.feed_the_beast.ftblib.lib.config.ConfigTeamClient;
import com.feed_the_beast.ftblib.lib.config.ConfigTextComponent;
import com.feed_the_beast.ftblib.lib.config.ConfigTimer;
import com.feed_the_beast.ftblib.lib.config.ConfigValueProvider;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.config.RankConfigAPI;
import com.feed_the_beast.ftblib.lib.data.Action;
import com.feed_the_beast.ftblib.lib.data.AdminPanelAction;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.data.FTBLibTeamGuiActions;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ISyncData;
import com.feed_the_beast.ftblib.lib.data.TeamAction;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.feed_the_beast.ftblib.net.FTBLibNetHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class FTBLibCommon {
    public static final Map<String, ConfigValueProvider> CONFIG_VALUE_PROVIDERS = new HashMap<String, ConfigValueProvider>();
    public static final Map<UUID, EditingConfig> TEMP_SERVER_CONFIG = new HashMap<UUID, EditingConfig>();
    public static final Map<String, ISyncData> SYNCED_DATA = new HashMap<String, ISyncData>();
    public static final HashMap<ResourceLocation, IReloadHandler> RELOAD_IDS = new HashMap();
    public static final Map<ResourceLocation, TeamAction> TEAM_GUI_ACTIONS = new HashMap<ResourceLocation, TeamAction>();
    public static final Map<ResourceLocation, AdminPanelAction> ADMIN_PANEL_ACTIONS = new HashMap<ResourceLocation, AdminPanelAction>();
    private static final Map<String, Function<ForgePlayer, ITextComponent>> CHAT_FORMATTING_SUBSTITUTES = new HashMap<String, Function<ForgePlayer, ITextComponent>>();

    public static Function<String, ITextComponent> chatFormattingSubstituteFunction(ForgePlayer player) {
        return s -> {
            Function<ForgePlayer, ITextComponent> sub = CHAT_FORMATTING_SUBSTITUTES.get(s);
            return sub == null ? null : sub.apply(player);
        };
    }

    public void preInit(FMLPreInitializationEvent event) {
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            FTBLib.LOGGER.info("Loading FTBLib in development environment");
        }
        FTBLibNetHandler.init();
        FTBLibPreInitRegistryEvent.Registry registry = new FTBLibPreInitRegistryEvent.Registry(){

            @Override
            public void registerConfigValueProvider(String id, ConfigValueProvider provider) {
                CONFIG_VALUE_PROVIDERS.put(id, provider);
            }

            @Override
            public void registerSyncData(String mod, ISyncData data) {
                SYNCED_DATA.put(mod, data);
            }

            @Override
            public void registerServerReloadHandler(ResourceLocation id, IReloadHandler handler) {
                RELOAD_IDS.put(id, handler);
            }

            @Override
            public void registerAdminPanelAction(AdminPanelAction action) {
                ADMIN_PANEL_ACTIONS.put(action.getId(), action);
            }

            @Override
            public void registerTeamAction(TeamAction action) {
                TEAM_GUI_ACTIONS.put(action.getId(), action);
            }
        };
        registry.registerConfigValueProvider("null", () -> ConfigNull.INSTANCE);
        registry.registerConfigValueProvider("list", () -> new ConfigList<ConfigNull>(ConfigNull.INSTANCE));
        registry.registerConfigValueProvider("bool", () -> new ConfigBoolean(false));
        registry.registerConfigValueProvider("int", () -> new ConfigInt(0));
        registry.registerConfigValueProvider("double", () -> new ConfigDouble(0.0));
        registry.registerConfigValueProvider("long", () -> new ConfigLong(0L));
        registry.registerConfigValueProvider("string", () -> new ConfigString(""));
        registry.registerConfigValueProvider("color", () -> new ConfigColor(Color4I.WHITE));
        registry.registerConfigValueProvider("enum", () -> new ConfigStringEnum(Collections.emptyList(), ""));
        registry.registerConfigValueProvider("blockstate", () -> new ConfigBlockState(BlockUtils.AIR_STATE));
        registry.registerConfigValueProvider("item_stack", () -> new ConfigItemStack(ItemStack.field_190927_a));
        registry.registerConfigValueProvider("text_component", () -> new ConfigTextComponent((ITextComponent)new TextComponentString("")));
        registry.registerConfigValueProvider("timer", () -> new ConfigTimer(Ticks.NO_TICKS));
        registry.registerConfigValueProvider("nbt", () -> new ConfigNBT(null));
        registry.registerConfigValueProvider("fluid", () -> new ConfigFluid(null, null));
        registry.registerConfigValueProvider("team", () -> new ConfigTeamClient(""));
        registry.registerServerReloadHandler(new ResourceLocation("ftblib", "config"), reloadEvent -> FTBLibConfig.sync());
        registry.registerAdminPanelAction(new AdminPanelAction("ftblib", "reload", GuiIcons.REFRESH, -1000){

            @Override
            public Action.Type getType(ForgePlayer player, NBTTagCompound data) {
                return Action.Type.fromBoolean(player.isOP());
            }

            @Override
            public void onAction(ForgePlayer player, NBTTagCompound data) {
                FTBLibAPI.reloadServer(player.team.universe, (ICommandSender)player.getPlayer(), EnumReloadType.RELOAD_COMMAND, ServerReloadEvent.ALL);
            }
        }.setTitle((ITextComponent)new TextComponentTranslation("ftblib.lang.reload_server_button", new Object[0])));
        registry.registerTeamAction(FTBLibTeamGuiActions.CONFIG);
        registry.registerTeamAction(FTBLibTeamGuiActions.INFO);
        registry.registerTeamAction(FTBLibTeamGuiActions.MEMBERS);
        registry.registerTeamAction(FTBLibTeamGuiActions.ALLIES);
        registry.registerTeamAction(FTBLibTeamGuiActions.MODERATORS);
        registry.registerTeamAction(FTBLibTeamGuiActions.ENEMIES);
        registry.registerTeamAction(FTBLibTeamGuiActions.LEAVE);
        registry.registerTeamAction(FTBLibTeamGuiActions.TRANSFER_OWNERSHIP);
        new FTBLibPreInitRegistryEvent(registry).post();
        RankConfigAPI.getHandler();
        CHAT_FORMATTING_SUBSTITUTES.put("name", ForgePlayer::getDisplayName);
        CHAT_FORMATTING_SUBSTITUTES.put("team", player -> player.team.getTitle());
    }

    public void postInit() {
    }

    public void handleClientMessage(MessageToClient message) {
    }

    public void spawnDust(World world, double x, double y, double z, float r, float g, float b, float a) {
    }

    public void spawnDust(World world, double x, double y, double z, Color4I col) {
        this.spawnDust(world, x, y, z, col.redf(), col.greenf(), col.bluef(), col.alphaf());
    }

    public long getWorldTime() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_82737_E();
    }

    public static class EditingConfig {
        public final ConfigGroup group;
        public final IConfigCallback callback;

        public EditingConfig(ConfigGroup g, IConfigCallback c) {
            this.group = g;
            this.callback = c;
        }
    }
}

