/*
 * Decompiled with CFR 0.152.
 */
package extracells.registries;

import extracells.block.BlockCertusTank;
import extracells.block.BlockFluidCrafter;
import extracells.block.BlockFluidFiller;
import extracells.block.BlockFluidInterface;
import extracells.block.BlockHardMEDrive;
import extracells.block.BlockVibrationChamberFluid;
import extracells.block.BlockWalrus;
import extracells.integration.Integration;
import extracells.item.block.ItemBlockCertusTank;
import extracells.item.block.ItemBlockFluidFiller;
import extracells.item.block.ItemBlockFluidInterface;
import extracells.util.CreativeTabEC;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.text.translation.I18n;

public enum BlockEnum {
    CERTUSTANK("certustank", (Block)new BlockCertusTank(), block -> new ItemBlockCertusTank((Block)block)),
    WALRUS("walrus", (Block)new BlockWalrus()),
    FLUIDCRAFTER("fluidcrafter", (Block)new BlockFluidCrafter()),
    ECBASEBLOCK("ecbaseblock", (Block)BlockFluidInterface.instance(), block -> new ItemBlockFluidInterface((Block)block)),
    FILLER("fluidfiller", (Block)BlockFluidFiller.instance(), block -> new ItemBlockFluidFiller((Block)block)),
    BLASTRESISTANTMEDRIVE("hardmedrive", (Block)BlockHardMEDrive.instance()),
    VIBRANTCHAMBERFLUID("vibrantchamberfluid", (Block)new BlockVibrationChamberFluid());

    private final String internalName;
    private Block block;
    private ItemBlock item;
    private Integration.Mods mod;

    private BlockEnum(String internalName, Block block, Integration.Mods mod) {
        this(internalName, block, b -> new ItemBlock(b), mod);
    }

    private BlockEnum(String internalName, Block block) {
        this(internalName, block, (Block b) -> new ItemBlock(b));
    }

    private BlockEnum(String internalName, Block block, Function<Block, ItemBlock> itemFactory) {
        this(internalName, block, itemFactory, null);
    }

    private BlockEnum(String internalName, Block block, Function<Block, ItemBlock> factory, Integration.Mods mod) {
        this.internalName = internalName;
        this.block = block;
        this.block.func_149663_c("extracells.block." + this.internalName);
        this.block.setRegistryName(internalName);
        this.item = factory.apply(block);
        this.item.setRegistryName(block.getRegistryName());
        this.mod = mod;
        if (mod == null || mod.isEnabled()) {
            this.block.func_149647_a(CreativeTabEC.INSTANCE);
        }
    }

    public Block getBlock() {
        return this.block;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public ItemBlock getItem() {
        return this.item;
    }

    public String getStatName() {
        return I18n.func_74838_a((String)(this.block.func_149739_a() + ".name"));
    }

    public Integration.Mods getMod() {
        return this.mod;
    }
}

