/*
 * Decompiled with CFR 0.152.
 */
package extracells.item.storage;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import extracells.api.IFluidStorageCell;
import extracells.inventory.ECFluidFilterInventory;
import extracells.inventory.InventoryPlain;
import extracells.item.ItemFluid;
import extracells.item.storage.CellDefinition;
import extracells.item.storage.ItemStorageCell;
import extracells.item.storage.StorageType;
import extracells.util.StorageChannels;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ItemStorageCellFluid
extends ItemStorageCell
implements IFluidStorageCell {
    public ItemStorageCellFluid() {
        super(CellDefinition.FLUID, (IStorageChannel)StorageChannels.FLUID());
    }

    public IItemHandler getConfigInventory(ItemStack is) {
        return new InvWrapper((IInventory)new ECFluidFilterInventory("configFluidCell", 63, is));
    }

    @Override
    public ArrayList<Fluid> getFilter(ItemStack stack) {
        ECFluidFilterInventory inventory = new ECFluidFilterInventory("", 63, stack);
        ItemStack[] itemStacks = inventory.slots;
        ArrayList<Fluid> filter = new ArrayList<Fluid>();
        if (itemStacks.length == 0) {
            return null;
        }
        for (ItemStack itemStack : itemStacks) {
            String fluidName;
            Fluid fluid;
            if (itemStack == null || (fluid = FluidRegistry.getFluid((String)(fluidName = ItemFluid.getFluidName(itemStack)))) == null) continue;
            filter.add(fluid);
        }
        return filter;
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        if (is == null) {
            return null;
        }
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        if (is.func_77978_p().func_74764_b("fuzzyMode")) {
            return FuzzyMode.valueOf((String)is.func_77978_p().func_74779_i("fuzzyMode"));
        }
        is.func_77978_p().func_74778_a("fuzzyMode", FuzzyMode.IGNORE_ALL.name());
        return FuzzyMode.IGNORE_ALL;
    }

    @Override
    public int getMaxBytes(ItemStack itemStack) {
        StorageType type = this.definition.cells.fromMeta(itemStack.func_77952_i());
        return type.getBytes();
    }

    @Override
    public int getMaxTypes(ItemStack unused) {
        return 5;
    }

    public IItemHandler getUpgradesInventory(ItemStack is) {
        return new InvWrapper((IInventory)new InventoryPlain("configInventory", 0, 64));
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        if (is == null) {
            return;
        }
        NBTTagCompound tag = is.func_77942_o() ? is.func_77978_p() : new NBTTagCompound();
        tag.func_74778_a("fuzzyMode", fzMode.name());
        is.func_77982_d(tag);
    }
}

