/*
 * Decompiled with CFR 0.152.
 */
package extracells.item.storage;

import appeng.api.AEApi;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.ICellRegistry;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.api.storage.IStorageChannel;
import extracells.api.IHandlerStorageBase;
import extracells.item.ItemECBase;
import extracells.item.storage.CellDefinition;
import extracells.item.storage.StorageType;
import extracells.models.ModelManager;
import extracells.registries.ItemEnum;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemStorageCell
extends ItemECBase
implements ICellWorkbenchItem {
    protected final CellDefinition definition;
    protected final IStorageChannel channel;

    public ItemStorageCell(CellDefinition definition, IStorageChannel channel) {
        this.definition = definition;
        this.channel = channel;
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List list, ITooltipFlag advanced) {
        ICellRegistry cellRegistry = AEApi.instance().registries().cell();
        ICellInventoryHandler handler = cellRegistry.getCellInventory(itemStack, null, this.channel);
        if (!(handler instanceof IHandlerStorageBase)) {
            return;
        }
        IHandlerStorageBase cellHandler = (IHandlerStorageBase)handler;
        boolean partitioned = cellHandler.isFormatted();
        long usedBytes = cellHandler.usedBytes();
        list.add(String.format(I18n.func_74838_a((String)("extracells.tooltip.storage." + (Object)((Object)this.definition) + ".bytes")), usedBytes / 250L, cellHandler.totalBytes() / 250));
        list.add(String.format(I18n.func_74838_a((String)("extracells.tooltip.storage." + (Object)((Object)this.definition) + ".types")), cellHandler.usedTypes(), cellHandler.totalTypes()));
        if (usedBytes != 0L) {
            list.add(String.format(I18n.func_74838_a((String)("extracells.tooltip.storage." + (Object)((Object)this.definition) + ".content")), usedBytes));
        }
        if (partitioned) {
            list.add(I18n.func_74838_a((String)"gui.appliedenergistics2.Partitioned") + " - " + I18n.func_74838_a((String)"gui.appliedenergistics2.Precise"));
        }
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.RARE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs creativeTab, NonNullList listSubItems) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (StorageType type : this.definition.cells) {
            listSubItems.add((Object)new ItemStack((Item)this, 1, type.getMeta()));
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        StorageType type = this.definition.cells.fromMeta(itemStack.func_77952_i());
        return "extracells.item.storage." + type.getIdentifier();
    }

    public boolean isEditable(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return itemStack.func_77973_b() == this;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.func_70093_af()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        ICellRegistry cellRegistry = AEApi.instance().registries().cell();
        ICellInventoryHandler handler = cellRegistry.getCellInventory(itemStack, null, this.channel);
        if (!(handler instanceof IHandlerStorageBase)) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        IHandlerStorageBase cellHandler = (IHandlerStorageBase)handler;
        if (cellHandler.usedBytes() == 0 && player.field_71071_by.func_70441_a(ItemEnum.STORAGECASING.getDamagedStack(this.definition.ordinal()))) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)ItemEnum.STORAGECOMPONET.getDamagedStack(itemStack.func_77952_i() + this.definition.componentMetaStart));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, ModelManager manager) {
        for (StorageType type : this.definition.cells) {
            manager.registerItemModel(item, type.getMeta(), type.getModelName());
        }
    }
}

