/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.api.energy.EnergyType;
import sonar.core.helpers.SonarHelper;
import sonar.core.utils.CustomColour;
import sonar.flux.FluxNetworks;
import sonar.flux.api.AccessType;
import sonar.flux.api.FluxError;
import sonar.flux.api.IFluxItemGui;
import sonar.flux.api.network.FluxPlayer;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.PlayerAccess;
import sonar.flux.client.gui.EnumGuiTab;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.network.FluxNetworkCache;
import sonar.flux.network.FluxNetworkData;
import sonar.flux.network.ListenerHelper;
import sonar.flux.network.PacketError;
import sonar.flux.network.PacketGeneral;
import sonar.flux.network.PacketGeneralType;

public class PacketGeneralHelper {
    public static void sendPacketToServer(PacketGeneralType type, NBTTagCompound packetTag) {
        FluxNetworks.network.sendToServer((IMessage)new PacketGeneral(type, packetTag));
    }

    public static NBTTagCompound createNetworkEditPacket(int networkID, String networkName, CustomColour networkColour, AccessType accessType, boolean enableConvert, EnergyType defaultEnergy) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        tag.func_74778_a(FluxNetworkData.NETWORK_NAME, networkName);
        tag.func_74768_a(FluxNetworkData.COLOUR, networkColour.getRGB());
        tag.func_74768_a(FluxNetworkData.ACCESS, accessType.ordinal());
        tag.func_74757_a(FluxNetworkData.CONVERSION, enableConvert);
        EnergyType.writeToNBT((EnergyType)defaultEnergy, (NBTTagCompound)tag, (String)FluxNetworkData.ENERGY_TYPE);
        return tag;
    }

    public static IMessage doNetworkEditPacket(EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        String newName = packetTag.func_74779_i(FluxNetworkData.NETWORK_NAME);
        CustomColour colour = new CustomColour(packetTag.func_74762_e(FluxNetworkData.COLOUR));
        AccessType access = AccessType.values()[packetTag.func_74762_e(FluxNetworkData.ACCESS)];
        boolean enableConvert = packetTag.func_74767_n(FluxNetworkData.CONVERSION);
        EnergyType energyType = EnergyType.readFromNBT((NBTTagCompound)packetTag, (String)FluxNetworkData.ENERGY_TYPE);
        IFluxNetwork common = FluxNetworks.getServerCache().getNetwork(networkID);
        if (!common.isFakeNetwork()) {
            if (common.getPlayerAccess(player).canEdit()) {
                common.setSetting(NetworkSettings.NETWORK_NAME, newName);
                common.setSetting(NetworkSettings.NETWORK_ACCESS, access);
                common.setSetting(NetworkSettings.NETWORK_COLOUR, colour);
                common.setSetting(NetworkSettings.NETWORK_CONVERSION, enableConvert);
                common.setSetting(NetworkSettings.NETWORK_ENERGY_TYPE, energyType);
            } else {
                return new PacketError(FluxError.EDIT_NETWORK);
            }
        }
        return null;
    }

    public static NBTTagCompound createNetworkCreationPacket(String networkName, CustomColour networkColour, AccessType accessType, boolean enableConvert, EnergyType defaultEnergy) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a(FluxNetworkData.NETWORK_NAME, networkName);
        tag.func_74768_a(FluxNetworkData.COLOUR, networkColour.getRGB());
        tag.func_74768_a(FluxNetworkData.ACCESS, accessType.ordinal());
        tag.func_74757_a(FluxNetworkData.CONVERSION, enableConvert);
        EnergyType.writeToNBT((EnergyType)defaultEnergy, (NBTTagCompound)tag, (String)FluxNetworkData.ENERGY_TYPE);
        return tag;
    }

    public static IMessage doNetworkCreationPacket(EntityPlayer player, NBTTagCompound packetTag) {
        String newName = packetTag.func_74779_i(FluxNetworkData.NETWORK_NAME);
        CustomColour colour = new CustomColour(packetTag.func_74762_e(FluxNetworkData.COLOUR));
        AccessType access = AccessType.values()[packetTag.func_74762_e(FluxNetworkData.ACCESS)];
        boolean enableConvert = packetTag.func_74767_n(FluxNetworkData.CONVERSION);
        EnergyType energyType = EnergyType.readFromNBT((NBTTagCompound)packetTag, (String)FluxNetworkData.ENERGY_TYPE);
        if (FluxNetworks.getServerCache().hasSpaceForNetwork(player)) {
            FluxNetworks.getServerCache().createNetwork(player, newName, colour, access, enableConvert, energyType);
        }
        return null;
    }

    public static NBTTagCompound createNetworkDeletePacket(int networkID) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        return tag;
    }

    public static IMessage doNetworkDeletePacket(EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        IFluxNetwork toDelete = FluxNetworks.getServerCache().getNetwork(networkID);
        if (!toDelete.isFakeNetwork()) {
            if (toDelete.getPlayerAccess(player).canDelete()) {
                FluxNetworks.getServerCache().onPlayerRemoveNetwork(toDelete);
            } else {
                return new PacketError(FluxError.NOT_OWNER);
            }
        }
        return null;
    }

    public static NBTTagCompound createChangeNetworkOwner(int networkID, String name) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        tag.func_74778_a("owner", name);
        return tag;
    }

    public static IMessage doChangeNetworkOwner(EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        String owner = packetTag.func_74779_i("owner");
        IFluxNetwork toEdit = FluxNetworks.getServerCache().getNetwork(networkID);
        if (!toEdit.isFakeNetwork()) {
            if (toEdit.getPlayerAccess(player).canDelete()) {
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                PlayerProfileCache cache = server.func_152358_ax();
                GameProfile profile = cache.func_152655_a(owner);
                if (profile != null) {
                    FluxNetworkData.get().networks.get(toEdit.getSyncSetting(NetworkSettings.NETWORK_OWNER).getValue()).remove(toEdit);
                    ((List)toEdit.getSyncSetting(NetworkSettings.NETWORK_PLAYERS).getValue()).removeIf(p -> p.getAccess() == PlayerAccess.OWNER);
                    ((List)toEdit.getSyncSetting(NetworkSettings.NETWORK_PLAYERS).getValue()).add(FluxPlayer.createFluxPlayer(owner, PlayerAccess.OWNER));
                    toEdit.getSyncSetting(NetworkSettings.NETWORK_OWNER).setValue((Object)profile.getId());
                    toEdit.getSyncSetting(NetworkSettings.NETWORK_CACHED_NAME).setValue((Object)owner);
                    FluxNetworkData.get().networks.computeIfAbsent(profile.getId(), id -> FluxNetworkCache.instance().instanceNetworkList());
                    FluxNetworkData.get().networks.get(profile.getId()).add(toEdit);
                }
            } else {
                return new PacketError(FluxError.ACCESS_DENIED);
            }
        }
        return null;
    }

    public static NBTTagCompound createAddPlayerPacket(int networkID, String playerName, PlayerAccess playerAccess) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("networkID", networkID);
        tag.func_74778_a("playerName", playerName);
        tag.func_74768_a("playerAccess", playerAccess.ordinal());
        return tag;
    }

    public static IMessage doAddPlayerPacket(EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e("networkID");
        String playerName = packetTag.func_74779_i("playerName");
        PlayerAccess access = PlayerAccess.values()[packetTag.func_74762_e("playerAccess")];
        IFluxNetwork network = FluxNetworks.getServerCache().getNetwork(networkID);
        if (!network.isFakeNetwork()) {
            if (network.getPlayerAccess(player).canEdit()) {
                network.addPlayerAccess(playerName, access);
            } else {
                return new PacketError(FluxError.EDIT_NETWORK);
            }
        }
        return null;
    }

    public static NBTTagCompound createRemovePlayerPacket(int networkID, UUID playerRemoved, PlayerAccess playerAccess) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("networkID", networkID);
        tag.func_186854_a("playerRemoved", playerRemoved);
        tag.func_74768_a("playerAccess", playerAccess.ordinal());
        return tag;
    }

    public static IMessage doRemovePlayerPacket(EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e("networkID");
        UUID playerRemoved = packetTag.func_186857_a("playerRemoved");
        PlayerAccess access = PlayerAccess.values()[packetTag.func_74762_e("playerAccess")];
        IFluxNetwork network = FluxNetworks.getServerCache().getNetwork(networkID);
        if (!network.isFakeNetwork()) {
            if (network.getPlayerAccess(player).canEdit()) {
                network.removePlayerAccess(playerRemoved, access);
            } else {
                return new PacketError(FluxError.EDIT_NETWORK);
            }
        }
        return null;
    }

    public static NBTTagCompound createChangePlayerPacket(int networkID, UUID playerChanged, PlayerAccess playerAccess) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("networkID", networkID);
        tag.func_186854_a("playerChanged", playerChanged);
        tag.func_74768_a("playerAccess", playerAccess.ordinal());
        return tag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IMessage doChangePlayerPacket(EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e("networkID");
        UUID playerChanged = packetTag.func_186857_a("playerChanged");
        if (playerChanged == null) return null;
        if (FluxPlayer.getOnlineUUID(player).equals(playerChanged)) {
            return null;
        }
        PlayerAccess access = PlayerAccess.values()[packetTag.func_74762_e("playerAccess")];
        access = (PlayerAccess)SonarHelper.incrementEnum((Enum)access, (Enum[])PlayerAccess.values());
        while (access.canDelete()) {
            access = (PlayerAccess)SonarHelper.incrementEnum((Enum)access, (Enum[])PlayerAccess.values());
        }
        IFluxNetwork network = FluxNetworks.getServerCache().getNetwork(networkID);
        if (network.isFakeNetwork()) return null;
        if (!network.getPlayerAccess(player).canEdit()) return new PacketError(FluxError.EDIT_NETWORK);
        Optional<FluxPlayer> settings = network.getValidFluxPlayer(playerChanged);
        if (!settings.isPresent()) return new PacketError(FluxError.INVALID_USER);
        settings.get().setAccess(access);
        network.getSyncSetting(NetworkSettings.NETWORK_PLAYERS).setDirty(true);
        return null;
    }

    public static NBTTagCompound createResetConnectedBlocksPacket(int networkID) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        return tag;
    }

    public static IMessage doResetConnectedBlocksPacket(EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        IFluxNetwork network = FluxNetworks.getServerCache().getNetwork(networkID);
        if (!network.isFakeNetwork()) {
            network.debugConnectedBlocks();
        }
        return null;
    }

    public static NBTTagCompound createValidateConnectionsPacket(int networkID) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        return tag;
    }

    public static IMessage doValidateConnectionsPacket(EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        IFluxNetwork network = FluxNetworks.getServerCache().getNetwork(networkID);
        if (!network.isFakeNetwork()) {
            network.debugValidateFluxConnections();
        }
        return null;
    }

    public static NBTTagCompound createStateChangePacket(EnumGuiTab oldTab, @Nullable EnumGuiTab newTab) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("oldTab", oldTab.ordinal());
        if (newTab != null) {
            tag.func_74768_a("newTab", newTab.ordinal());
        }
        return tag;
    }

    public static IMessage doStateChangePacket(EntityPlayer player, NBTTagCompound packetTag) {
        ItemStack stack = player.func_184586_b(player.func_184600_cs());
        if (stack.func_77973_b() instanceof IFluxItemGui) {
            EnumGuiTab oldTab = EnumGuiTab.values()[packetTag.func_74762_e("oldTab")];
            ListenerHelper.onPlayerCloseItemTab(stack, player, oldTab);
            if (packetTag.func_74764_b("newTab")) {
                EnumGuiTab newTab = EnumGuiTab.values()[packetTag.func_74762_e("newTab")];
                ListenerHelper.onPlayerOpenItemTab(stack, player, newTab);
            }
        }
        return null;
    }

    public static NBTTagCompound createViewingNetworkPacket(int networkID) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(FluxNetworkData.NETWORK_ID, networkID);
        return tag;
    }

    public static IMessage doViewingNetworkPacket(EntityPlayer player, NBTTagCompound packetTag) {
        int networkID = packetTag.func_74762_e(FluxNetworkData.NETWORK_ID);
        IFluxNetwork network = FluxNetworks.getServerCache().getNetwork(networkID);
        if (network.isFakeNetwork() || network.getPlayerAccess(player).canView()) {
            // empty if block
        }
        return null;
    }
}

