/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.flux.api.AdditionType;
import sonar.flux.api.ClientFlux;
import sonar.flux.api.ConnectionSettings;
import sonar.flux.api.RemovalType;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.common.tileentity.TileFlux;
import sonar.flux.network.FluxNetworkCache;
import sonar.flux.network.PacketDisconnectedTiles;

public class PacketEditedTiles
implements IMessage {
    public List<ClientFlux> client_flux;

    public PacketEditedTiles() {
    }

    public PacketEditedTiles(List<ClientFlux> client_flux) {
        this.client_flux = client_flux;
    }

    public void fromBytes(ByteBuf buf) {
        this.client_flux = new ArrayList<ClientFlux>();
        PacketDisconnectedTiles.clientFluxFromBuf(buf, this.client_flux);
    }

    public void toBytes(ByteBuf buf) {
        PacketDisconnectedTiles.clientFluxToBuf(buf, this.client_flux);
    }

    public static class Handler
    implements IMessageHandler<PacketEditedTiles, IMessage> {
        public IMessage onMessage(PacketEditedTiles message, MessageContext ctx) {
            SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
                for (ClientFlux clientFlux : message.client_flux) {
                    TileFlux flux;
                    TileEntity tile;
                    if (!clientFlux.getCoords().isChunkLoaded() || !((tile = clientFlux.getCoords().getTileEntity()) instanceof TileFlux) || !(flux = (TileFlux)tile).canAccess(player).canEdit()) continue;
                    flux.priority.setValue((Object)clientFlux.priority);
                    flux.folder_id.setValue((Object)clientFlux.folder_id);
                    flux.limit.setValue((Object)clientFlux.limit);
                    flux.customName.setValue((Object)clientFlux.customName);
                    flux.disableLimit.setValue((Object)clientFlux.disableLimit);
                    flux.activation_type.setValue((Object)clientFlux.activation_type);
                    flux.priority_type.setValue((Object)clientFlux.priority_type);
                    if (flux.getNetworkID() != clientFlux.getNetworkID()) {
                        IFluxNetwork newNetwork = FluxNetworkCache.instance().getNetwork(clientFlux.network_id);
                        flux.getNetwork().queueConnectionRemoval(flux, RemovalType.REMOVE);
                        newNetwork.queueConnectionAddition(flux, AdditionType.ADD);
                    }
                    flux.markSettingChanged(ConnectionSettings.PRIORITY);
                    flux.markSettingChanged(ConnectionSettings.TRANSFER_LIMIT);
                    flux.markSettingChanged(ConnectionSettings.FOLDER_ID);
                    flux.markSettingChanged(ConnectionSettings.CUSTOM_NAME);
                }
            });
            return null;
        }
    }
}

