/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.flux.FluxNetworks;
import sonar.flux.api.ClientFlux;
import sonar.flux.api.NetworkFluxFolder;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.connection.NetworkSettings;

public class PacketConnectionsClientList
implements IMessage {
    public List<ClientFlux> connections;
    public List<NetworkFluxFolder> folders;
    public int networkID;

    public PacketConnectionsClientList() {
    }

    public PacketConnectionsClientList(IFluxNetwork network) {
        this.connections = network.getSetting(NetworkSettings.CLIENT_CONNECTIONS);
        this.folders = network.getSetting(NetworkSettings.NETWORK_FOLDERS);
        this.networkID = network.getSetting(NetworkSettings.NETWORK_ID);
    }

    public void fromBytes(ByteBuf buf) {
        this.networkID = buf.readInt();
        NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)buf);
        NBTTagList flux_list = compound.func_150295_c("flux", 10);
        this.connections = new ArrayList<ClientFlux>();
        for (int i = 0; i < flux_list.func_74745_c(); ++i) {
            NBTTagCompound c = flux_list.func_150305_b(i);
            this.connections.add(new ClientFlux(c));
        }
        NBTTagList folders_list = compound.func_150295_c("network_folders", 10);
        this.folders = new ArrayList<NetworkFluxFolder>();
        for (int i = 0; i < folders_list.func_74745_c(); ++i) {
            NBTTagCompound c = folders_list.func_150305_b(i);
            this.folders.add(new NetworkFluxFolder(c));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.networkID);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList flux_list = new NBTTagList();
        this.connections.forEach(flux -> flux_list.func_74742_a((NBTBase)flux.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE)));
        tag.func_74782_a("flux", (NBTBase)flux_list);
        NBTTagList folders_list = new NBTTagList();
        this.folders.forEach(flux -> folders_list.func_74742_a((NBTBase)flux.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE)));
        tag.func_74782_a("network_folders", (NBTBase)folders_list);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    implements IMessageHandler<PacketConnectionsClientList, IMessage> {
        public IMessage onMessage(PacketConnectionsClientList message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                    IFluxNetwork common = FluxNetworks.getClientCache().getNetwork(message.networkID);
                    if (!common.isFakeNetwork()) {
                        common.setSettingInternal(NetworkSettings.CLIENT_CONNECTIONS, message.connections);
                        common.setSettingInternal(NetworkSettings.NETWORK_FOLDERS, message.folders);
                    }
                });
            }
            return null;
        }
    }
}

