/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.api.energy.EnergyType;
import sonar.core.helpers.FunctionHelper;
import sonar.core.helpers.ListHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ListenableList;
import sonar.core.listener.ListenerList;
import sonar.core.listener.PlayerListener;
import sonar.core.utils.CustomColour;
import sonar.core.utils.SimpleObservableList;
import sonar.flux.FluxConfig;
import sonar.flux.FluxNetworks;
import sonar.flux.api.AccessType;
import sonar.flux.api.network.FluxPlayer;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.IFluxNetworkCache;
import sonar.flux.api.network.PlayerAccess;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.connection.FluxHelper;
import sonar.flux.connection.FluxListener;
import sonar.flux.connection.FluxNetworkInvalid;
import sonar.flux.connection.FluxNetworkServer;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.network.FluxNetworkData;
import sonar.flux.network.PacketNetworkDeleted;
import sonar.flux.network.PacketNetworkUpdate;

public class FluxNetworkCache
implements IFluxNetworkCache,
ISonarListenable<PlayerListener>,
SimpleObservableList.IListWatcher<IFluxNetwork> {
    private ListenableList<PlayerListener> listeners = new ListenableList((ISonarListenable)this, FluxListener.values().length);
    public Map<Integer, ListenerList<PlayerListener>> stack_listeners = new HashMap<Integer, ListenerList<PlayerListener>>();
    public Map<UUID, List<IFlux>> disconnected_tiles = new HashMap<UUID, List<IFlux>>();
    public boolean disconnected_tiles_changed = false;

    public static FluxNetworkCache instance() {
        return FluxNetworks.getServerCache();
    }

    public void clearNetworks() {
        FluxNetworkData.clear();
        this.stack_listeners.clear();
        this.disconnected_tiles.clear();
        this.disconnected_tiles_changed = false;
    }

    private int createNewUniqueID() {
        return FluxNetworkData.get().uniqueID++;
    }

    public Map<UUID, List<IFluxNetwork>> getNetworkMap() {
        return FluxNetworkData.get().networks;
    }

    public IFluxNetwork getNetwork(Predicate<IFluxNetwork> found) {
        for (Map.Entry<UUID, List<IFluxNetwork>> entry : FluxNetworkData.get().networks.entrySet()) {
            Optional<IFluxNetwork> network = entry.getValue().stream().filter(found).findFirst();
            if (!network.isPresent()) continue;
            return network.get();
        }
        return FluxNetworkInvalid.INVALID;
    }

    public List<IFluxNetwork> getNetworks(Predicate<IFluxNetwork> found) {
        ArrayList<IFluxNetwork> list = new ArrayList<IFluxNetwork>();
        FluxNetworkData.get().networks.values().forEach(NETWORKS -> NETWORKS.stream().filter(found).forEach(list::add));
        return list;
    }

    public void forEachNetwork(Consumer<IFluxNetwork> action) {
        FluxNetworkData.get().networks.values().forEach(l -> l.forEach(action));
    }

    @Override
    public List<IFluxNetwork> getAllowedNetworks(EntityPlayer player, boolean admin) {
        return this.getNetworks(network -> admin || network.getPlayerAccess(player).canConnect());
    }

    @Override
    public IFluxNetwork getNetwork(int iD) {
        return this.getNetwork(n -> !n.isFakeNetwork() && iD == n.getSetting(NetworkSettings.NETWORK_ID));
    }

    @Override
    public List<IFluxNetwork> getAllNetworks() {
        ArrayList<IFluxNetwork> available = new ArrayList<IFluxNetwork>();
        FluxNetworkData.get().networks.values().forEach(available::addAll);
        return available;
    }

    public List<IFluxNetwork> instanceNetworkList() {
        SimpleObservableList list = new SimpleObservableList();
        list.addWatcher((SimpleObservableList.IListWatcher)this);
        return list;
    }

    public boolean hasSpaceForNetwork(EntityPlayer player) {
        if (FluxConfig.maximum_per_player == -1) {
            return true;
        }
        UUID ownerUUID = FluxPlayer.getOnlineUUID(player);
        List created = FluxNetworkData.get().networks.getOrDefault(ownerUUID, new ArrayList());
        return created.size() < FluxConfig.maximum_per_player;
    }

    public IFluxNetwork createNetwork(EntityPlayer player, String name, CustomColour colour, AccessType access, boolean disableConvert, EnergyType defaultEnergy) {
        UUID playerUUID = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
        FluxNetworkData.get().networks.computeIfAbsent(playerUUID, UUID2 -> this.instanceNetworkList());
        int iD = this.createNewUniqueID();
        FluxPlayer owner = FluxPlayer.createFluxPlayer(player, PlayerAccess.OWNER);
        FluxNetworkServer network = new FluxNetworkServer(iD, owner.getOnlineUUID(), owner.getCachedName(), name, colour, access, disableConvert, defaultEnergy);
        network.getSetting(NetworkSettings.NETWORK_PLAYERS).add(owner);
        FluxNetworkData.get().addNetwork(network);
        FluxNetworks.proxy.logNewNetwork(network);
        return network;
    }

    public void onPlayerRemoveNetwork(IFluxNetwork remove) {
        FluxNetworkData.get().removeNetwork(remove);
        FluxNetworks.proxy.logRemoveNetwork(remove);
    }

    public void onSettingsChanged(IFluxNetwork network) {
        List players = this.listeners.getListeners(new Enum[]{FluxListener.SYNC_NETWORK_LIST});
        PacketNetworkUpdate packet = new PacketNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTHelper.SyncType.SAVE, false);
        players.forEach(listener -> {
            if (network.getPlayerAccess((EntityPlayer)listener.player).canConnect()) {
                FluxNetworks.network.sendTo((IMessage)packet, listener.player);
            }
        });
    }

    public void onElementAdded(@Nullable IFluxNetwork added) {
        List players = this.listeners.getListeners(new Enum[]{FluxListener.SYNC_NETWORK_LIST});
        PacketNetworkUpdate packet = new PacketNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{added}), NBTHelper.SyncType.SAVE, false);
        players.forEach(listener -> {
            if (added.getPlayerAccess((EntityPlayer)listener.player).canConnect()) {
                FluxNetworks.network.sendTo((IMessage)packet, listener.player);
            }
        });
    }

    public void onElementRemoved(@Nullable IFluxNetwork remove) {
        List players = this.listeners.getListeners(new Enum[]{FluxListener.SYNC_NETWORK_LIST});
        PacketNetworkDeleted packet = new PacketNetworkDeleted(remove);
        players.forEach(listener -> FluxNetworks.network.sendTo((IMessage)packet, listener.player));
        this.updateNetworkListeners();
        this.updateAdminListeners();
    }

    public void onListChanged() {
        this.updateNetworkListeners();
        this.updateAdminListeners();
    }

    public void onStartServerTick() {
    }

    public void onEndServerTick() {
        if (this.disconnected_tiles_changed) {
            this.disconnected_tiles_changed = false;
        }
    }

    public ListenableList<PlayerListener> getListenerList() {
        return this.listeners;
    }

    public void updateNetworkListeners() {
        List players = this.listeners.getListeners(new Enum[]{FluxListener.SYNC_NETWORK_LIST});
        this.stack_listeners.values().forEach(list -> ListHelper.addWithCheck((Collection)players, (Collection)list.getListeners(new Enum[]{FluxListener.SYNC_NETWORK_LIST})));
        players.forEach(listener -> {
            List<IFluxNetwork> toSend = FluxNetworkCache.instance().getAllowedNetworks((EntityPlayer)listener.player, FluxHelper.isPlayerAdmin((EntityPlayer)listener.player));
            FluxNetworks.network.sendTo((IMessage)new PacketNetworkUpdate(toSend, NBTHelper.SyncType.SAVE, true), listener.player);
        });
    }

    public void updateAdminListeners() {
        ArrayList players = new ArrayList();
        this.stack_listeners.values().forEach(list -> ListHelper.addWithCheck((Collection)players, (Collection)list.getListeners(new Enum[]{FluxListener.ADMIN})));
        players.forEach(listener -> {
            List<IFluxNetwork> toSend = FluxNetworkCache.instance().getAllowedNetworks((EntityPlayer)listener.player, true);
            FluxNetworks.network.sendTo((IMessage)new PacketNetworkUpdate(toSend, NBTHelper.SyncType.SAVE, true), listener.player);
        });
    }

    public void onTileConnected(IFlux flux) {
        if (this.disconnected_tiles.get(flux.getConnectionOwner()) != null) {
            FluxNetworkCache.instance().disconnected_tiles.get(flux.getConnectionOwner()).remove(flux);
            FluxNetworkCache.instance().onDisconnectedTilesChanged();
        }
    }

    public void onTileDisconnected(IFlux flux) {
        FluxNetworkCache.instance().disconnected_tiles.computeIfAbsent(flux.getConnectionOwner(), FunctionHelper.ARRAY);
        if (!FluxNetworkCache.instance().disconnected_tiles.get(flux.getConnectionOwner()).contains(flux)) {
            FluxNetworkCache.instance().disconnected_tiles.get(flux.getConnectionOwner()).add(flux);
            FluxNetworkCache.instance().onDisconnectedTilesChanged();
        }
    }

    public void onTileRemoved(IFlux flux) {
        if (this.disconnected_tiles.get(flux.getConnectionOwner()) != null) {
            FluxNetworkCache.instance().disconnected_tiles.get(flux.getConnectionOwner()).remove(flux);
            FluxNetworkCache.instance().onDisconnectedTilesChanged();
        }
    }

    public void onDisconnectedTilesChanged() {
        this.disconnected_tiles_changed = true;
    }

    public ListenerList<PlayerListener> getOrCreateStackListeners(ItemStack stack) {
        int id = this.getOrCreateUniqueID(stack);
        return this.stack_listeners.computeIfAbsent(id, I -> new ListenerList(FluxListener.values().length));
    }

    public int getOrCreateUniqueID(ItemStack stack) {
        NBTTagCompound tag = stack.func_190925_c("uuid");
        if (tag.func_74764_b("id")) {
            return tag.func_74762_e("id");
        }
        int newID = FluxNetworkData.get().stack_unique_id++;
        tag.func_74768_a("id", newID);
        return newID;
    }

    public boolean isValid() {
        return true;
    }
}

