/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import sonar.core.network.SonarClient;
import sonar.core.translate.ILocalisationHandler;
import sonar.core.translate.Localisation;
import sonar.flux.FluxNetworks;
import sonar.flux.FluxTranslate;
import sonar.flux.api.ClientFlux;
import sonar.flux.api.FluxError;
import sonar.flux.client.FluxColourHandler;
import sonar.flux.client.FluxStorageModel;
import sonar.flux.client.RenderFluxStorageItem;
import sonar.flux.client.RenderFluxStorageTile;
import sonar.flux.common.tileentity.TileFlux;
import sonar.flux.common.tileentity.TileStorage;
import sonar.flux.network.ClientNetworkCache;
import sonar.flux.network.FluxCommon;

public class FluxClient
extends FluxCommon
implements ILocalisationHandler {
    private FluxError error;
    private TileFlux flux;
    private ItemStack flux_stack;
    private List<ClientFlux> tiles;

    @Override
    public void registerRenderThings() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileStorage.class, (TileEntitySpecialRenderer)new RenderFluxStorageTile());
        Item.func_150898_a((Block)FluxNetworks.fluxStorage).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)RenderFluxStorageItem.INSTANCE);
        Item.func_150898_a((Block)FluxNetworks.largeFluxStorage).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)RenderFluxStorageItem.INSTANCE);
        Item.func_150898_a((Block)FluxNetworks.massiveFluxStorage).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)RenderFluxStorageItem.INSTANCE);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)FluxStorageModel.INSTANCE);
    }

    @SubscribeEvent
    public void initBlockColours(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a((IBlockColor)FluxColourHandler.INSTANCE, new Block[]{FluxNetworks.fluxPlug, FluxNetworks.fluxPoint, FluxNetworks.fluxController, FluxNetworks.fluxStorage, FluxNetworks.largeFluxStorage, FluxNetworks.massiveFluxStorage});
    }

    @SubscribeEvent
    public void initItemColours(ColorHandlerEvent.Item event) {
        event.getItemColors().func_186731_a((IItemColor)FluxColourHandler.INSTANCE, new Block[]{FluxNetworks.fluxPlug, FluxNetworks.fluxPoint, FluxNetworks.fluxController, FluxNetworks.fluxStorage, FluxNetworks.largeFluxStorage, FluxNetworks.massiveFluxStorage});
        event.getItemColors().func_186730_a(FluxColourHandler::itemViewerMultiplier, new Item[]{FluxNetworks.fluxConfigurator});
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        FluxColourHandler.sendRequests();
    }

    @Override
    public void shutdown(FMLServerStoppedEvent event) {
        super.shutdown(event);
        FluxColourHandler.reset();
        this.clientCache.clearNetworks();
    }

    @Override
    public void receiveColourCache(Map<Integer, Tuple<Integer, String>> cache) {
        super.receiveColourCache(cache);
        FluxColourHandler.receiveCache(cache);
    }

    @Override
    public void clearNetwork(int networkID) {
        super.clearNetwork(networkID);
        FluxColourHandler.colourCache.put(networkID, FluxColourHandler.NO_NETWORK_COLOUR);
        FluxColourHandler.nameCache.put(networkID, "NONE");
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        this.clientCache = new ClientNetworkCache();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        SonarClient.translator.add((ILocalisationHandler)this);
        if (Minecraft.func_71410_x().func_110442_L() instanceof IReloadableResourceManager) {
            IReloadableResourceManager iReloadableResourceManager = (IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        }
    }

    public List<Localisation> getLocalisations(List<Localisation> current) {
        current.addAll(FluxTranslate.locals);
        return current;
    }

    @Override
    public void setFluxError(FluxError error) {
        this.error = error;
    }

    @Override
    @Nullable
    public FluxError getFluxError() {
        return this.error;
    }

    @Override
    public void setFluxTile(TileFlux flux) {
        this.flux = flux;
    }

    @Override
    @Nullable
    public TileFlux getFluxTile() {
        return this.flux;
    }

    @Override
    public void setFluxStack(ItemStack flux_stack) {
        this.flux_stack = flux_stack;
    }

    @Override
    @Nullable
    public ItemStack getFluxStack() {
        return this.flux_stack;
    }

    public void setEditingFluxTile(List<ClientFlux> tiles) {
        this.tiles = tiles;
    }

    public List<ClientFlux> getEditingFluxTile() {
        return this.tiles;
    }
}

