/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection.transfer.handlers;

import sonar.core.api.energy.EnergyType;
import sonar.flux.FluxNetworks;
import sonar.flux.api.energy.internal.ITransferHandler;

public abstract class BaseTransferHandler
implements ITransferHandler {
    public long added;
    public long removed;
    public long buffer;
    public long buffer_transfer;
    public long current_addition;
    public long current_removal;
    public long simulated_this_tick;
    public long attempted_this_tick;
    private long buffer_size;

    @Override
    public void onStartServerTick() {
        this.simulated_this_tick = 0L;
        this.attempted_this_tick = 0L;
        this.added = 0L;
        this.removed = 0L;
    }

    @Override
    public void onEndWorldTick() {
        this.buffer_size = Math.max(this.buffer_size, Math.max(this.simulated_this_tick, this.attempted_this_tick));
        this.buffer_transfer = 0L;
    }

    public long addToBuffer(long add, EnergyType energyType, boolean simulate) {
        long canAdd = this.getValidAddition_FE(add, energyType);
        if (canAdd > 0L) {
            if (!simulate) {
                this.buffer += canAdd;
                this.added += canAdd;
            }
            return this.convert(canAdd, EnergyType.FE, energyType);
        }
        return 0L;
    }

    public abstract long getAddRate();

    public abstract long getRemoveRate();

    public abstract long getBufferLimiter();

    @Override
    public final long getAdded() {
        return this.added;
    }

    @Override
    public final long getRemoved() {
        return this.removed;
    }

    @Override
    public final long getBuffer() {
        return this.buffer;
    }

    private long getBufferSize() {
        return this.buffer_size;
    }

    private void checkBufferSize(long toAdd_FE) {
        this.buffer_size = Math.min(Math.max(this.buffer_size, this.getAddRate()), this.getBufferLimiter());
    }

    private long getMaxAddition() {
        long valid = Math.min(this.getAddRate() - this.getAdded(), this.getBufferSize() - this.getBuffer());
        return valid > 0L ? valid : 0L;
    }

    private long getMaxRemoval() {
        return this.getRemoveRate() - this.getRemoved();
    }

    private long getValidAddition(long toAdd_FE) {
        this.checkBufferSize(toAdd_FE);
        return Math.min(this.getMaxAddition(), toAdd_FE);
    }

    private long getValidRemoval(long toRemove_FE) {
        return Math.min(this.getMaxRemoval(), toRemove_FE);
    }

    public long getValidAddition_FE(long maxReceive, EnergyType type) {
        long maxReceive_FE = this.toFE(maxReceive, type);
        return this.getValidAddition(maxReceive_FE);
    }

    public long getValidRemoval_FE(long maxRemoval, EnergyType type) {
        long maxReceive_FE = this.toFE(maxRemoval, type);
        return this.getValidRemoval(maxReceive_FE);
    }

    public long getValidAddition(long maxReceive, EnergyType type) {
        return this.convert(this.getValidAddition_FE(maxReceive, type), EnergyType.FE, type);
    }

    public long getValidRemoval(long maxRemoval, EnergyType type) {
        return this.convert(this.getValidRemoval_FE(maxRemoval, type), EnergyType.FE, type);
    }

    public final long toFE(long val, EnergyType from) {
        return FluxNetworks.TRANSFER_HANDLER.convert(val, from, EnergyType.FE);
    }

    public final long convert(long val, EnergyType from, EnergyType to) {
        return FluxNetworks.TRANSFER_HANDLER.convert(val, from, to);
    }
}

