/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection.transfer;

import baubles.api.cap.BaublesCapabilities;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.IItemHandler;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.energy.IItemEnergyHandler;
import sonar.core.api.utils.ActionType;
import sonar.core.handlers.inventories.ItemStackHelper;
import sonar.flux.FluxNetworks;
import sonar.flux.api.energy.internal.IEnergyTransfer;
import sonar.flux.api.network.FluxPlayer;
import sonar.flux.api.network.PlayerAccess;
import sonar.flux.common.tileentity.TileController;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.connection.transfer.BaseFluxTransfer;

public class ControllerTransfer
extends BaseFluxTransfer
implements IEnergyTransfer {
    public final TileController controller;
    public static final Predicate<ItemStack> NOT_EMPTY = STACK -> !STACK.func_190926_b();

    public ControllerTransfer(TileController tile) {
        super(tile.getNetwork().getSetting(NetworkSettings.NETWORK_ENERGY_TYPE));
        this.controller = tile;
    }

    @Override
    public long addToNetwork(long maxTransferRF, ActionType actionType) {
        return 0L;
    }

    @Override
    public long removeFromNetwork(long maxTransferRF, ActionType actionType) {
        if (!((Boolean)this.controller.wireless_charging.getValue()).booleanValue()) {
            return 0L;
        }
        long received = 0L;
        block0: for (EntityPlayer player : this.getChargeablePlayers()) {
            Map<Iterable<ItemStack>, Predicate<ItemStack>> inventories = this.getSubInventories(new HashMap<Iterable<ItemStack>, Predicate<ItemStack>>(), player);
            for (Map.Entry<Iterable<ItemStack>, Predicate<ItemStack>> inventory : inventories.entrySet()) {
                for (ItemStack stack : inventory.getKey()) {
                    IItemEnergyHandler handler;
                    if (!inventory.getValue().test(stack) || (handler = FluxNetworks.TRANSFER_HANDLER.getItemHandler(stack)) == null) continue;
                    long receive = handler.addEnergy(maxTransferRF - received, stack, actionType);
                    if (receive > 0L) {
                        received += receive;
                        if (!actionType.shouldSimulate()) {
                            this.removedFromNetwork(receive, this.getEnergyType());
                        }
                    }
                    if (maxTransferRF - received > 0L) continue;
                    break block0;
                }
            }
        }
        return received;
    }

    public List<EntityPlayer> getChargeablePlayers() {
        Entity entity;
        List<FluxPlayer> playerNames = this.controller.getNetwork().getSetting(NetworkSettings.NETWORK_PLAYERS);
        if (playerNames.isEmpty() && (entity = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(this.controller.getNetwork().getSetting(NetworkSettings.NETWORK_OWNER))) instanceof EntityPlayer) {
            this.controller.getNetwork().getSetting(NetworkSettings.NETWORK_PLAYERS).add(FluxPlayer.createFluxPlayer((EntityPlayer)entity, PlayerAccess.OWNER));
        }
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        for (FluxPlayer player : playerNames) {
            Entity entity2 = FMLCommonHandler.instance().getMinecraftServerInstance().func_175576_a(player.getOnlineUUID());
            if (!(entity2 instanceof EntityPlayer)) continue;
            players.add((EntityPlayer)entity2);
        }
        return players;
    }

    public Map<Iterable<ItemStack>, Predicate<ItemStack>> getSubInventories(Map<Iterable<ItemStack>, Predicate<ItemStack>> subInventories, EntityPlayer player) {
        InventoryPlayer inv = player.field_71071_by;
        ItemStack heldItem = inv.func_70448_g();
        if (((Boolean)this.controller.right_hand.getValue()).booleanValue() && !heldItem.func_190926_b()) {
            subInventories.put(Lists.newArrayList((Object[])new ItemStack[]{heldItem}), NOT_EMPTY);
        }
        if (((Boolean)this.controller.left_hand.getValue()).booleanValue()) {
            subInventories.put((Iterable<ItemStack>)inv.field_184439_c, NOT_EMPTY);
        }
        if (((Boolean)this.controller.armour_slot.getValue()).booleanValue()) {
            subInventories.put((Iterable<ItemStack>)inv.field_70460_b, NOT_EMPTY);
        }
        if (((Boolean)this.controller.baubles_slot.getValue()).booleanValue() && Loader.isModLoaded((String)"baubles") && player.hasCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null)) {
            IItemHandler handler = (IItemHandler)player.getCapability(BaublesCapabilities.CAPABILITY_BAUBLES, null);
            subInventories.put(() -> new ItemHandlerIterator(handler), NOT_EMPTY);
        }
        if (((Boolean)this.controller.hot_bar.getValue()).booleanValue()) {
            subInventories.put(inv.field_70462_a.subList(0, 9), stack -> !stack.func_190926_b() && (heldItem.func_190926_b() || heldItem != stack));
        }
        if (((Boolean)this.controller.main_inventory.getValue()).booleanValue()) {
            subInventories.put(inv.field_70462_a.subList(9, inv.field_70462_a.size()), NOT_EMPTY);
        }
        return subInventories;
    }

    @Override
    public ItemStack getDisplayStack() {
        return ItemStackHelper.getBlockItem((World)this.controller.func_145831_w(), (BlockPos)this.controller.func_174877_v());
    }

    @Override
    public EnergyType getEnergyType() {
        return this.controller.getNetwork().getSetting(NetworkSettings.NETWORK_ENERGY_TYPE);
    }

    private static class ItemHandlerIterator
    implements Iterator<ItemStack> {
        private final IItemHandler handler;
        private int count = 0;

        ItemHandlerIterator(IItemHandler handler) {
            this.handler = handler;
        }

        @Override
        public boolean hasNext() {
            return this.count < this.handler.getSlots();
        }

        @Override
        public ItemStack next() {
            ItemStack next = this.handler.getStackInSlot(this.count);
            ++this.count;
            return next;
        }
    }
}

