/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.energy.EnergyType;
import sonar.core.helpers.NBTHelper;
import sonar.core.sync.ISonarValue;
import sonar.core.sync.ISyncValue;
import sonar.core.sync.IValueWatcher;
import sonar.core.sync.SyncRegistry;
import sonar.core.sync.ValueWatcher;
import sonar.core.utils.CustomColour;
import sonar.flux.api.AccessType;
import sonar.flux.api.ClientFlux;
import sonar.flux.api.NetworkFluxFolder;
import sonar.flux.api.network.FluxPlayer;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.PlayerAccess;
import sonar.flux.connection.FluxHelper;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.connection.transfer.stats.NetworkStatistics;
import sonar.flux.network.FluxNetworkData;

public abstract class FluxNetworkBase
extends ValueWatcher
implements IFluxNetwork {
    public ISyncValue<Integer> network_id = SyncRegistry.createValue(Integer.class, (IValueWatcher)this, (String)FluxNetworkData.NETWORK_ID);
    public ISyncValue<String> network_name = SyncRegistry.createValue(String.class, (IValueWatcher)this, (String)FluxNetworkData.NETWORK_NAME);
    public ISyncValue<AccessType> network_access = SyncRegistry.createValue(AccessType.class, (IValueWatcher)this, (String)FluxNetworkData.ACCESS);
    public ISyncValue<CustomColour> network_colour = SyncRegistry.createValue(CustomColour.class, (IValueWatcher)this, (String)FluxNetworkData.COLOUR);
    public ISyncValue<UUID> network_owner = SyncRegistry.createValue(UUID.class, (IValueWatcher)this, (String)FluxNetworkData.OWNER_UUID);
    public ISyncValue<Boolean> network_conversion = SyncRegistry.createValue(Boolean.class, (IValueWatcher)this, (String)FluxNetworkData.CONVERSION);
    public ISyncValue<EnergyType> network_energy_type = SyncRegistry.createValue(EnergyType.class, (IValueWatcher)this, (String)FluxNetworkData.ENERGY_TYPE);
    public ISyncValue<String> cached_player_name = SyncRegistry.createValue(String.class, (IValueWatcher)this, (String)FluxNetworkData.CACHE_PLAYER);
    public ISonarValue<List<FluxPlayer>> network_players = SyncRegistry.createSonarControlledList(FluxPlayer.class, (IValueWatcher)this, new ArrayList());
    public ISonarValue<NetworkStatistics> network_stats = SyncRegistry.createSonarValue(NetworkStatistics.class, (IValueWatcher)this, (Object)new NetworkStatistics(this));
    public ISonarValue<List<ClientFlux>> client_connections = SyncRegistry.createSonarValueList(ClientFlux.class, (IValueWatcher)this, new ArrayList());
    public ISonarValue<List<ClientFlux>> unloaded_connections = SyncRegistry.createSonarValueList(ClientFlux.class, (IValueWatcher)this, new ArrayList());
    public ISonarValue<List<NetworkFluxFolder>> network_folders = SyncRegistry.createSonarValueList(NetworkFluxFolder.class, (IValueWatcher)this, new ArrayList());

    public FluxNetworkBase() {
    }

    public FluxNetworkBase(int ID, UUID owner, String cached_player, String name, CustomColour colour, AccessType type, boolean conversion, EnergyType energy_type) {
        this.network_id.setValueInternal((Object)ID);
        this.network_name.setValueInternal((Object)name);
        this.network_access.setValueInternal((Object)type);
        this.network_colour.setValueInternal((Object)colour);
        this.network_owner.setValueInternal((Object)owner);
        this.network_conversion.setValueInternal((Object)conversion);
        this.network_energy_type.setValueInternal((Object)energy_type);
        this.cached_player_name.setValueInternal((Object)cached_player);
    }

    @Override
    public <T> T getSetting(NetworkSettings<T> setting) {
        return (T)this.getSyncSetting(setting).getValue();
    }

    @Override
    public <T> ISonarValue<T> getSyncSetting(NetworkSettings<T> setting) {
        return setting.getSyncValue(this);
    }

    @Override
    public PlayerAccess getPlayerAccess(EntityPlayer player) {
        if (FluxHelper.isPlayerAdmin(player)) {
            return PlayerAccess.CREATIVE;
        }
        if (this.isOwner(player)) {
            return PlayerAccess.OWNER;
        }
        if (this.network_access.getValue() == AccessType.PUBLIC) {
            return PlayerAccess.SHARED_OWNER;
        }
        if (this.network_access.getValue() == AccessType.RESTRICTED) {
            for (FluxPlayer fluxPlayer : (List)this.network_players.getValue()) {
                if (!fluxPlayer.matches(player)) continue;
                return fluxPlayer.getAccess();
            }
        }
        return PlayerAccess.BLOCKED;
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        UUID onlineID = FluxPlayer.getOnlineUUID(player);
        if (onlineID.equals(this.network_owner.getValue())) {
            return true;
        }
        UUID offlineID = FluxPlayer.getOfflineUUID(player);
        return offlineID.equals(this.network_owner.getValue());
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.forEachSyncable(sv -> {
            if (sv.canLoadFrom(nbt)) {
                sv.load(nbt);
            }
        });
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.PACKET, NBTHelper.SyncType.SPECIAL})) {
            FluxNetworkData.readPlayers(this, nbt);
            FluxNetworkData.readConnections(this.client_connections, "client_c", this, nbt);
            FluxNetworkData.readFolders(this, nbt);
        }
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.forEachSyncable(sv -> {
            if (type.mustSync() || sv.isDirty()) {
                sv.save(nbt);
            }
        });
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.PACKET, NBTHelper.SyncType.SPECIAL})) {
            if (this.network_players.isDirty() || type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.PACKET})) {
                FluxNetworkData.writePlayers(this, nbt);
            }
            if (this.client_connections.isDirty() || type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.PACKET})) {
                FluxNetworkData.writeConnections(this.client_connections, "client_c", this, nbt);
            }
            if (this.network_folders.isDirty() || type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.PACKET})) {
                FluxNetworkData.writeFolders(this, nbt);
            }
        }
        return nbt;
    }
}

