/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.SonarCore;
import sonar.core.common.tile.TileEntitySyncable;
import sonar.core.helpers.ListHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.PacketTileSync;
import sonar.flux.FluxNetworks;
import sonar.flux.api.ClientFlux;
import sonar.flux.api.network.FluxPlayer;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.connection.FluxNetworkServer;
import sonar.flux.network.FluxNetworkCache;
import sonar.flux.network.PacketDisconnectedTiles;
import sonar.flux.network.PacketNetworkStatistics;
import sonar.flux.network.PacketNetworkUpdate;

public enum FluxListener {
    ADMIN(FluxListener::doAdminOpen, FluxListener::doAdminClose, network -> {}),
    SYNC_INDEX(FluxListener::doIndexOpen, (network, player) -> {}, FluxListener::doIndexSync),
    SYNC_NETWORK_LIST(FluxListener::doNetworkListOpen, FluxListener::doNetworkListClose, FluxListener::doNetworkListSync),
    SYNC_NETWORK_CONNECTIONS(FluxListener::doConnectionsListOpen, (network, player) -> {}, FluxListener::doConnectionsListSync),
    SYNC_NETWORK_STATS(FluxListener::doNetworkStatsOpen, (network, player) -> {}, FluxListener::doNetworkStatsSync),
    SYNC_PLAYERS(FluxListener::doPlayerListOpen, (network, player) -> {}, FluxListener::doPlayerListSync),
    SYNC_DISCONNECTED_CONNECTIONS(FluxListener::doDisconnectedTilesOpen, (network, player) -> {}, FluxListener::doDisconnectedTilesSync);

    public IListenerAction openPacket;
    public IListenerAction closePacket;
    public IListenerSync syncPacket;

    private FluxListener(IListenerAction openPacket, IListenerAction closePacket, IListenerSync syncPacket) {
        this.openPacket = openPacket;
        this.closePacket = closePacket;
        this.syncPacket = syncPacket;
    }

    public void doOpenPacket(IFluxNetwork network, EntityPlayerMP player) {
        this.openPacket.sendPacket(network, player);
    }

    public void doClosePacket(IFluxNetwork network, EntityPlayerMP player) {
        this.closePacket.sendPacket(network, player);
    }

    public void sync(FluxNetworkServer network) {
        this.syncPacket.sync(network);
    }

    public static void doAdminOpen(IFluxNetwork network, EntityPlayerMP player) {
        FluxNetworkCache.instance().updateAdminListeners();
    }

    public static void doAdminClose(IFluxNetwork network, EntityPlayerMP player) {
    }

    public static void doIndexOpen(IFluxNetwork network, EntityPlayerMP player) {
    }

    public static void doIndexSync(FluxNetworkServer network) {
        network.flux_tile_listeners.forEach(flux -> flux.getListenerList().getListeners(new Enum[]{SYNC_INDEX}).forEach(p -> {
            TileEntitySyncable tile;
            NBTTagCompound tag;
            if (flux instanceof TileEntitySyncable && !(tag = (tile = (TileEntitySyncable)flux).writeData(new NBTTagCompound(), NBTHelper.SyncType.SPECIAL)).func_82582_d()) {
                tile.getSyncListeners().forEach(l -> SonarCore.network.sendTo((IMessage)new PacketTileSync(tile.func_174877_v(), tag, NBTHelper.SyncType.SPECIAL), l.player));
            }
        }));
    }

    public static void doNetworkListOpen(IFluxNetwork network, EntityPlayerMP player) {
        List<IFluxNetwork> toSend = FluxNetworkCache.instance().getAllowedNetworks((EntityPlayer)player, false);
        if (!network.isFakeNetwork()) {
            ListHelper.addWithCheck(toSend, (Object)network);
        }
        FluxNetworks.network.sendTo((IMessage)new PacketNetworkUpdate(toSend, NBTHelper.SyncType.SAVE, true), player);
    }

    public static void doNetworkListClose(IFluxNetwork network, EntityPlayerMP player) {
    }

    public static void doNetworkListSync(IFluxNetwork network) {
    }

    public static void doConnectionsListOpen(IFluxNetwork network, EntityPlayerMP player) {
        if (!network.isFakeNetwork()) {
            network.buildFluxConnections();
            FluxNetworks.network.sendTo((IMessage)new PacketNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTHelper.SyncType.SAVE, false), player);
            FluxNetworks.network.sendTo((IMessage)new PacketNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTHelper.SyncType.PACKET, false), player);
        }
    }

    public static void doConnectionsListSync(FluxNetworkServer network) {
        if (FluxNetworkCache.instance().disconnected_tiles_changed) {
            network.client_connections.setDirty(true);
            network.buildFluxConnections();
        }
        if (network.client_connections.isDirty()) {
            network.forEachListener(SYNC_NETWORK_CONNECTIONS, p -> FluxNetworks.network.sendTo((IMessage)new PacketNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTHelper.SyncType.SPECIAL, false), p.player));
        }
    }

    public static void doNetworkStatsOpen(IFluxNetwork network, EntityPlayerMP player) {
        if (!network.isFakeNetwork()) {
            FluxNetworks.network.sendTo((IMessage)new PacketNetworkStatistics(network), player);
        }
    }

    public static void doNetworkStatsSync(FluxNetworkServer network) {
        network.forEachListener(SYNC_INDEX, p -> FluxListener.doNetworkStatsOpen(network, p.player));
    }

    public static void doPlayerListOpen(IFluxNetwork network, EntityPlayerMP player) {
        if (!network.isFakeNetwork()) {
            FluxNetworks.network.sendTo((IMessage)new PacketNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTHelper.SyncType.SAVE, false), player);
            FluxNetworks.network.sendTo((IMessage)new PacketNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTHelper.SyncType.PACKET, false), player);
        }
    }

    public static void doPlayerListSync(FluxNetworkServer network) {
        if (network.network_players.isDirty()) {
            network.forEachListener(SYNC_PLAYERS, p -> FluxNetworks.network.sendTo((IMessage)new PacketNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTHelper.SyncType.SPECIAL, false), p.player));
        }
    }

    public static void doDisconnectedTilesOpen(IFluxNetwork network, EntityPlayerMP player) {
        UUID uuid = FluxPlayer.getOnlineUUID((EntityPlayer)player);
        List<IFlux> tiles = FluxNetworkCache.instance().disconnected_tiles.get(uuid);
        ArrayList<ClientFlux> client_flux = new ArrayList<ClientFlux>();
        if (tiles != null && !tiles.isEmpty()) {
            tiles.forEach(f -> client_flux.add(new ClientFlux((IFlux)f)));
        }
        FluxNetworks.network.sendTo((IMessage)new PacketDisconnectedTiles(client_flux), player);
    }

    public static void doDisconnectedTilesSync(FluxNetworkServer network) {
        if (FluxNetworkCache.instance().disconnected_tiles_changed) {
            network.forEachListener(SYNC_DISCONNECTED_CONNECTIONS, p -> FluxListener.doDisconnectedTilesOpen(network, p.player));
        }
    }

    public static interface IListenerSync {
        public void sync(FluxNetworkServer var1);
    }

    public static interface IListenerAction {
        public void sendPacket(IFluxNetwork var1, EntityPlayerMP var2);
    }
}

