/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.common.tileentity.energy;

import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.utils.ActionType;
import sonar.core.integration.EUHelper;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.common.tileentity.energy.TileFluxForgeEnergy;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergyAcceptor", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergyEmitter", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergyTile", modid="ic2")})
public abstract class TileFluxIC2
extends TileFluxForgeEnergy
implements IEnergySink,
IEnergySource {
    boolean IC2Connected = false;

    public TileFluxIC2(IFlux.ConnectionType type) {
        super(type);
    }

    @Optional.Method(modid="ic2")
    public void onLoad() {
        super.onLoad();
        if (!this.func_145831_w().field_72995_K && !this.IC2Connected) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.IC2Connected = true;
        }
    }

    @Override
    @Optional.Method(modid="ic2")
    public void func_145843_s() {
        super.func_145843_s();
        if (!this.func_145831_w().field_72995_K && this.IC2Connected) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.IC2Connected = false;
        }
    }

    @Override
    @Optional.Method(modid="ic2")
    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.func_145831_w().field_72995_K && this.IC2Connected) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.IC2Connected = false;
        }
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return this.addPhantomEnergyToNetwork(null, (long)EUHelper.getVoltage((int)this.getSinkTier()), EnergyType.EU, ActionType.SIMULATE);
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return this.getConnectionType().canAddPhantomPower();
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        return amount - (double)this.addPhantomEnergyToNetwork(directionFrom, (long)amount, EnergyType.EU, ActionType.PERFORM);
    }

    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return this.getConnectionType().canRemovePhantomPower();
    }

    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        return this.removePhantomEnergyFromNetwork(null, (long)EUHelper.getVoltage((int)this.getSinkTier()), EnergyType.EU, ActionType.SIMULATE);
    }

    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        amount -= (double)this.removePhantomEnergyFromNetwork(null, (long)amount, EnergyType.EU, ActionType.PERFORM);
    }

    @Optional.Method(modid="ic2")
    public int getSourceTier() {
        return 4;
    }
}

