/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.common.tileentity;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import sonar.core.SonarCore;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.utils.ActionType;
import sonar.core.helpers.SonarHelper;
import sonar.flux.FluxNetworks;
import sonar.flux.api.energy.internal.ITransferHandler;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.client.gui.EnumGuiTab;
import sonar.flux.client.gui.tabs.GuiTabIndexFluxConnector;
import sonar.flux.common.tileentity.energy.TileFluxTesla;
import sonar.flux.connection.transfer.handlers.ConnectionTransferHandler;

public abstract class TileFluxConnector
extends TileFluxTesla
implements IFlexibleGui {
    public final ConnectionTransferHandler handler = new ConnectionTransferHandler((TileEntity)this, this, SonarHelper.convertArray((Object[])this.getValidFaces()));

    public TileFluxConnector(IFlux.ConnectionType type) {
        super(type);
    }

    @Override
    public long addPhantomEnergyToNetwork(EnumFacing from, long max_add, EnergyType energy_type, ActionType type) {
        return this.isActive() && this.getConnectionType().canAddPhantomPower() ? this.handler.addPhantomEnergyToNetwork(from, max_add, energy_type, type) : 0L;
    }

    @Override
    public long removePhantomEnergyFromNetwork(EnumFacing from, long max_add, EnergyType energy_type, ActionType type) {
        return 0L;
    }

    @Override
    public void updateTransfers(EnumFacing ... faces) {
        super.updateTransfers(faces);
        boolean sendRenderUpdate = false;
        for (EnumFacing face : faces) {
            boolean current;
            BlockPos adj = this.field_174879_c.func_177972_a(face);
            TileEntity tile = this.field_145850_b.func_175625_s(adj);
            boolean original = ((int[])this.connections.getValue())[face.func_176745_a()] != 0;
            if (original == (current = FluxNetworks.TRANSFER_HANDLER.canRenderConnection(tile, face.func_176734_d()))) continue;
            ((int[])this.connections.getValue())[face.func_176745_a()] = current ? 1 : 0;
            this.connections.setDirty(true);
            sendRenderUpdate = true;
        }
        if (sendRenderUpdate) {
            SonarCore.sendFullSyncAroundWithRenderUpdate((TileEntity)this, (int)128);
        }
    }

    @Override
    public ITransferHandler getTransferHandler() {
        return this.handler;
    }

    @Override
    @Nonnull
    public Object getIndexScreen(List<EnumGuiTab> tabs) {
        return new GuiTabIndexFluxConnector(tabs);
    }
}

