/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.common.tileentity;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import sonar.core.SonarCore;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.utils.BlockCoords;
import sonar.core.common.tile.TileEntitySyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ListenableList;
import sonar.core.listener.PlayerListener;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.sync.ISonarValue;
import sonar.core.sync.ISyncValue;
import sonar.core.sync.IValueWatcher;
import sonar.core.sync.SyncRegistry;
import sonar.flux.FluxConfig;
import sonar.flux.FluxNetworks;
import sonar.flux.api.AdditionType;
import sonar.flux.api.ClientFlux;
import sonar.flux.api.ConnectionSettings;
import sonar.flux.api.EnumActivationType;
import sonar.flux.api.EnumPriorityType;
import sonar.flux.api.RemovalType;
import sonar.flux.api.configurator.IFluxConfigurable;
import sonar.flux.api.network.FluxPlayer;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.PlayerAccess;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.api.tiles.IFluxListenable;
import sonar.flux.client.FluxColourHandler;
import sonar.flux.client.gui.EnumGuiTab;
import sonar.flux.client.gui.tabs.GuiTabIndexConnection;
import sonar.flux.common.block.FluxConnection;
import sonar.flux.common.containers.ContainerFluxTile;
import sonar.flux.common.events.FluxConnectionEvent;
import sonar.flux.common.item.ItemConfigurator;
import sonar.flux.connection.FluxHelper;
import sonar.flux.connection.FluxListener;
import sonar.flux.connection.FluxNetworkInvalid;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.connection.transfer.handlers.FluxTransferHandler;
import sonar.flux.network.ListenerHelper;

public abstract class TileFlux
extends TileEntitySyncable
implements IFluxListenable,
IByteBufTile,
IFluxConfigurable,
IFlexibleGui {
    private final IFlux.ConnectionType type;
    public ISyncValue<Integer> priority;
    public ISyncValue<Long> limit;
    public ISyncValue<Boolean> disableLimit;
    public ISyncValue<Integer> networkID;
    public ISyncValue<UUID> playerUUID;
    public ISyncValue<String> customName;
    public ISyncValue<Integer> colour;
    public ISyncValue<int[]> connections;
    public ISyncValue<EnumActivationType> activation_type;
    public ISyncValue<EnumPriorityType> priority_type;
    public ISyncValue<Boolean> redstone_power;
    public ISyncValue<Integer> folder_id;
    private Boolean ACTIVATED;
    public ListenableList<PlayerListener> listeners;
    public IFluxNetwork network;
    private ClientFlux client_flux;
    public boolean LOADED;
    BlockCoords coords;

    public TileFlux(IFlux.ConnectionType type) {
        this.priority = SyncRegistry.createValue(Integer.class, (IValueWatcher)this.value_watcher, (String)"0", (Object)0);
        this.limit = SyncRegistry.createValue(Long.class, (IValueWatcher)this.value_watcher, (String)"1", (Object)FluxConfig.defaultLimit);
        this.disableLimit = SyncRegistry.createValue(Boolean.class, (IValueWatcher)this.value_watcher, (String)"2", (Object)false);
        this.networkID = SyncRegistry.createValue(Integer.class, (IValueWatcher)this.value_watcher, (String)"4", (Object)-1);
        this.playerUUID = SyncRegistry.createValue(UUID.class, (IValueWatcher)this.value_watcher, (String)"5", (Object)new UUID(0L, 0L));
        this.customName = SyncRegistry.createValue(String.class, (IValueWatcher)this.value_watcher, (String)"6", (Object)"Flux Connection");
        this.colour = SyncRegistry.createValue(Integer.class, (IValueWatcher)this.value_watcher, (String)"7", (Object)FluxNetworkInvalid.INVALID.getSetting(NetworkSettings.NETWORK_COLOUR).getRGB());
        this.connections = SyncRegistry.createValue(int[].class, (IValueWatcher)this.value_watcher, (String)"connect", (Object)new int[]{0, 0, 0, 0, 0, 0});
        this.activation_type = SyncRegistry.createValue(EnumActivationType.class, (IValueWatcher)this.value_watcher, (String)"activation_type", (Object)((Object)EnumActivationType.ACTIVATED));
        this.priority_type = SyncRegistry.createValue(EnumPriorityType.class, (IValueWatcher)this.value_watcher, (String)"priority_type", (Object)((Object)EnumPriorityType.NORMAL));
        this.redstone_power = SyncRegistry.createValue(Boolean.class, (IValueWatcher)this.value_watcher, (String)"rpower", (Object)false);
        this.folder_id = SyncRegistry.createValue(Integer.class, (IValueWatcher)this.value_watcher, (String)"folder", (Object)-1);
        this.ACTIVATED = null;
        this.listeners = new ListenableList((ISonarListenable)this, FluxListener.values().length);
        this.network = FluxNetworkInvalid.INVALID;
        this.LOADED = false;
        this.coords = null;
        this.type = type;
    }

    public void updateTransfers(EnumFacing ... faces) {
        this.getTransferHandler().updateTransfers(faces);
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack itemstack) {
        if (player instanceof EntityPlayer) {
            this.setPlayerUUID(FluxPlayer.getOnlineUUID((EntityPlayer)player));
            this.updateTransfers(EnumFacing.field_82609_l);
        }
    }

    @Override
    public boolean isActive() {
        if (this.ACTIVATED == null) {
            if (this.isValid()) {
                this.updateRedstonePower();
            } else {
                return false;
            }
        }
        return this.ACTIVATED;
    }

    public void updateRedstonePower() {
        if (!this.field_145850_b.field_72995_K) {
            this.redstone_power.setValue((Object)this.field_145850_b.func_175640_z(this.func_174877_v()));
        }
        switch ((EnumActivationType)((Object)this.activation_type.getValue())) {
            case ACTIVATED: {
                this.ACTIVATED = true;
                break;
            }
            case DISACTIVATED: {
                this.ACTIVATED = false;
                break;
            }
            case POSITIVE_SIGNAL: {
                this.ACTIVATED = (Boolean)this.redstone_power.getValue();
                break;
            }
            case NEGATIVE_SIGNAL: {
                this.ACTIVATED = (Boolean)this.redstone_power.getValue() == false;
                break;
            }
            default: {
                this.ACTIVATED = true;
            }
        }
    }

    @Override
    public void connect(IFluxNetwork network) {
        IFluxNetwork oldNetwork = this.network;
        this.network = network;
        this.networkID.setValue((Object)network.getNetworkID());
        this.colour.setValue((Object)network.getSetting(NetworkSettings.NETWORK_COLOUR).getRGB());
        this.setAndSendConnectionState(true);
        ListenerHelper.onNetworkChanged(this, oldNetwork, network);
    }

    @Override
    public void disconnect(IFluxNetwork network) {
        if (network.getNetworkID() == ((Integer)this.networkID.getValue()).intValue()) {
            IFluxNetwork oldNetwork = this.network;
            this.network = FluxNetworkInvalid.INVALID;
            this.networkID.setValue((Object)-1);
            this.colour.setValue((Object)network.getSetting(NetworkSettings.NETWORK_COLOUR).getRGB());
            this.setAndSendConnectionState(false);
            ListenerHelper.onNetworkChanged(this, oldNetwork, this.network);
        }
    }

    public void setAndSendConnectionState(boolean bool) {
        if (this.field_145850_b.func_175667_e(this.func_174877_v())) {
            World world = this.func_145831_w();
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            if (state.func_177230_c() instanceof FluxConnection) {
                world.func_180501_a(this.func_174877_v(), state.func_177226_a((IProperty)FluxConnection.CONNECTED, (Comparable)Boolean.valueOf(bool)), 2);
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public EnumFacing[] getValidFaces() {
        return EnumFacing.values();
    }

    public void setPlayerUUID(UUID name) {
        this.playerUUID.setValue((Object)name);
    }

    @Override
    public PlayerAccess canAccess(EntityPlayer player) {
        if (FluxHelper.isPlayerAdmin(player)) {
            return PlayerAccess.CREATIVE;
        }
        if (this.playerUUID.getValue() != null && ((UUID)this.playerUUID.getValue()).equals(FluxPlayer.getOnlineUUID(player))) {
            return PlayerAccess.OWNER;
        }
        return this.getNetwork().isFakeNetwork() ? PlayerAccess.BLOCKED : this.getNetwork().getPlayerAccess(player);
    }

    @Override
    public UUID getConnectionOwner() {
        return (UUID)this.playerUUID.getValue();
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && !this.LOADED) {
            FluxHelper.addConnection(this, AdditionType.ADD);
            this.updateTransfers(EnumFacing.field_82609_l);
            this.LOADED = true;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.field_145850_b.field_72995_K && this.LOADED) {
            FluxHelper.removeConnection(this, RemovalType.CHUNK_UNLOAD);
            this.LOADED = false;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.LOADED) {
            FluxHelper.removeConnection(this, RemovalType.REMOVE);
            this.LOADED = false;
        }
    }

    @Override
    public BlockCoords getCoords() {
        if (this.coords == null) {
            this.coords = new BlockCoords(this.func_174877_v(), this.func_145831_w());
        }
        return this.coords;
    }

    @Override
    public int getNetworkID() {
        return (Integer)this.networkID.getValue();
    }

    @Override
    public IFluxNetwork getNetwork() {
        return this.network;
    }

    @Override
    public IFlux.ConnectionType getConnectionType() {
        return this.type;
    }

    @Override
    public long getCurrentLimit() {
        return (Boolean)this.disableLimit.getValue() != false ? Long.MAX_VALUE : (Long)this.limit.getValue();
    }

    @Override
    public long getTransferLimit() {
        return (Long)this.limit.getValue();
    }

    @Override
    public boolean getDisableLimit() {
        return (Boolean)this.disableLimit.getValue();
    }

    @Override
    public EnumActivationType getActivationType() {
        return (EnumActivationType)((Object)this.activation_type.getValue());
    }

    @Override
    public EnumPriorityType getPriorityType() {
        return (EnumPriorityType)((Object)this.priority_type.getValue());
    }

    @Override
    public int getCurrentPriority() {
        return this.priority_type.getValue() == EnumPriorityType.NORMAL ? (Integer)this.priority.getValue() : Integer.MAX_VALUE;
    }

    @Override
    public int getFolderID() {
        return (Integer)this.folder_id.getValue();
    }

    @Override
    public World getDimension() {
        return this.field_145850_b;
    }

    @Override
    public String getCustomName() {
        return (String)this.customName.getValue();
    }

    public ClientFlux getClientFlux() {
        if (this.client_flux == null) {
            this.client_flux = new ClientFlux(this);
        }
        return this.client_flux;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if ((type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL}) || this.network.isFakeNetwork() && type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC})) && nbt.func_74764_b("client_flux")) {
            this.client_flux = new ClientFlux(nbt.func_74775_l("client_flux"));
        }
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE})) {
            ((FluxTransferHandler)this.getTransferHandler()).buffer = nbt.func_74763_f("buf");
        }
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DROP})) {
            if (nbt.func_74764_b("cust_name")) {
                this.customName.setValue((Object)nbt.func_74779_i("cust_name"));
            }
            if (nbt.func_74764_b("priority")) {
                this.priority.setValue((Object)nbt.func_74762_e("priority"));
            }
            if (nbt.func_74764_b("limit")) {
                this.limit.setValue((Object)nbt.func_74763_f("limit"));
            }
            if (nbt.func_74764_b("e_limit")) {
                this.disableLimit.setValue((Object)nbt.func_74767_n("e_limit"));
            }
            if (nbt.func_74764_b("network_id")) {
                this.networkID.setValue((Object)nbt.func_74762_e("network_id"));
            }
        }
        super.readData(nbt, type);
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if ((type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL}) || this.network.isFakeNetwork() && type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC})) && this.listeners.hasListeners(FluxListener.SYNC_INDEX.ordinal())) {
            this.client_flux = new ClientFlux(this);
            nbt.func_74782_a("client_flux", (NBTBase)this.client_flux.writeData(new NBTTagCompound(), type));
        }
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE})) {
            nbt.func_74772_a("buf", ((FluxTransferHandler)this.getTransferHandler()).buffer);
        }
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DROP})) {
            nbt.func_74778_a("cust_name", (String)this.customName.getValue());
            nbt.func_74768_a("priority", ((Integer)this.priority.getValue()).intValue());
            nbt.func_74772_a("limit", ((Long)this.limit.getValue()).longValue());
            nbt.func_74757_a("e_limit", ((Boolean)this.disableLimit.getValue()).booleanValue());
            nbt.func_74768_a("network_id", ((Integer)this.networkID.getValue()).intValue());
        }
        return super.writeData(nbt, type);
    }

    public void onValuesChanged() {
        super.onValuesChanged();
        if (this.field_145850_b != null && this.colour.isDirty()) {
            if (!this.field_145850_b.field_72995_K) {
                SonarCore.sendPacketAround((TileEntity)this, (int)128, (int)11);
            } else {
                FluxColourHandler.loadColourCache(this.getNetworkID(), (Integer)this.colour.getValue());
                this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
            }
        }
    }

    public void onInternalValueChanged(ISonarValue value) {
        super.onInternalValueChanged(value);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && value == this.colour) {
            FluxColourHandler.loadColourCache(this.getNetworkID(), (Integer)this.colour.getValue());
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public void markSettingChanged(ConnectionSettings setting) {
        MinecraftForge.EVENT_BUS.post((Event)new FluxConnectionEvent.SettingChanged(this, setting));
    }

    public void writePacket(ByteBuf buf, int id) {
        switch (id) {
            case -1: {
                this.disableLimit.save(buf);
                break;
            }
            case 1: {
                this.priority.save(buf);
                break;
            }
            case 2: {
                this.limit.save(buf);
                break;
            }
            case 3: {
                this.customName.save(buf);
                break;
            }
            case 11: {
                this.colour.save(buf);
                break;
            }
            case 12: {
                this.activation_type.save(buf);
                break;
            }
            case 16: {
                this.priority_type.save(buf);
            }
        }
    }

    public void readPacket(ByteBuf buf, int id) {
        switch (id) {
            case -1: {
                this.disableLimit.load(buf);
                this.markSettingChanged(ConnectionSettings.TRANSFER_LIMIT);
                break;
            }
            case 1: {
                this.priority.load(buf);
                this.markSettingChanged(ConnectionSettings.PRIORITY);
                break;
            }
            case 2: {
                this.limit.load(buf);
                this.markSettingChanged(ConnectionSettings.TRANSFER_LIMIT);
                break;
            }
            case 3: {
                this.customName.load(buf);
                this.markSettingChanged(ConnectionSettings.CUSTOM_NAME);
                break;
            }
            case 11: {
                this.colour.load(buf);
                break;
            }
            case 12: {
                this.activation_type.load(buf);
                this.updateRedstonePower();
                break;
            }
            case 16: {
                this.priority_type.load(buf);
                this.markSettingChanged(ConnectionSettings.PRIORITY);
            }
        }
    }

    public ListenableList<PlayerListener> getListenerList() {
        return this.listeners;
    }

    public boolean isValid() {
        return !this.func_145837_r();
    }

    @Override
    public boolean isChunkLoaded() {
        return this.isValid();
    }

    @Override
    public NBTTagCompound copyConfiguration(NBTTagCompound config, NBTTagCompound disabled, EntityPlayer player) {
        return ItemConfigurator.copyConfiguration(this, config, disabled, player);
    }

    @Override
    public void pasteConfiguration(NBTTagCompound config, NBTTagCompound disabled, EntityPlayer player) {
        ItemConfigurator.pasteConfiguration(this, config, disabled, player);
    }

    public void onGuiOpened(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        ListenerHelper.onPlayerOpenTileGui(this, player);
        ListenerHelper.onPlayerOpenTileTab(this, player, EnumGuiTab.INDEX);
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        return new ContainerFluxTile(player, this);
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        FluxNetworks.proxy.setFluxTile(this);
        return EnumGuiTab.INDEX.getGuiScreen(this.getTabs());
    }

    public List<EnumGuiTab> getTabs() {
        return Lists.newArrayList((Object[])new EnumGuiTab[]{EnumGuiTab.INDEX, EnumGuiTab.NETWORK_SELECTION, EnumGuiTab.CONNECTIONS, EnumGuiTab.NETWORK_STATISTICS, EnumGuiTab.PLAYERS, EnumGuiTab.DEBUG, EnumGuiTab.NETWORK_EDIT, EnumGuiTab.NETWORK_CREATE});
    }

    @Nonnull
    public Object getIndexScreen(List<EnumGuiTab> tabs) {
        return new GuiTabIndexConnection(tabs);
    }
}

