/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.common.tileentity;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import sonar.core.api.IFlexibleGui;
import sonar.core.sync.ISyncValue;
import sonar.core.sync.IValueWatcher;
import sonar.core.sync.SyncRegistry;
import sonar.flux.FluxNetworks;
import sonar.flux.api.energy.internal.ITransferHandler;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.api.tiles.IFluxController;
import sonar.flux.client.gui.EnumGuiTab;
import sonar.flux.client.gui.tabs.GuiTabIndexController;
import sonar.flux.common.tileentity.TileFlux;
import sonar.flux.connection.transfer.ControllerTransfer;
import sonar.flux.connection.transfer.handlers.SingleTransferHandler;

public class TileController
extends TileFlux
implements IFlexibleGui,
IFluxController {
    public ISyncValue<Boolean> wireless_charging;
    public ISyncValue<Boolean> main_inventory;
    public ISyncValue<Boolean> hot_bar;
    public ISyncValue<Boolean> armour_slot;
    public ISyncValue<Boolean> baubles_slot;
    public ISyncValue<Boolean> left_hand;
    public ISyncValue<Boolean> right_hand;
    public final SingleTransferHandler handler;

    public TileController() {
        super(IFlux.ConnectionType.CONTROLLER);
        this.wireless_charging = SyncRegistry.createValue(Boolean.class, (IValueWatcher)this.value_watcher, (String)"12", (Object)false);
        this.main_inventory = SyncRegistry.createValue(Boolean.class, (IValueWatcher)this.value_watcher, (String)"14", (Object)true);
        this.hot_bar = SyncRegistry.createValue(Boolean.class, (IValueWatcher)this.value_watcher, (String)"15", (Object)true);
        this.armour_slot = SyncRegistry.createValue(Boolean.class, (IValueWatcher)this.value_watcher, (String)"16", (Object)true);
        this.baubles_slot = SyncRegistry.createValue(Boolean.class, (IValueWatcher)this.value_watcher, (String)"17", (Object)true);
        this.left_hand = SyncRegistry.createValue(Boolean.class, (IValueWatcher)this.value_watcher, (String)"18", (Object)false);
        this.right_hand = SyncRegistry.createValue(Boolean.class, (IValueWatcher)this.value_watcher, (String)"19", (Object)false);
        this.handler = new SingleTransferHandler(this, new ControllerTransfer(this));
        this.customName.setValueInternal((Object)"Flux Controller");
    }

    @Override
    public void writePacket(ByteBuf buf, int id) {
        super.writePacket(buf, id);
        switch (id) {
            case 13: {
                this.wireless_charging.save(buf);
                break;
            }
            case 14: {
                this.customName.save(buf);
                break;
            }
            case 15: {
                this.main_inventory.save(buf);
                this.hot_bar.save(buf);
                this.armour_slot.save(buf);
                this.baubles_slot.save(buf);
                this.left_hand.save(buf);
                this.right_hand.save(buf);
            }
        }
    }

    @Override
    public void readPacket(ByteBuf buf, int id) {
        super.readPacket(buf, id);
        switch (id) {
            case 13: {
                this.wireless_charging.load(buf);
                break;
            }
            case 14: {
                this.customName.load(buf);
                break;
            }
            case 15: {
                this.main_inventory.load(buf);
                this.hot_bar.load(buf);
                this.armour_slot.load(buf);
                this.baubles_slot.load(buf);
                this.left_hand.load(buf);
                this.right_hand.load(buf);
            }
        }
    }

    @Override
    public ItemStack getDisplayStack() {
        return new ItemStack(FluxNetworks.fluxController, 1);
    }

    @Override
    public ITransferHandler getTransferHandler() {
        return this.handler;
    }

    @Override
    public List<EnumGuiTab> getTabs() {
        return Lists.newArrayList((Object[])new EnumGuiTab[]{EnumGuiTab.INDEX, EnumGuiTab.WIRELESS_CHARGING, EnumGuiTab.NETWORK_SELECTION, EnumGuiTab.CONNECTIONS, EnumGuiTab.NETWORK_STATISTICS, EnumGuiTab.PLAYERS, EnumGuiTab.DEBUG, EnumGuiTab.NETWORK_EDIT, EnumGuiTab.NETWORK_CREATE});
    }

    @Override
    @Nonnull
    public Object getIndexScreen(List<EnumGuiTab> tabs) {
        return new GuiTabIndexController(tabs);
    }
}

