/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.common.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import sonar.core.helpers.FontHelper;
import sonar.flux.FluxConfig;
import sonar.flux.FluxTranslate;
import sonar.flux.common.block.FluxConnection;
import sonar.flux.common.tileentity.TileStorage;

public class FluxStorage
extends FluxConnection {
    public TileEntity func_149915_a(@Nonnull World world, int i) {
        return new TileStorage.Basic();
    }

    public int getMaxStorage() {
        return FluxConfig.basicCapacity;
    }

    public int getMaxTransfer() {
        return FluxConfig.basicTransfer;
    }

    @Override
    public void addSpecialToolTip(ItemStack stack, World world, List<String> list, NBTTagCompound tag) {
        list.add(FluxTranslate.FLUX_STORAGE_TOOLTIP.t());
        NBTTagCompound subTag = stack.func_179543_a("sonar_drop");
        int energy = subTag == null ? 0 : subTag.func_74762_e("energy");
        list.add(FluxTranslate.STORED.t() + ": " + FontHelper.formatStorage((long)energy) + "/" + FontHelper.formatStorage((long)this.getMaxStorage()));
    }

    public static class Gargantuan
    extends FluxStorage {
        @Override
        public TileEntity func_149915_a(World world, int i) {
            return new TileStorage.Gargantuan();
        }

        @Override
        public int getMaxStorage() {
            return FluxConfig.gargantuanCapacity;
        }

        @Override
        public int getMaxTransfer() {
            return FluxConfig.gargantuanTransfer;
        }
    }

    public static class Herculean
    extends FluxStorage {
        @Override
        public TileEntity func_149915_a(World world, int i) {
            return new TileStorage.Herculean();
        }

        @Override
        public int getMaxStorage() {
            return FluxConfig.herculeanCapacity;
        }

        @Override
        public int getMaxTransfer() {
            return FluxConfig.herculeanTransfer;
        }
    }
}

