/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.client.gui.tabs;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.client.gui.IGridGui;
import sonar.core.client.gui.SelectionGrid;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.SonarHelper;
import sonar.core.translate.Localisation;
import sonar.core.utils.SortingDirection;
import sonar.flux.FluxNetworks;
import sonar.flux.FluxTranslate;
import sonar.flux.api.ClientFlux;
import sonar.flux.api.ClientTransfer;
import sonar.flux.api.SortingType;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.client.gui.EnumGuiTab;
import sonar.flux.client.gui.GuiTabAbstract;
import sonar.flux.client.gui.GuiTabAbstractGrid;
import sonar.flux.client.gui.buttons.ConnectNetworkButton;
import sonar.flux.client.gui.buttons.ConnectedBlocksButton;
import sonar.flux.client.gui.buttons.ConnectedTilesButton;
import sonar.flux.client.gui.buttons.ConnectionDirectionButton;
import sonar.flux.client.gui.buttons.ConnectionSortingButton;
import sonar.flux.client.gui.buttons.LargeButton;
import sonar.flux.client.gui.tabs.GuiTabIndexSingleEditing;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.network.ClientNetworkCache;
import sonar.flux.network.PacketEditedTiles;

public class GuiTabNetworkConnections
extends GuiTabAbstractGrid<Object> {
    public static ChunkDisplayOptions chunk_display_option = ChunkDisplayOptions.BOTH;
    public static Map<IFlux.ConnectionType, Boolean> canDisplay = new HashMap<IFlux.ConnectionType, Boolean>();
    public static SortingType sorting_type = SortingType.PRIORITY;
    public static SortingDirection sorting_dir = SortingDirection.UP;
    public static boolean showConnections = false;
    public static boolean show_disconnected = false;
    public SonarScroller connection_grid_scroller;
    public SelectionGrid connection_grid;
    public List<ClientFlux> selected = new ArrayList<ClientFlux>();
    public List<Integer> folder_ids = new ArrayList<Integer>();

    public GuiTabNetworkConnections(List tabs) {
        super(tabs);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new ConnectionTypeButton(this, 0, IFlux.ConnectionType.PLUG, FluxTranslate.PLUGS.t(), this.getGuiLeft() + 12, this.getGuiTop() + 142));
        this.field_146292_n.add(new ConnectionTypeButton(this, 1, IFlux.ConnectionType.POINT, FluxTranslate.POINTS.t(), this.getGuiLeft() + 52, this.getGuiTop() + 142));
        this.field_146292_n.add(new ConnectionTypeButton(this, 2, IFlux.ConnectionType.STORAGE, FluxTranslate.STORAGE.t(), this.getGuiLeft() + 92, this.getGuiTop() + 142));
        this.field_146292_n.add(new ConnectionTypeButton(this, 3, IFlux.ConnectionType.CONTROLLER, FluxTranslate.CONTROLLERS.t(), this.getGuiLeft() + 132, this.getGuiTop() + 142));
        this.field_146292_n.add(new ChunkLoadedButton(this, 4, this.getGuiLeft() + 132, this.getGuiTop() + 119, 32, 15));
        this.field_146292_n.add(new ConnectionSortingButton(this, 5, this.getGuiLeft() + 11, this.getGuiTop() + 119));
        this.field_146292_n.add(new ConnectionDirectionButton(this, 6, this.getGuiLeft() + 28, this.getGuiTop() + 119));
        this.field_146292_n.add(new ConnectedBlocksButton(this, 7, this.getGuiLeft() + 51, this.getGuiTop() + 119));
        this.field_146292_n.add(new LargeButton(this, FluxTranslate.SORTING_CLEAR.t(), 8, this.getGuiLeft() + 68, this.getGuiTop() + 119, 68, 0));
        this.field_146292_n.add(new ConnectedTilesButton(this, 9, this.getGuiLeft() + 91, this.getGuiTop() + 119));
        this.field_146292_n.add(new ConnectNetworkButton(this, 10, this.getGuiLeft() + 108, this.getGuiTop() + 119));
    }

    @Override
    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof ConnectionTypeButton) {
            IFlux.ConnectionType type;
            canDisplay.put(type, canDisplay.get((Object)(type = ((ConnectionTypeButton)button).type)) == false);
            this.connection_grid_scroller.currentScroll = 0.0f;
            return;
        }
        switch (button.field_146127_k) {
            case 4: {
                chunk_display_option = (ChunkDisplayOptions)SonarHelper.incrementEnum((Enum)chunk_display_option, (Enum[])ChunkDisplayOptions.values());
                this.connection_grid_scroller.currentScroll = 0.0f;
                break;
            }
            case 5: {
                sorting_type = (SortingType)SonarHelper.incrementEnum((Enum)sorting_type, (Enum[])SortingType.values());
                this.connection_grid_scroller.currentScroll = 0.0f;
                break;
            }
            case 6: {
                sorting_dir = (SortingDirection)SonarHelper.incrementEnum((Enum)sorting_dir, (Enum[])SortingDirection.values());
                this.connection_grid_scroller.currentScroll = 0.0f;
                break;
            }
            case 7: {
                showConnections = !showConnections;
                this.connection_grid_scroller.currentScroll = 0.0f;
                break;
            }
            case 8: {
                chunk_display_option = ChunkDisplayOptions.BOTH;
                showConnections = false;
                canDisplay = new HashMap<IFlux.ConnectionType, Boolean>();
                for (IFlux.ConnectionType type : IFlux.ConnectionType.values()) {
                    canDisplay.put(type, true);
                }
                break;
            }
            case 9: {
                show_disconnected = !show_disconnected;
                this.selected.clear();
                break;
            }
            case 10: {
                if (show_disconnected) {
                    this.selected.forEach(f -> {
                        f.network_id = this.getNetworkID();
                    });
                } else {
                    this.selected.forEach(f -> {
                        f.network_id = -1;
                    });
                }
                FluxNetworks.network.sendToServer((IMessage)new PacketEditedTiles(this.selected));
            }
        }
    }

    @Override
    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        if (this.getGridList(0).isEmpty()) {
            if (this.common.isFakeNetwork()) {
                this.renderNavigationPrompt(FluxTranslate.ERROR_NO_CONNECTIONS.t(), FluxTranslate.GUI_TAB_NETWORK_SELECTION.t());
            } else {
                FontHelper.textCentre((String)FluxTranslate.ERROR_NO_MATCHES.t(), (int)this.field_146999_f, (int)14, (int)Color.GRAY.getRGB());
            }
        }
    }

    @Override
    public void addGrids(Map<SelectionGrid, SonarScroller> grids) {
        this.connection_grid = new SelectionGrid((IGridGui)this, 0, 11, 8, 154, 18, 1, 6);
        this.connection_grid_scroller = new SonarScroller(this.connection_grid.xPos + this.connection_grid.gWidth * this.connection_grid.eWidth, this.connection_grid.yPos, this.connection_grid.gHeight * this.connection_grid.eHeight, 7);
        grids.put(this.connection_grid, this.connection_grid_scroller);
    }

    public void onGridClicked(int gridID, Object element, int x, int y, int pos, int button, boolean empty) {
        if (element instanceof ClientFlux) {
            if (button == 1) {
                FMLCommonHandler.instance().showGuiScreen(new GuiTabIndexSingleEditing(this, (ClientFlux)element, this.tabs));
            } else if (this.selected.contains(element)) {
                this.selected.remove(element);
            } else {
                this.selected.add((ClientFlux)element);
            }
        }
    }

    public void renderGridElement(int gridID, Object element, int x, int y, int slot) {
        if (element instanceof ClientFlux) {
            this.renderFlux((IFlux)element, this.selected.contains(element), 0, 0);
        } else if (element instanceof ClientTransfer) {
            this.renderFluxTransfer((ClientTransfer)element, x, y, this.getNetworkColour());
        }
    }

    public void renderElementToolTip(int gridID, Object element, int x, int y) {
        List<String> strings = null;
        if (element instanceof ClientFlux) {
            strings = this.getTextLines((ClientFlux)element);
        } else if (element instanceof ClientTransfer) {
            strings = this.getTextLines((ClientTransfer)element);
        }
        if (strings != null && !strings.isEmpty()) {
            this.func_146283_a(strings, x, y);
        }
    }

    @Override
    public List getGridList(int gridID) {
        ArrayList<ClientFlux> list = new ArrayList<ClientFlux>();
        ArrayList<ClientFlux> gridList = new ArrayList<ClientFlux>();
        if (!show_disconnected) {
            for (ClientFlux c : NetworkSettings.CLIENT_CONNECTIONS.getValue(this.common)) {
                if (!chunk_display_option.canDisplay(c) || !canDisplay.get((Object)c.getConnectionType()).booleanValue()) continue;
                c.addToGuiList(gridList, true, false);
            }
        } else {
            ClientNetworkCache.instance().disconnected_tiles.forEach(f -> f.addToGuiList(gridList, true, false));
        }
        sorting_type.sort(gridList, sorting_dir);
        list.addAll(gridList);
        if (showConnections) {
            ArrayList connection_list = new ArrayList();
            for (Object e : list) {
                if (e instanceof ClientFlux) {
                    ClientFlux flux = (ClientFlux)e;
                    flux.addToGuiList(connection_list, true, flux.connection_type == IFlux.ConnectionType.PLUG || flux.connection_type == IFlux.ConnectionType.POINT);
                    continue;
                }
                connection_list.add(e);
            }
            return connection_list;
        }
        return gridList;
    }

    @Override
    public EnumGuiTab getCurrentTab() {
        return EnumGuiTab.CONNECTIONS;
    }

    static {
        for (IFlux.ConnectionType type : IFlux.ConnectionType.values()) {
            canDisplay.put(type, true);
        }
    }

    public static class ConnectionTypeButton
    extends GuiButton {
        public GuiTabNetworkConnections gui;
        public IFlux.ConnectionType type;
        public String typeName;
        public ItemStack displayStack;

        protected ConnectionTypeButton(GuiTabNetworkConnections gui, int id, IFlux.ConnectionType type, String name, int x, int y) {
            super(id, x, y, 32, 16, "");
            this.gui = gui;
            this.type = type;
            this.typeName = name;
            this.displayStack = type.getRepresentiveStack();
            NBTTagCompound colourTag = new NBTTagCompound();
            colourTag.func_74757_a("gui_colour", true);
            this.displayStack.func_77982_d(colourTag);
        }

        public void func_191745_a(@Nonnull Minecraft mc, int x, int y, float partialTicks) {
            if (this.field_146125_m) {
                this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ConnectionTypeButton.func_73734_a((int)(this.field_146128_h - 1), (int)(this.field_146129_i - 1), (int)(this.field_146128_h + 32 + 1), (int)(this.field_146129_i + 16 + 1), (int)this.type.gui_colour);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ConnectionTypeButton.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + 32), (int)(this.field_146129_i + 16), (int)Color.BLACK.getRGB());
                this.gui.drawNormalItemStack(this.displayStack, this.field_146128_h, this.field_146129_i);
                if (canDisplay.get((Object)this.type).booleanValue()) {
                    mc.func_110434_K().func_110577_a(GuiTabAbstract.small_buttons);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.func_73729_b(this.field_146128_h + 3 + 16, this.field_146129_i + 2, 24, 12, 11, 11);
                }
            }
        }

        public void func_146111_b(int x, int y) {
            this.gui.drawSonarCreativeTabHoveringText(FluxTranslate.SHOW.t() + " " + this.typeName + ": " + canDisplay.get((Object)this.type), x, y);
        }
    }

    public static class ChunkLoadedButton
    extends GuiButton {
        public GuiTabNetworkConnections gui;

        protected ChunkLoadedButton(GuiTabNetworkConnections gui, int id, int x, int y, int width, int height) {
            super(id, x, y, width, height, "");
            this.gui = gui;
        }

        public void func_191745_a(@Nonnull Minecraft mc, int x, int y, float partialTicks) {
            if (this.field_146125_m) {
                this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ChunkLoadedButton.func_73734_a((int)(this.field_146128_h - 1), (int)(this.field_146129_i - 1), (int)(this.field_146128_h + 1 + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g + 1), (int)GuiTabAbstract.grey);
                switch (chunk_display_option) {
                    case BOTH: {
                        ChunkLoadedButton.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)GuiTabAbstract.midBlue);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        mc.func_110434_K().func_110577_a(GuiTabAbstract.scroller_flux_gui);
                        this.func_73729_b(this.field_146128_h, this.field_146129_i, 4, 227, this.field_146120_f, this.field_146121_g / 2);
                        break;
                    }
                    case LOADED: {
                        ChunkLoadedButton.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)GuiTabAbstract.midBlue);
                        break;
                    }
                    case UNLOADED: {
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        mc.func_110434_K().func_110577_a(GuiTabAbstract.scroller_flux_gui);
                        this.func_73729_b(this.field_146128_h, this.field_146129_i, 4, 227, this.field_146120_f, this.field_146121_g);
                        break;
                    }
                }
            }
        }

        public void func_146111_b(int x, int y) {
            this.gui.drawSonarCreativeTabHoveringText(FluxTranslate.CHUNK.t() + ": " + chunk_display_option.getDisplayName(), x, y);
        }
    }

    public static enum ChunkDisplayOptions {
        BOTH(FluxTranslate.SORTING_BOTH),
        LOADED(FluxTranslate.SORTING_LOADED),
        UNLOADED(FluxTranslate.SORTING_UNLOADED);

        Localisation message;

        private ChunkDisplayOptions(Localisation message) {
            this.message = message;
        }

        public String getDisplayName() {
            return this.message.t();
        }

        public boolean canDisplay(IFlux flux) {
            switch (this) {
                case LOADED: {
                    return flux.isChunkLoaded();
                }
                case UNLOADED: {
                    return !flux.isChunkLoaded();
                }
            }
            return true;
        }
    }
}

