/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.api.network;

import sonar.core.translate.Localisation;
import sonar.flux.FluxTranslate;

public enum PlayerAccess {
    OWNER(FluxTranslate.PLAYERS_NETWORK_OWNER),
    SHARED_OWNER(FluxTranslate.PLAYERS_NETWORK_SHARED_OWNER),
    USER(FluxTranslate.PLAYERS_NETWORK_USER),
    BLOCKED(FluxTranslate.PLAYERS_NETWORK_BLOCKED),
    CREATIVE(FluxTranslate.PLAYERS_NETWORK_CREATIVE);

    Localisation message;

    private PlayerAccess(Localisation message) {
        this.message = message;
    }

    public String getDisplayName() {
        return this.message.t();
    }

    public boolean canDelete() {
        return this == OWNER || this == CREATIVE;
    }

    public boolean canEdit() {
        return this.canDelete() || this == SHARED_OWNER;
    }

    public boolean canView() {
        return this.canEdit() || this == USER;
    }

    public boolean canConnect() {
        return this != BLOCKED;
    }

    public String getName() {
        return this.message.t();
    }

    public PlayerAccess incrementAccess() {
        switch (this) {
            case USER: {
                return SHARED_OWNER;
            }
            case SHARED_OWNER: {
                return BLOCKED;
            }
            case BLOCKED: {
                return USER;
            }
        }
        return USER;
    }
}

