/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.api.network;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.sync.ISonarValue;
import sonar.flux.api.AdditionType;
import sonar.flux.api.RemovalType;
import sonar.flux.api.network.FluxPlayer;
import sonar.flux.api.network.PlayerAccess;
import sonar.flux.api.tiles.IFluxListenable;
import sonar.flux.connection.NetworkSettings;

public interface IFluxNetwork
extends INBTSyncable {
    default public int getNetworkID() {
        return this.getSetting(NetworkSettings.NETWORK_ID);
    }

    public <T> T getSetting(NetworkSettings<T> var1);

    public <T> ISonarValue<T> getSyncSetting(NetworkSettings<T> var1);

    default public <T> void setSetting(NetworkSettings<T> setting, T set) {
        this.getSyncSetting(setting).setValue(set);
    }

    default public <T> void setSettingInternal(NetworkSettings<T> setting, T set) {
        this.getSyncSetting(setting).setValueInternal(set);
    }

    default public void onStartServerTick() {
    }

    default public void onEndServerTick() {
    }

    default public void onRemoved() {
    }

    default public void queueConnectionAddition(IFluxListenable flux, AdditionType type) {
    }

    default public void queueConnectionRemoval(IFluxListenable flux, RemovalType type) {
    }

    public boolean isOwner(EntityPlayer var1);

    public PlayerAccess getPlayerAccess(EntityPlayer var1);

    public void removePlayerAccess(UUID var1, PlayerAccess var2);

    public void addPlayerAccess(String var1, PlayerAccess var2);

    public Optional<FluxPlayer> getValidFluxPlayer(UUID var1);

    public boolean isFakeNetwork();

    default public void buildFluxConnections() {
    }

    default public boolean canConvert(EnergyType from, EnergyType to) {
        return false;
    }

    default public boolean canTransfer(EnergyType type) {
        return false;
    }

    default public void debugConnectedBlocks() {
    }

    default public void debugValidateFluxConnections() {
    }
}

