/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.network;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public enum ObjectBufferUtils {
    STRING(String.class, (string, buffer) -> {
        buffer.writeInt(string.length());
        buffer.func_180714_a(string);
    }, buffer -> buffer.func_150789_c(buffer.readInt())),
    INT(Integer.class, (value, buffer) -> buffer.writeInt(value.intValue()), PacketBuffer::readInt),
    BLOCK_POS(BlockPos.class, (pos, buffer) -> buffer.func_179255_a(pos), PacketBuffer::func_179259_c);

    Class clazz;
    ObjectWriter writer;
    ObjectReader reader;

    private <T> ObjectBufferUtils(Class<T> clazz, ObjectWriter<T> writer, ObjectReader<T> reader) {
        this.clazz = clazz;
        this.writer = writer;
        this.reader = reader;
    }

    public static void writeObject(Object object, PacketBuffer buffer) {
        ObjectBufferUtils utils = Arrays.stream(ObjectBufferUtils.values()).filter(objectBufferUtils -> objectBufferUtils.clazz == object.getClass()).findFirst().orElse(null);
        Objects.requireNonNull(utils, "No support found for " + object.getClass());
        buffer.writeInt(utils.ordinal());
        utils.writer.write(object, buffer);
    }

    public static Object readObject(PacketBuffer buffer) {
        ObjectBufferUtils utils = ObjectBufferUtils.values()[buffer.readInt()];
        Objects.requireNonNull(utils, "Could not find reader");
        return utils.reader.read(buffer);
    }

    private static interface ObjectReader<T> {
        public T read(PacketBuffer var1);
    }

    private static interface ObjectWriter<T> {
        public void write(T var1, PacketBuffer var2);
    }
}

