/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.misc;

import com.buuz135.industrial.proxy.BlockRegistry;
import com.buuz135.industrial.tile.CustomSidedTileEntity;
import com.buuz135.industrial.utils.WorkUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.LockedInventoryTogglePiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.inventory.LockableItemHandler;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;

public class BlackHoleControllerTile
extends CustomSidedTileEntity {
    private LockableItemHandler input;
    private ItemStackHandler storage;
    private LockableItemHandler output;
    private BlackHoleControllerHandler itemHandler = new BlackHoleControllerHandler(this);

    public BlackHoleControllerTile() {
        super(BlackHoleControllerTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.input = new LockableItemHandler(9){

            protected void onContentsChanged(int slot) {
                if (slot < 0) {
                    return;
                }
                ItemStack in = BlackHoleControllerTile.this.input.getStackInSlot(slot);
                int amount = BlockRegistry.blackHoleUnitBlock.getAmount(BlackHoleControllerTile.this.storage.getStackInSlot(slot));
                if (!in.func_190926_b() && in.func_190916_E() + amount < Integer.MAX_VALUE) {
                    BlockRegistry.blackHoleUnitBlock.setItemStack(BlackHoleControllerTile.this.storage.getStackInSlot(slot), in);
                    BlockRegistry.blackHoleUnitBlock.setAmount(BlackHoleControllerTile.this.storage.getStackInSlot(slot), amount + in.func_190916_E());
                    in.func_190920_e(0);
                }
                BlackHoleControllerTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.input, EnumDyeColor.BLUE, "Input items", new BoundingRectangle(15, 18, 162, 18)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                if (BlackHoleControllerTile.this.storage.getStackInSlot(slot).func_190926_b() || stack.func_77973_b().equals(Item.func_150898_a((Block)BlockRegistry.blackHoleUnitBlock))) {
                    return false;
                }
                if (BlackHoleControllerTile.this.input.getLocked()) {
                    return BlackHoleControllerTile.this.input.getFilterStack(slot).func_77969_a(stack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)BlackHoleControllerTile.this.input.getFilterStack(slot));
                }
                if (!BlackHoleControllerTile.this.output.getStackInSlot(slot).func_190926_b() && !BlackHoleControllerTile.this.output.getStackInSlot(slot).func_77969_a(stack)) {
                    return false;
                }
                ItemStack contained = BlockRegistry.blackHoleUnitBlock.getItemStack(BlackHoleControllerTile.this.storage.getStackInSlot(slot));
                if (stack.func_77969_a(contained) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)contained)) {
                    return true;
                }
                return !BlackHoleControllerTile.this.input.getLocked() && contained.func_190926_b();
            }

            public boolean canExtractItem(int slot) {
                return super.canExtractItem(slot);
            }
        });
        this.addInventoryToStorage((ItemStackHandler)this.input, "input");
        this.storage = new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                BlackHoleControllerTile.this.func_70296_d();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
        this.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.storage, EnumDyeColor.YELLOW, "Black hole units", new BoundingRectangle(15, 40, 162, 18)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return stack.func_77973_b().equals(Item.func_150898_a((Block)BlockRegistry.blackHoleUnitBlock));
            }

            public boolean canExtractItem(int slot) {
                return super.canExtractItem(slot);
            }
        });
        this.addInventoryToStorage(this.storage, "storage");
        this.output = new LockableItemHandler(9){

            protected void onContentsChanged(int slot) {
                BlackHoleControllerTile.this.func_70296_d();
            }
        };
        this.addInventory((IItemHandler)new ColoredItemHandler((IItemHandler)this.output, EnumDyeColor.ORANGE, "Output items", new BoundingRectangle(15, 63, 162, 18)){

            public boolean canInsertItem(int slot, ItemStack stack) {
                return false;
            }

            public boolean canExtractItem(int slot) {
                return true;
            }
        });
        this.addInventoryToStorage((ItemStackHandler)this.output, "output");
    }

    protected boolean supportsAddons() {
        return false;
    }

    protected void innerUpdate() {
        if (WorkUtils.isDisabled(this.func_145838_q())) {
            return;
        }
        this.input.setLocked(this.output.getLocked());
        this.input.setFilter(this.output.getFilter());
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.storage.getStackInSlot(i);
            if (!stack.func_190926_b()) {
                if (this.output.getStackInSlot(i).func_190916_E() >= this.output.getStackInSlot(i).func_77976_d()) continue;
                int amount = BlockRegistry.blackHoleUnitBlock.getAmount(stack);
                ItemStack s = BlockRegistry.blackHoleUnitBlock.getItemStack(stack);
                if (s.func_190926_b()) continue;
                ItemStack out = this.output.getStackInSlot(i);
                if (out.func_190926_b()) {
                    out = s.func_77946_l();
                    out.func_190920_e(Math.min(amount, s.func_77976_d()));
                    BlockRegistry.blackHoleUnitBlock.setAmount(stack, amount - out.func_190916_E());
                    this.output.setStackInSlot(i, out);
                    if (BlockRegistry.blackHoleUnitBlock.getAmount(stack) > 0 || this.output.getLocked()) continue;
                    stack.func_77982_d(null);
                    continue;
                }
                if (out.func_190916_E() >= out.func_77976_d()) continue;
                int increase = Math.min(amount, out.func_77976_d() - out.func_190916_E());
                out.func_190920_e(out.func_190916_E() + increase);
                BlockRegistry.blackHoleUnitBlock.setAmount(stack, amount - increase);
                if (BlockRegistry.blackHoleUnitBlock.getAmount(stack) > 0 || this.output.getLocked()) continue;
                stack.func_77982_d(null);
                continue;
            }
            if (this.output.getStackInSlot(i).func_190926_b() || this.field_145850_b.field_72995_K) continue;
            float f = 0.7f;
            float d0 = this.field_145850_b.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            float d1 = this.field_145850_b.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            float d2 = this.field_145850_b.field_73012_v.nextFloat() * f + (1.0f - f) * 0.5f;
            EntityItem entityitem = new EntityItem(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + d0), (double)((float)this.field_174879_c.func_177956_o() + d1), (double)((float)this.field_174879_c.func_177952_p() + d2), this.output.getStackInSlot(i).func_77946_l());
            this.output.setStackInSlot(i, ItemStack.field_190927_a);
            this.field_145850_b.func_72838_d((Entity)entityitem);
        }
    }

    public ItemStackHandler getInput() {
        return this.input;
    }

    public ItemStackHandler getStorage() {
        return this.storage;
    }

    public ItemStackHandler getOutput() {
        return this.output;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == null) {
            return false;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void dropItems() {
        for (ItemStackHandler items : new ItemStackHandler[]{this.input, this.storage, this.output}) {
            for (int i = 0; i < items.getSlots(); ++i) {
                ItemStack stack = items.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)this.func_145831_w(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)stack);
            }
        }
    }

    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer<?> container) {
        List pieces = super.getGuiContainerPieces(container);
        pieces.add(new LockedInventoryTogglePiece(153, 83, (SidedTileEntity)this, EnumDyeColor.ORANGE));
        return pieces;
    }

    public boolean getAllowRedstoneControl() {
        return false;
    }

    protected boolean getShowPauseDrawerPiece() {
        return false;
    }

    private class BlackHoleControllerHandler
    implements IItemHandler {
        private BlackHoleControllerTile tile;

        public BlackHoleControllerHandler(BlackHoleControllerTile tile) {
            this.tile = tile;
        }

        public int getSlots() {
            return 9;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (!BlackHoleControllerTile.this.storage.getStackInSlot(slot).func_190926_b()) {
                ItemStack stack = BlockRegistry.blackHoleUnitBlock.getItemStack(BlackHoleControllerTile.this.storage.getStackInSlot(slot)).func_77946_l();
                stack.func_190920_e(BlockRegistry.blackHoleUnitBlock.getAmount(BlackHoleControllerTile.this.storage.getStackInSlot(slot)) + BlackHoleControllerTile.this.output.getStackInSlot(slot).func_190916_E());
                return stack;
            }
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            for (int i = 0; i < 9; ++i) {
                ItemStack contained = BlockRegistry.blackHoleUnitBlock.getItemStack(BlackHoleControllerTile.this.storage.getStackInSlot(i));
                if (!stack.func_77969_a(contained) && (this.tile.getOutput().getStackInSlot(i).func_190926_b() || !this.tile.getOutput().getStackInSlot(i).func_77969_a(stack))) continue;
                return this.tile.getInput().insertItem(i, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            int visualAmount;
            if (BlackHoleControllerTile.this.storage.getStackInSlot(slot).func_190926_b() || amount == 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack existing = BlockRegistry.blackHoleUnitBlock.getItemStack(BlackHoleControllerTile.this.storage.getStackInSlot(slot)).func_77946_l();
            if (existing.func_190926_b() && BlackHoleControllerTile.this.output.getStackInSlot(slot).func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (existing.func_190926_b()) {
                existing = BlackHoleControllerTile.this.output.getStackInSlot(slot);
            }
            if ((visualAmount = BlockRegistry.blackHoleUnitBlock.getAmount(BlackHoleControllerTile.this.storage.getStackInSlot(slot)) + BlackHoleControllerTile.this.output.getStackInSlot(slot).func_190916_E()) <= amount) {
                if (!simulate) {
                    BlockRegistry.blackHoleUnitBlock.setAmount(BlackHoleControllerTile.this.storage.getStackInSlot(slot), 0);
                    BlackHoleControllerTile.this.output.setStackInSlot(slot, ItemStack.field_190927_a);
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)visualAmount);
            }
            if (!simulate) {
                BlockRegistry.blackHoleUnitBlock.setAmount(BlackHoleControllerTile.this.storage.getStackInSlot(slot), Math.max(0, BlockRegistry.blackHoleUnitBlock.getAmount(BlackHoleControllerTile.this.storage.getStackInSlot(slot)) - amount));
                BlackHoleControllerTile.this.output.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)Math.min(existing.func_77976_d(), visualAmount - amount)));
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)amount);
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }
    }
}

