/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.jei.reactor;

import com.buuz135.industrial.jei.reactor.ReactorRecipeWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class ReactorRecipeCategory
implements IRecipeCategory<ReactorRecipeWrapper> {
    private IGuiHelper guiHelper;
    private IDrawable tankOverlay;
    private String title;

    public ReactorRecipeCategory(IGuiHelper guiHelper, String title) {
        this.guiHelper = guiHelper;
        this.tankOverlay = guiHelper.createDrawable(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 1, 207, 12, 48);
        this.title = title;
    }

    public String getUid() {
        return this.title.toLowerCase().replaceAll(" ", "_");
    }

    public String getTitle() {
        return this.title;
    }

    public String getModName() {
        return "Industrial Foregoing";
    }

    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 0, 27, 82, 50);
    }

    @Nullable
    public IDrawable getIcon() {
        return null;
    }

    public void drawExtras(Minecraft minecraft) {
    }

    public void setRecipe(IRecipeLayout recipeLayout, ReactorRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStackGroup = recipeLayout.getItemStacks();
        guiItemStackGroup.init(0, true, 0, 16);
        IGuiFluidStackGroup guiFluidStackGroup = recipeLayout.getFluidStacks();
        guiFluidStackGroup.init(1, false, 57, 1, 12, 48, 200, false, this.tankOverlay);
        guiItemStackGroup.set(0, (List)ingredients.getInputs(ItemStack.class).get(0));
        guiFluidStackGroup.set(1, (List)ingredients.getOutputs(FluidStack.class).get(0));
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return new ArrayList<String>();
    }
}

